/* Mednafen - Multi-system Emulator
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>

#include "pce.h"
#include "input.h"
#include "../movie.h"
#include "../netplay.h"

#define PCE_CONTROLLER_2BUTTON 0
#define PCE_CONTROLLER_6BUTTON 1
#define PCE_CONTROLLER_MOUSE   2

static uint16 *jp_ptr;
//static 
uint16 pce_jp_data[5]; // Accessed in HES playing code
static uint8 sel;
static uint8 read_index = 0;
static uint8 controller_type = 0 ;
static uint8 secondbyte = 0 ;

static uint32	mouse_ReadCount = 0;
static  int32	mouse_ClockCounter = 0;


void MOUSE_Reset()
{
	if ( mouse_ClockCounter >= 7159090/60/2)
	{
		mouse_ReadCount = 0;
		mouse_ClockCounter = 0;
	}
}

extern char m_pcemouseX, m_pcemouseY ;

uint8 MOUSE_ReadDelta()
{
	//0x21,0x28,0x25 straight right, 0x61-0x6F,0x71 right+down, 0x60,0x70,0x20,0x05 = nomove, 
	//0x15 = up
	//0x25 = right
	//0x35 = up+right
	//0x45 = down
	//0x55 = down
	//0x65 = down+right
	//0x75 = down_right
	//0x85 = left
	//0x95 = up left
	//0xa5 = left
	//0xb5 = up left
	//0xc5 = down left
	//0xd5 = down left
	//0xe5 = down left
	//0xf5 = down left
	//m_pcemouseX = (char)0x41 ;

	switch (mouse_ReadCount++)
	{
		case 0: /* read delta x hi */
		{
			return ((uint8)m_pcemouseX) >> 4;
		}

		case 1: /* read delta x lo */
//			printf("dx lo = %d\n", ((Uint8)_DeltaX) & 0xf);
			return ((uint8)m_pcemouseX) & 0xf;

		case 2: /* read delta y hi */
//			printf("dy hi = %d\n", ((Uint8)_DeltaY) >> 4);
			return ((uint8)m_pcemouseY) >> 4;

		case 3: /* read delta y lo */
			mouse_ReadCount = 0;
			mouse_ClockCounter = 0;
//			printf("dy lo = %d\n", ((Uint8)_DeltaY) & 0xf);
			return ((uint8)m_pcemouseY) & 0xf;
	}

	return 0;
}


uint8 MOUSE_ReadButtons()
{
	return (  0xB0 | (pce_jp_data[0] & 0x0F) ^ 0x0F ) ;
	//return 0xFF ;
	//return ( (pce_jp_data[0] & 0x0F)  ) ;
}


void MOUSE_AdvanceClock( int32 cycles)
{
	mouse_ClockCounter += cycles;
}

void PCEINPUT_SetInputType( int type)
{
	controller_type = type ;
}

void PCEINPUT_SetInput(int port, int type, void *ptr, int attrib)
{
 jp_ptr = (uint16 *)ptr;
}

void INPUT_Frame(void)
{
 SFORMAT StateRegs[] =
 {
  SFARRAY16(jp_ptr, 5),
  SFEND
 };
 #ifdef NETWORK
 if(MDFNnetplay)
  NetplayUpdate(jp_ptr);
 #endif
 MDFNMOV_AddJoy(StateRegs);

 for(int x = 0; x < 5; x++)
  pce_jp_data[x] = jp_ptr[x];
}

uint8 INPUT_Read(unsigned int A)
{
 uint8 ret = 0xF;
 int tmp_ri = read_index;

 if(tmp_ri > 4)
  ret ^= 0xF;
 else
 {
	switch( controller_type )
	{
		case PCE_CONTROLLER_6BUTTON :
		{
			if ( secondbyte )
			{
				if(sel & 1)
				{
					ret ^= 0x0F ;
					secondbyte = 0 ;
				}
				else
				{
					ret ^= pce_jp_data[tmp_ri] & 0x0F;
				}
			}
			else
			{
				if(sel & 1)
				{
					ret ^= (pce_jp_data[tmp_ri] >> 4)&0x0F;
					secondbyte = 1 ;
				}
				else
					ret ^= (pce_jp_data[tmp_ri] >> 8)&0x0F;
			}
			break ;
		}
		case PCE_CONTROLLER_MOUSE:
		{
			//if (tmp_ri == 0) 
			{
				if ( ( sel & 1 )  && (tmp_ri == 0) )
				{
					return  ( /*0x0F ^*/ MOUSE_ReadDelta() ) ;
				}
				else
				{
					return MOUSE_ReadButtons();
				}
			}
			if ( 0 )//else
			{
				if(sel & 1)
					ret ^= (pce_jp_data[tmp_ri] >> 4)&0x0F;
				else
					ret ^= pce_jp_data[tmp_ri] & 0x0F;
			}
			break ;
		}
		case PCE_CONTROLLER_2BUTTON :
		default:
		{
			if(sel & 1)
				ret ^= (pce_jp_data[tmp_ri] >> 4)&0x0F;
			else
				ret ^= pce_jp_data[tmp_ri] & 0x0F;
			break ;
		}
	}
 }
 return(0x80 | 0x30 | ret); // always-set bits | return value.  Simple as pumpkin doughnuts!
}

void INPUT_Write(unsigned int A, uint8 V)
{
 if((V & 1) && !(sel & 2) && (V & 2))
 {
  read_index = 0;
  MOUSE_Reset();
 }
 else if((V & 1) && !(sel & 1))
 //else if((V & 3)==1)
 {
  if(read_index < 255)
   read_index++;
 }
 sel = V & 3;
}


int INPUT_StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFARRAY16(pce_jp_data, 5),
  SFVAR(sel),
  SFVAR(read_index),
  SFVAR(controller_type),
  SFVAR(secondbyte),
  SFEND
 };
 int ret =  MDFNSS_StateAction(sm, load, data_only, StateRegs, "JOY");
 
 return(ret);
}
