/* Mednafen - Multi-system Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 IRQCount, IRQa ;
static uint8 CHRBanks[8]={0,0,0,0,0,0,0,0};
static uint8 PRGBanks[8]={0,0,0,0,0,0,0,0};

//#define VROM_BANK2 setchr2
//#define ROM_BANK8 setprg8

void /*FASTAPASS(2)*/ VROM_BANK2(uint32 A,uint32 V)
{
 setchr2(A,V);
 CHRBanks[(A)>>10]=(V<<1);
 CHRBanks[((A)>>10)+1]=(V<<1)+1;
}

//void /*FASTAPASS(2)*/ ROM_BANK8(uint32 A, uint32 V)
//{
 //setprg8(A,V);
 //if(A>=0x8000)
  //PRGBankList[((A-0x8000)>>13)]=V;
//}


static void DoCHR(void)
{
 setchr2(0x0000, (CHRBanks[0] )) ; //>> 1) ) ;
 setchr2(0x0800, (CHRBanks[1] )) ; //>> 1) - 1 ) ;
 setchr2(0x1000, (CHRBanks[2] )) ; //>> 1) - 2 ) ;
 setchr2(0x1800, (CHRBanks[3] )) ; //>> 1) - 3 ) ;

 //for(int x = 0; x < 4; x++)
  //setchr1(0x1000 + x * 1024, CHRBanks[2 + x]);
}

static void DoPRG(void)
{
 int x;
 for(x = 0; x < 2; x++)
  setprg8(0x8000 + x * 8192, PRGBanks[x]);
}



static DECLFW(Mapper91_write)
{
//if(A>=0x7001)
//printf("$%04x:$%02x, %d\n",A,V,scanline);
 A&=0xF007;

 if(A>=0x6000 && A<=0x6003){ CHRBanks[A&3] = V ; DoCHR() ; } // VROM_BANK2((A&3)*2048,V);
 else switch(A&0xF003)
 {
  case 0x7000:
  case 0x7001:PRGBanks[A&1] = V; DoPRG();break; //ROM_BANK8(0x8000+(A&1)*8192,V);break;
  case 0x7002:IRQa=IRQCount=0;X6502_IRQEnd(MDFN_IQEXT);break;
  case 0x7003:IRQa=1;X6502_IRQEnd(MDFN_IQEXT);break;
//  default: printf("Iyee: $%04x:$%02x\n",A,V);break;
 }
 //if(A>=0x7000)
 // printf("$%04x:$%02x, %d\n",A,V,scanline);
}

static void Mapper91_hb(void)
{
 if(IRQCount<8 && IRQa)
 {
  IRQCount++;
  if(IRQCount>=8)
  {
    X6502_IRQBegin(MDFN_IQEXT);   
  } 
 }
}


static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(IRQCount),
  SFVAR(IRQa),
  SFARRAY16(CHRBanks, 8),
  SFARRAY16(PRGBanks, 8),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "M091");

 return(ret);
}
static void Power(CartInfo *info)
{
 IRQCount = IRQa = 0;
 for ( int i = 0 ; i < 8 ; i++ )
 {
	CHRBanks[i]=0 ;
	PRGBanks[i]=0 ;
 }

 DoCHR() ;
 DoPRG() ;
}


int Mapper91_Init(CartInfo *info)
{
	setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);

	
	SetWriteHandler(0x4020,0xFFFF,Mapper91_write);
 SetReadHandler(0x8000, 0xFFFF, CartBR);
  GameHBIRQHook=Mapper91_hb;


 info->Power = Power;
 info->StateAction = StateAction;
 return(1);
} 
