/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint32 lastA ;

static DECLFW(Mapper61_write)
{
	lastA = A ;

// printf("$%04x:$%02x\n",A,V);
 switch(A&0x30)
 {
  case 0x00:
  case 0x30:
          setprg32(0x8000, A&0xF);
          break;
  case 0x20:
  case 0x10:
          setprg16(0x8000,((A&0xF)<<1)| (((A&0x20)>>4)) );
          setprg16(0xC000,((A&0xF)<<1)| (((A&0x20)>>4)) );
          break;
 }
 #ifdef moo
 if(!(A&0x10))
  setprg32(0x8000, A&0xF);
 else
 {
  setprg16(0x8000,((A&0xF)<<1)| (((A&0x10)>>4)^1) );
  setprg16(0xC000,((A&0xF)<<1)| (((A&0x10)>>4)^1) );
 }
 #endif
 setmirror((A&0x80)>>7 ? MI_H : MI_V );
}

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper61_write( lastA, 0 ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
}

int Mapper61_Init(CartInfo *info)
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

 SetWriteHandler(0x8000,0xffff,Mapper61_write);

 return 1 ;
}
