/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 lastV ;
static uint32 lastA ;

static DECLFW(M58Write)
{
	lastA = A ;
	lastV = V ;
 //printf("$%04x:$%02x\n",A,V);
 if(A&0x40)
 {
  setprg16(0x8000,(A&0x07));
  setprg16(0xc000,(A&0x07));
 }
 else
  setprg32(0x8000, (A&0x06)>>1);

 setchr8((A&0x38)>>3);
 setmirror((V&2)>>1 ? MI_V : MI_H );
}

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFVAR(lastV),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  M58Write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = 0 ;
 lastV = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
}

int Mapper58_Init(CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	//setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	//setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

 setprg32(0x8000,0);
 setchr8(0);
 SetWriteHandler(0x8000,0xFFFF,M58Write);

 return 1 ;
}
