/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 IRQa, lastV ;
static int32 IRQCount ;
static uint32 lastA ;

static DECLFW(Mapper40_write)
{
 switch(A&0xe000)
 {
  case 0x8000:IRQa=0;IRQCount=0;X6502_IRQEnd(MDFN_IQEXT);break;
  case 0xa000:IRQa=1;break;
  case 0xe000:setprg8(0xc000,V&7);break;
 }
}

static void Mapper40IRQ(int a)
{
 if(IRQa)
 {
        if(IRQCount<4096)
         IRQCount+=a;
        else
        {
         IRQa=0;
         X6502_IRQBegin(MDFN_IQEXT);
        }
 }
}

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(IRQa),
  SFVAR(lastA),
  SFVAR(lastV),
  SFVAR(IRQCount),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper40_write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
	IRQa = IRQCount = lastA = 0 ;
	setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
  setprg8(0x6000,(~0)-1);
  setprg8(0x8000,(~0)-3);
  setprg8(0xa000,(~0)-2);
}

int Mapper40_Init(CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

  setprg8(0x6000,(~0)-1);
  setprg8(0x8000,(~0)-3);
  setprg8(0xa000,(~0)-2);
  SetWriteHandler(0x8000,0xffff,Mapper40_write);
  SetReadHandler(0x6000,0x7fff,CartBR);
  MapIRQHook=Mapper40IRQ;
  return 1 ;
}


