#include <vorbis/vorbisfile.h>
#include <sndfile.h>
#include <stdio.h>

typedef struct __CDRFILE_TRACK_INFO
{
        lsn_t LSN;
        track_format_t Format;
	bool IsData2352;
        lba_t pregap;
	lba_t index;
	lba_t sectors;	// Not including pregap sectors!
        FILE *fp;
	bool FirstFileInstance;
	bool IsMP3 ;

        SNDFILE *sf;
	SF_INFO sfinfo;

        OggVorbis_File ovfile;
} CDRFILE_TRACK_INFO;

typedef struct __CDRFile
{
        track_t NumTracks;
        track_t FirstTrack;
	lba_t total_sectors;
        CDRFILE_TRACK_INFO Tracks[100]; // Track #0(HMM?) through 99
	CdIo *p_cdio;
} CDRFile;

CDRFile *cdrfile_open(const char *path);
lba_t cdrfile_get_track_lsn(const CDRFile *p_cdrfile, track_t i_track);
int cdrfile_read_audio_sector (const CDRFile *p_cdrfile, void *buf, lsn_t lsn, lsn_t lsn_start, lsn_t lsn_end);
track_t cdrfile_get_num_tracks (const CDRFile *p_cdrfile);
track_format_t cdrfile_get_track_format(const CDRFile *p_cdrfile, track_t i_track);
track_t cdrfile_get_first_track_num(const CDRFile *p_cdrfile);
int cdrfile_read_mode1_sector (const CDRFile *p_cdrfile, void *buf, lsn_t lsn, bool b_form2);
int cdrfile_read_mode1_sectors (const CDRFile *p_cdrfile, void *buf, lsn_t lsn, bool b_form2, unsigned int i_sectors);
uint32_t cdrfile_stat_size (const CDRFile *p_cdrfile);

