#ifndef __PCFX_VDC_H
#define __PCFX_VDC_H

typedef struct
{
        uint32 display_counter;

        int32 sat_dma_slcounter;

        uint8 select;
        uint16 MAWR;    // Memory Address Write Register
        uint16 MARR;    // Memory Address Read Register
        uint16 CR;      // Control Register
        uint16 RCR;     // Raster Compare Register
        uint16 BXR;     // Background X-Scroll Register
        uint16 BYR;     // Background Y-Scroll Register
        uint16 MWR;     // Memory Width Register

        uint16 HSR;     // Horizontal Sync Register
        uint16 HDR;     // Horizontal Display Register
        uint16 VSR;
        uint16 VDR;

        uint16 VCR;
        uint16 DCR;
        uint16 SOUR;
        uint16 DESR;
        uint16 LENR;
        uint16 SATB;

        uint32 RCRCount;

        uint16 read_buffer;
        uint8 write_latch;
        uint8 status;

	uint16 dummyfoo[0x100];
        uint16 SAT[0x100];
	uint16 dummy1[65536];
        uint16 VRAM[65536];
	uint16 dummy2[65536];
        uint8 bg_tile_cache[2048 * 2][8][8] __attribute__ ((aligned (8))); // Tile, y, x

        uint16 DMAReadBuffer;
        bool8 DMAReadWrite;
        bool8 DMARunning;
        bool8 SATBPending;
        bool8 burst_mode;

        uint32 BG_YOffset;      // Reloaded from BYR at start of display area?
        uint32 BG_XOffset;      // Reloaded from BXR at each scanline, methinks.

        unsigned int VDS_cache;
        unsigned int VSW_cache;
        unsigned int VDW_cache;
        unsigned int VCR_cache;
        unsigned int VBlankFL_cache;
        unsigned int dot_clock;

        unsigned int ilevel;

	uint16 line_BXR_Cache, line_BYR_Cache;

	uint32 LayerDisable;

	uint32 Aux0BPBase;
} fx_vdc_t;

void FXVDC_Reset(fx_vdc_t *vdc);
void FXVDC_Power(fx_vdc_t *vdc);

void FXVDC_Write(fx_vdc_t *vdc, uint32 A, uint8 V);
uint8 FXVDC_Read(fx_vdc_t *vdc, uint32 A);

void FXVDC_SetDotClock(fx_vdc_t *vdc, unsigned int);

fx_vdc_t *FXVDC_Init(int ilevel);

void FXVDC_DoLinePost(fx_vdc_t *vdc, uint32 frame_counter);

void FXVDC_DoLine(fx_vdc_t *vdc, uint32 frame_counter, uint32 *linebuffer, int skip);
int FXVDC_StateAction(StateMem *sm, int load, int data_only, fx_vdc_t *vdc, const char *name);

bool FXVDC_ToggleLayer(fx_vdc_t *vdc, int which);
void FXVDC_DoGfxDecode(fx_vdc_t *vdc, uint32 *palette_ptr, uint32 *target, int w, int h, int scroll, bool DecodeSprites);

void FXVDC_SetAux0BPBpase(fx_vdc_t *vdc, uint32 new_base); // pass ~0 to disable
#endif
