#ifndef __PCFX_PCFX_H
#define __PCFX_PCFX_H

#include "../types.h"
#include "../mednafen.h"
#include "../state.h"
#include "../general.h"
#include "../memory.h"

#include "v810_cpu.h"
#include "vdc.h"

uint8 mem_rbyte(uint32 A);
uint16 mem_rhword(uint32 A);
uint32 mem_rword(uint32 A);
void mem_wbyte(uint32 A, uint8 V);
void mem_whword(uint32 A, uint16 V);
void mem_wword(uint32 A, uint32 V);

uint8 port_rbyte(uint32 A);
uint16 port_rhword(uint32 A);
uint32 port_rword(uint32 A);
void port_wbyte(uint32 A, uint8 V);
void port_whword(uint32 A, uint16 V);
void port_wword(uint32 A, uint32 V);

extern fx_vdc_t *fx_vdc_chips[2];

#define REGSETHW(_reg, _data, _msh) { _reg &= 0xFFFF << (_msh ? 0 : 16); _reg |= _data << (_msh ? 16 : 0); }
#define REGGETHW(_reg, _msh) ((_reg >> (_msh ? 16 : 0)) & 0xFFFF)


#ifdef WANT_DEBUGGER
void PCFX_AddASpace(void (*gasb)(const char *name, uint32 Address, uint32 Length, uint8 *Buffer),
        void (*pasb)(const char *name, uint32 Address, uint32 Length, uint32 Granularity, bool hl, const uint8 *Buffer), const char *name, const char *long_name, uint32 TotalBits);
void PCFX_ResetRegGroupsInfo(void);
void PCFX_AddRegGroup(RegGroupType *groupie);

#endif

#endif
