/* Mednafen - Multi-system Emulator
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "main.h"
#include <trio/trio.h>
#include "prompt.h"
#include "../ConvertUTF.h"

HappyPrompt::HappyPrompt(void)
{
        PromptText = "";
	kb_buffer.clear();
        kb_cursor_pos = 0;
}

HappyPrompt::HappyPrompt(const std::string &ptext, const std::string &zestring)
{
        PromptText = "";
        kb_buffer.clear();
        kb_cursor_pos = 0;
	SetText(ptext);
	SetKBB(zestring);
}

HappyPrompt::~HappyPrompt()
{

}

void HappyPrompt::TheEnd(const std::string &pstring)
{


}

void HappyPrompt::SetText(const std::string &ptext)
{
 PromptText = ptext;
}

void HappyPrompt::SetKBB(const std::string &zestring)
{
 for(unsigned int x = 0; x < zestring.size(); x++)
 {
  char short_buf[2];

  short_buf[0] = zestring[x];
  short_buf[1] = 0;

  kb_buffer.push_back(std::string(short_buf));
  kb_cursor_pos++;
 }
}

#define MK_COLOR_A(r,g,b,a) ( ((a)<<surface->format->Ashift) | ((r)<<surface->format->Rshift) | ((g) << surface->format->Gshift) | ((b) << surface->format->Bshift))

void HappyPrompt::Draw(SDL_Surface *surface, const SDL_Rect *rect)
{
 std::string PromptAnswer;

 for(unsigned int i = 0; i < kb_buffer.size(); i++)
  PromptAnswer += kb_buffer[i];

/*
******************************
* PC                         *
* F00F                       *
******************************
*/
 uint32 *pixels = (uint32 *)surface->pixels;
 uint32 pitch32 = surface->pitch >> 2;

 pixels += ((rect->h / 2) - (4 * 7 / 2)) * pitch32;
 pixels += ((rect->w / 2) - (5 * 39 / 2));

 for(unsigned int y = 0; y < 4 * 7; y++)
 {
  uint32 *row = pixels + y * pitch32;
  for(unsigned int x = 0; x < 39 * 5; x++)
   row[x] = MK_COLOR_A(0x00, 0x00, 0x00, 0xFF);
 }

 DrawTextTrans(pixels, surface->pitch, 39 * 5, (UTF8 *)               "╭────────────────────────────────────╮", MK_COLOR_A(0xFF,0xFF,0xFF,0xFF), 0, 1);
 DrawTextTrans(pixels + 7 * pitch32, surface->pitch, 39 * 5, (UTF8 *) "│                                    │", MK_COLOR_A(0xFF,0xFF,0xFF,0xFF), 0, 1);
 DrawTextTrans(pixels + 14 * pitch32, surface->pitch, 39 * 5, (UTF8 *)"│                                    │", MK_COLOR_A(0xFF,0xFF,0xFF,0xFF), 0, 1);
 DrawTextTrans(pixels + 21 * pitch32, surface->pitch, 39 * 5, (UTF8 *)"╰────────────────────────────────────╯", MK_COLOR_A(0xFF,0xFF,0xFF,0xFF), 0, 1);

 DrawTextTrans(pixels + 7 * pitch32 + 2 * 5, surface->pitch, (39 - 4) * 5, (UTF8 *)PromptText.c_str(), MK_COLOR_A(0xFF, 0x00, 0xFF, 0xFF), 0, 1);
 DrawTextTrans(pixels + 15 * pitch32 + 2 * 5, surface->pitch, (39 - 4) * 5, (UTF8 *)PromptAnswer.c_str(), MK_COLOR_A(0x00, 0xFF, 0x00, 0xFF), 0, 1);

 if((SDL_GetTicks() & 0x80) && kb_cursor_pos < (39 - 4))
  DrawTextTrans(pixels + 14 * pitch32 + 2 * 5 + kb_cursor_pos * 5, surface->pitch, 5, (UTF8*)"▉", MK_COLOR_A(0x00, 0xFF, 0x00, 0xFF), 0, 1);
}

void HappyPrompt::Event(const SDL_Event *event)
{
 if(event->type == SDL_KEYDOWN)
 {
  switch(event->key.keysym.sym)
  {
   case SDLK_HOME:
        kb_cursor_pos = 0;
        break;
   case SDLK_END:
        kb_cursor_pos = kb_buffer.size();
        break;
   case SDLK_LEFT:
        if(kb_cursor_pos)
         kb_cursor_pos--;
        break;
   case SDLK_RIGHT:
        if(kb_cursor_pos < kb_buffer.size())
         kb_cursor_pos++;
        break;
   case SDLK_RETURN:
        {
         std::string concat_str;

         for(unsigned int i = 0; i < kb_buffer.size(); i++)
          concat_str += kb_buffer[i];

	 TheEnd(concat_str);
         kb_buffer.clear();
         kb_cursor_pos = 0;
	}
	break;

         case SDLK_BACKSPACE:
                if(kb_buffer.size() && kb_cursor_pos)
                {
                  kb_buffer.erase(kb_buffer.begin() + kb_cursor_pos - 1, kb_buffer.begin() + kb_cursor_pos);
                  kb_cursor_pos--;
                }
                break;
          case SDLK_DELETE:
                if(kb_buffer.size() && kb_cursor_pos < kb_buffer.size())
                {
                 kb_buffer.erase(kb_buffer.begin() + kb_cursor_pos, kb_buffer.begin() + kb_cursor_pos + 1);
                }
                break;
          default:
           if(event->key.keysym.unicode)
           {
            uint8 utf8_buffer[8];
            UTF8 *dest_ptr = utf8_buffer;
            memset(utf8_buffer, 0, sizeof(utf8_buffer));
            const UTF16 *start_utf16 = &event->key.keysym.unicode;
            ConvertUTF16toUTF8(&start_utf16, (UTF16 *)&event->key.keysym.unicode + 1, &dest_ptr, &utf8_buffer[8], lenientConversion);
            kb_buffer.insert(kb_buffer.begin() + kb_cursor_pos, std::string((char *)utf8_buffer));
            kb_cursor_pos++;
           }
           break;
  }
 }
}
