#ifndef _MDFN_DRIVERS_INPUT_H
#define _MDFN_DRIVERS_INPUT_H
#define MAXBUTTCONFIG   4
typedef struct {
        uint8  ButtType[MAXBUTTCONFIG];
        uint8  DeviceNum[MAXBUTTCONFIG];
        uint32 ButtonNum[MAXBUTTCONFIG];
        uint32 NumC;
	uint64 DeviceID[MAXBUTTCONFIG];
} ButtConfig;

void MakeInputConfigStruct(void);

extern CFGSTRUCT InputConfig[];

#define BUTTC_KEYBOARD          0x00
#define BUTTC_JOYSTICK          0x01
#define BUTTC_MOUSE             0x02

void InitOtherInput(MDFNGI *GI);
void InputUserActiveFix(void);

bool MDFND_ValidateNESInputPort(const char *name, const char *value);
bool MDFND_ValidateFamicomExpansionPort(const char *name, const char *value);
int MDFND_CKConfig(char *name, char *text);
int MDFND_InputCfg(char *name, char *text);
void MDFND_UpdateInput(void);

#define MKK(k) SDLK_##k
#define MKK_COUNT (SDLK_LAST+1)
#endif
