#ifndef _MDFN_SETTINGS_COMMON_H
#define _MDFN_SETTINGS_COMMON_H
typedef enum
{
        MDFNST_INT,     // (signed), int8, int16, int32, int64(saved as)
        MDFNST_UINT,    // uint8, uint16, uint32, uint64(saved as)
        MDFNST_BOOL,    // bool. bool. bool!
        MDFNST_FLOAT,   // float, double(saved as).
	MDFNST_STRING
} MDFNSettingType;

typedef struct
{
        const char *name;
        const char *description; // Short
        MDFNSettingType type;
        const char *default_value;
	const char *minimum;
	const char *maximum;
	bool (*validate_func)(const char *name, const char *value);
} MDFNSetting;

typedef struct __MDFNCS
{
        char *name;
        char *value;
	const MDFNSetting *desc;
        uint64 name_hash;
} MDFNCS;

#endif
