#ifndef _DEBUG_H
#define _DEBUG_H

#include "debug-driver.h"

#ifdef MDFNDEF_DEBUGGER

/* Type attributes, you can OR them together. */
#define BPOINT_READ		1
#define BPOINT_WRITE		2
#define BPOINT_PC		4

#include "x6502struct.h"

void MDFNI_SetCPUCallback(void (*callb)(X6502 *X));
int MDFNI_DeleteBreakPoint(uint32 w);
int MDFNI_ListBreakPoints(int (*callb)(int type, unsigned int A1, unsigned int A2,
                void (*Handler)(X6502 *, int type, unsigned int A) ));
int MDFNI_GetBreakPoint(uint32 w, int *type, unsigned int *A1, unsigned int *A2,
                void (**Handler)(X6502 *, int type, unsigned int A));
int MDFNI_SetBreakPoint(uint32 w, int type, unsigned int A1, unsigned int A2,
                void (*Handler)(X6502 *, int type, unsigned int A));
int MDFNI_AddBreakPoint(int type, unsigned int A1, unsigned int A2, 
                void (*Handler)(X6502 *, int type, unsigned int A));
#endif

#endif
