#ifndef _MEDNAFEN_H

#include <stdio.h>

#include "types.h"
#include "gettext.h"

#define _(String) gettext (String)

#include "git.h"

extern MDFNGI *MDFNGameInfo;

typedef struct {
           int NetworkPlay;
	   int SoundVolume;
	   uint32 SndRate;
	   double soundmultiplier;
	   int rshift, gshift, bshift, ashift;
} MDFNS;

#include "settings.h"

extern MDFNS FSettings;

void MDFN_PrintError(const char *format, ...);
void MDFN_printf(const char *format, ...);
void MDFN_DispMessage(UTF8 *format, ...);


void MDFN_LoadGameCheats(FILE *override);
void MDFN_FlushGameCheats(FILE *override, int nosave);
void MDFN_DoSimpleCommand(int cmd);
void MDFN_QSimpleCommand(int cmd);

#include "mednafen-driver.h"

#define _MEDNAFEN_H
#endif
