#ifndef _GIT_H
#define _GIT_H

#include "file.h"

#define GIT_CART        0       /* Cart. */
#define GIT_VSUNI       1       /* VS Unisystem. */
#define GIT_FDS         2       /* Famicom Disk System. */
#define GIT_NSF         3       /* NES Sound Format. */

#define GIV_NTSC        0       /* NTSC emulation. */
#define GIV_PAL         1       /* PAL emulation. */
#define GIV_USER        2       /* What was set by MDFNI_SetVidSys(). */

#define GISYS_NES       0
#define GISYS_GB        1
#define GISYS_GBA       2
#define GISYS_SNES      3
#define GISYS_PCE	4
#define GISYS_LYNX	5
#define MDFN_EMULATED_SYSTEM_COUNT	6

typedef struct {
        int type;       /* GIT_* */
        int vidsys;     /* Current emulated video system; GIV_* */
        int input[2];   /* Desired input for emulated input ports 1 and 2; -1
                           for unknown desired input. */
        int inputfc;    /* Desired Famicom expansion port device. -1 for unknown
                           desired input. */
        int cspecial;   /* Special cart expansion: DIP switches, barcode
                           reader, etc.
                        */
} MDFNGI_NES;

#include "state.h"
#include "settings-common.h"

#define CONTROLLERDT_UINT8	0
#define CONTROLLERDT_UINT16	1
#define CONTROLLERDT_UINT32	2
#define CONTROLLERDT_UINT64	3
typedef struct
{
 int total_controllers; // Total controllers offered by the system.
 int controller_data_type; // Controller data type.
} NetplaySystemInfoStruct;

typedef struct
{
 /* Semi-private: */
 int system;

 /* Private functions to Mednafen.  Do not call directly
    from the driver code, or else bad things shall happen.  Maybe.  Probably not, but don't
    do it(yet)!
 */
 char *shortname;
 int (*Load)(const char *name, MDFNFILE *fp);
 int (*LoadCD)(void);
 void (*CloseGame)(void);
 bool (*ToggleLayer)(int which);
 const char *LayerNames;
 int (*StateAction)(StateMem *sm, int load, int data_only);
 void (*DoRewind)(void);
 void (*Emulate)(uint32 *pXBuf, MDFN_Rect *LineWidths, float **SoundBuf, int32 *SoundBufSize, int skip);
 void (*SetPixelFormat)(int rshift, int gshift, int bshift);
 void (*SetInput)(int port, int type, void *ptr, int attrib);
 void (*SetSoundMultiplier)(double multiplier);
 void (*SetSoundVolume)(uint32 volume);
 void (*Sound)(int32 Rate);
 void (*DoSimpleCommand)(int cmd);
 bool (*StartNetplay)(NetplaySystemInfoStruct *);

 MDFNSetting *Settings;

 uint32 fps; // frames per second * 65536 * 256, truncated
 void *fb;
 int width, height;
 int current_width;
 int pitch;
 MDFN_Rect DisplayRect;

 int rotated;
 uint8 *name;    /* Game name, UTF8 encoding */
 uint8 MD5[16];
 int soundrate;  /* For Ogg Vorbis expansion sound wacky support.  0 for default. */
 int soundchan;  /* Number of sound channels. */

 MDFNGI_NES nes;

 /* Private to Mednafen: */
 int rshift, gshift, bshift;
} MDFNGI;
#endif
