/* Mednafen - Multi-system Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "types.h"
#include "mednafen.h"

#include "general.h"
#include "state.h"
#include "movie.h"

#include "md5.h"

static char BaseDirectory[2048];
static char FileBase[2048];
static char FileExt[2048];	/* Includes the . character, as in ".nes" */

static char FileBaseDirectory[2048];

void MDFNI_SetBaseDirectory(char *dir)
{
 strncpy(BaseDirectory,dir,2047);
 BaseDirectory[2047]=0;
}

std::string MDFN_MakeFName(int type, int id1, const char *cd1)
{
 char tmp_path[4096];
 char numtmp[64];
 struct stat tmpstat;
 int tmp_dfmd5 = MDFN_GetSettingB("dfmd5");;
 std::string overpath;

 switch(type)
 {
  default: tmp_path[0] = 0;break;
  case MDFNMKF_NPTEMP: snprintf(tmp_path, 4096, "%s"PSS"m590plqd94fo.tmp",BaseDirectory);break;
  case MDFNMKF_MOVIE: overpath = MDFN_GetSettingS("path_movie");
		     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%s.%d.mcm", overpath.c_str(),FileBase,id1);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"mcm"PSS"%s.%d.mcm",BaseDirectory,FileBase,id1);
                     if(tmp_dfmd5 && stat(tmp_path, &tmpstat)==-1)
                     {  
                      if(overpath != "" && overpath != "0")
                       snprintf(tmp_path, 4096, "%s"PSS"%s.%s.%d.mcm",overpath.c_str(),FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),id1);
                      else
                       snprintf(tmp_path, 4096, "%s"PSS"mcm"PSS"%s.%s.%d.mcm",BaseDirectory,FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),id1);
                     }
		     break;
  case MDFNMKF_STATE:
		     overpath = MDFN_GetSettingS("path_state");
		     sprintf(numtmp, "nc%d", id1);
		     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%s.%s",overpath.c_str(), FileBase,cd1?cd1:numtmp);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"mcs"PSS"%s.%s",BaseDirectory,FileBase,cd1?cd1:numtmp);
		     if(tmp_dfmd5 && stat(tmp_path, &tmpstat)==-1)
		     {
		      if(overpath != "" && overpath != "0")
                       snprintf(tmp_path, 4096, "%s"PSS"%s.%s.%s",overpath.c_str(), FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),cd1?cd1:numtmp);
                      else
                       snprintf(tmp_path, 4096, "%s"PSS"mcs"PSS"%s.%s.%s",BaseDirectory,FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),cd1?cd1:numtmp);
		     }
                     break;
  case MDFNMKF_SNAP_DAT:
		    overpath = MDFN_GetSettingS("path_snap");
                    if(MDFN_GetSettingB("snapname"))
                    {
		     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%s.txt",overpath.c_str(), FileBase);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"snaps"PSS"%s.txt",BaseDirectory,FileBase);
                    }
                    else
                    {
                     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"global.txt",overpath.c_str());
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"snaps"PSS"global.txt",BaseDirectory);
                    }
		    break;
  case MDFNMKF_SNAP:
		    overpath = MDFN_GetSettingS("path_snap");
		    if(MDFN_GetSettingB("snapname"))
		    {
                     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%s-%d.%s",overpath.c_str(),FileBase,id1,cd1);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"snaps"PSS"%s-%d.%s",BaseDirectory,FileBase,id1,cd1);
		    }
		    else
		    {
		     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%d.%s",overpath.c_str(),id1,cd1);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"snaps"PSS"%d.%s",BaseDirectory,id1,cd1);
		    }
                    break;
  case MDFNMKF_FDS:overpath = MDFN_GetSettingS("path_sav");
		   if(overpath != "" && overpath != "0")
		    snprintf(tmp_path, 4096, "%s"PSS"%s.%s.fds",overpath.c_str(),FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str());
		   else
	 	    snprintf(tmp_path, 4096, "%s"PSS"sav"PSS"%s.%s.fds",BaseDirectory,FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str());
		   break;
  case MDFNMKF_SAV:overpath = MDFN_GetSettingS("path_sav");
		   if(overpath != "" && overpath != "0")
                    snprintf(tmp_path, 4096, "%s"PSS"%s.%s",overpath.c_str(),FileBase,cd1);
	           else
                    snprintf(tmp_path, 4096, "%s"PSS"sav"PSS"%s.%s",BaseDirectory,FileBase,cd1);
                   if(tmp_dfmd5 && stat(tmp_path,&tmpstat)==-1)
                   {     
                    if(overpath != "" && overpath != "0")
                     snprintf(tmp_path, 4096, "%s"PSS"%s.%s.%s",overpath.c_str(),FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),cd1);
                    else
                     snprintf(tmp_path, 4096, "%s"PSS"sav"PSS"%s.%s.%s",BaseDirectory,FileBase,md5_context::asciistr(MDFNGameInfo->MD5).c_str(),cd1);
                   }
                   break;
  case MDFNMKF_CHEAT:
		     overpath = MDFN_GetSettingS("path_cheat");
		     if(overpath != "" && overpath != "0")
                      snprintf(tmp_path, 4096, "%s"PSS"%s.cht",overpath.c_str(),FileBase);
                     else
                      snprintf(tmp_path, 4096, "%s"PSS"cheats"PSS"%s.cht",BaseDirectory,FileBase);
                     break;
  case MDFNMKF_AUX: snprintf(tmp_path, 4096, "%s"PSS"%s", FileBaseDirectory, (char *)cd1); break;
  case MDFNMKF_IPS:  snprintf(tmp_path, 4096, "%s"PSS"%s%s.ips",FileBaseDirectory,FileBase,FileExt);
                     break;
  case MDFNMKF_GGROM:
		     overpath = MDFN_GetSettingS("nes.ggrom");
		     if(overpath != "" && overpath != "0")
		      strncpy(tmp_path, overpath.c_str(), 4096);
		     else
		      snprintf(tmp_path, 4096, "%s"PSS"gg.rom",BaseDirectory);
		     break;
  case MDFNMKF_LYNXROM: snprintf(tmp_path, 4096, "%s"PSS"lynxboot.img",BaseDirectory);break;
  case MDFNMKF_FDSROM:snprintf(tmp_path, 4096, "%s"PSS"disksys.rom",BaseDirectory);break;
  case MDFNMKF_PALETTE:
		       overpath = MDFN_GetSettingS("path_palette");
		       if(overpath != "" && overpath != "0")
                        snprintf(tmp_path, 4096, "%s"PSS"%s.pal",overpath.c_str(),FileBase);
                       else
                        snprintf(tmp_path, 4096, "%s"PSS"gameinfo"PSS"%s.pal",BaseDirectory,FileBase);
                       break;
 }
 return(tmp_path);
}

const char * GetFNComponent(const char *str)
{
 const char *tp1;

 #if PSS_STYLE==4
     tp1=((char *)strrchr(str,':'));
 #elif PSS_STYLE==1
     tp1=((char *)strrchr(str,'/'));
 #else
     tp1=((char *)strrchr(str,'\\'));
  #if PSS_STYLE!=3
  {
     const char *tp3;
     tp3=((char *)strrchr(str,'/'));
     if(tp1<tp3) tp1=tp3;
  }
  #endif
 #endif

 if(tp1)
  return(tp1+1);
 else
  return(str);
}

void GetFileBase(const char *f)
{
        const char *tp1,*tp3;

 #if PSS_STYLE==4
     tp1=((char *)strrchr(f,':'));
 #elif PSS_STYLE==1
     tp1=((char *)strrchr(f,'/'));
 #else
     tp1=((char *)strrchr(f,'\\'));
  #if PSS_STYLE!=3
     tp3=((char *)strrchr(f,'/'));
     if(tp1<tp3) tp1=tp3;
  #endif
 #endif
     if(!tp1)
     {
      tp1=f;
      strcpy(FileBaseDirectory,".");
     }
     else
     {
      memcpy(FileBaseDirectory,f,tp1-f);
      FileBaseDirectory[tp1-f]=0;
      tp1++;
     }

     if(((tp3=strrchr(f,'.'))!=NULL) && (tp3>tp1))
     {
      memcpy(FileBase,tp1,tp3-tp1);
      FileBase[tp3-tp1]=0;
      strcpy(FileExt,tp3);
     }
     else
     {
      strcpy(FileBase,tp1);
      FileExt[0]=0;
     }
}

char *MDFN_FixString(char *str)
{
 char *orig = str;
 if(str)
  while(*str)
  {
   if(*str < 0x20) *str = 0x20;
   str++;
  }
 return(orig);
}

uint32 uppow2(uint32 n)
{
 int x;

 for(x=31;x>=0;x--)
  if(n&(1<<x))
  {
   if(((unsigned)1<<x)!=n)
    return(1<<(x+1));
   break;
  }
 return n;
}

