/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2003 CaH4e3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 lastV ;
static uint32 lastA ;

static DECLFW(Mapper62_write)
{
	lastA = A ;
	lastV = V ;

  setchr8(((A&0x1F)<<2)|(V&0x03));
  if((A&0x20)>>5) {
     setprg16(0x8000,(A&0x40)|((A>>8)&0x3F));
     setprg16(0xc000,(A&0x40)|((A>>8)&0x3F));
  }
  else
     setprg32(0x8000, ((A&0x40)|((A>>8)&0x3F))>>1);
  setmirror((A&0x80)>>7 ? MI_H : MI_V);
}
static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFVAR(lastV),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper62_write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = 0 ;
 lastV = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
        setprg32(0x8000, 0);
}

int Mapper62_Init(CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);
        SetWriteHandler(0x8000,0xffff, Mapper62_write);
        setprg32(0x8000, 0);

		return 1 ;
}


