//
// Copyright (c) 2004 K. Wilkins
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from
// the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such, and must not
//    be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//

//////////////////////////////////////////////////////////////////////////////
//                       Handy - An Atari Lynx Emulator                     //
//                          Copyright (c) 1996,1997                         //
//                                 K. Wilkins                               //
//////////////////////////////////////////////////////////////////////////////
// ROM emulation class                                                      //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This class emulates the system ROM (512B), the interface is pretty       //
// simple: constructor, reset, peek, poke.                                  //
//                                                                          //
//    K. Wilkins                                                            //
// August 1997                                                              //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
// Revision History:                                                        //
// -----------------                                                        //
//                                                                          //
// 01Aug1997 KW Document header added & class documented.                   //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#define ROM_CPP

//#include <crtdbg.h>
//#define   TRACE_ROM

unsigned char bootimg[] = {
 0x38,0x80,0x0a,0x90,0x04,0x8e,0x8b,0xfd,
 0x18,0xe8,0x8e,0x87,0xfd,0xa2,0x02,0x8e,
 0x87,0xfd,0x2a,0x9c,0x8b,0xfd,0xd0,0xeb,
 0x60,0x64,0x01,0xa9,0x00,0x91,0x00,0xc8,
 0xd0,0xfb,0xe6,0x01,0xd0,0xf7,0xa2,0x0d,
 0xbd,0xd8,0xff,0xbc,0xcc,0xff,0x99,0x00,
 0xfd,0xca,0xd0,0xf4,0xbd,0xc1,0xfe,0x9d,
 0x00,0x50,0xe8,0xd0,0xf7,0x64,0x05,0xa9,
 0x02,0x85,0x06,0x64,0x02,0xa9,0x00,0x20,
 0x00,0xfe,0xad,0xb2,0xfc,0xc9,0xfb,0x90,
 0x4c,0x85,0x07,0x9c,0xaf,0xfd,0x9c,0xbf,
 0xfd,0xa2,0x32,0xad,0xb2,0xfc,0x95,0xaa,
 0xca,0x10,0xf8,0x05,0xab,0x05,0xac,0xf0,
 0x34,0xa2,0x02,0xb5,0xaa,0xfd,0x9a,0xff,
 0xca,0x10,0xf8,0xb0,0x28,0x20,0x00,0x50,
 0xb2,0x0b,0xc9,0x15,0xd0,0x1f,0xa5,0x02,
 0xa0,0x32,0x18,0x71,0x0b,0x92,0x05,0xe6,
 0x05,0x88,0xd0,0xf6,0x85,0x02,0xe6,0x07,
 0xd0,0xc7,0xa0,0x02,0x8c,0x8b,0xfd,0xaa,
 0xd0,0x03,0x4c,0x00,0x02,0xe6,0x03,0xd0,
 0x09,0xe6,0x04,0xd0,0x05,0x9c,0x87,0xfd,
 0x80,0xfe,0xa2,0x08,0xbd,0xef,0xff,0xbc,
 0xe6,0xff,0x99,0x00,0xfc,0xca,0x10,0xf4,
 0x9c,0x91,0xfd,0x9c,0x90,0xfd,0x4c,0x26,
 0xfe,0xa9,0x11,0x85,0x0b,0xa9,0x44,0x8d,
 0x71,0x50,0xa9,0xaa,0x85,0x0f,0x20,0x18,
 0x50,0xa5,0x0b,0x85,0x0f,0xa9,0x77,0x85,
 0x0b,0xa0,0x32,0xa9,0x00,0x91,0x0b,0x88,
 0x10,0xfb,0xc8,0xb1,0x0f,0x85,0x0a,0xc6,
 0x08,0xa5,0x0b,0x8d,0x37,0x50,0x8d,0x43,
 0x50,0x8d,0x47,0x50,0x18,0xa2,0x32,0x36,
 0x00,0xca,0x10,0xfb,0x06,0x0a,0x90,0x11,
 0xa2,0x32,0x18,0xb5,0x00,0x75,0xaa,0x95,
 0x00,0xca,0x10,0xf7,0x20,0x5d,0x50,0x90,
 0x03,0x20,0x5d,0x50,0x46,0x08,0xd0,0xd1,
 0xc8,0xc0,0x33,0x90,0xc6,0x60,0xa5,0x0b,
 0x8d,0x6c,0x50,0xb2,0x0b,0xcd,0x9a,0xff,
 0x90,0x18,0xa2,0x32,0xb5,0x00,0xfd,0x9a,
 0xff,0x95,0x00,0xca,0x10,0xf6,0x90,0x0a,
 0xa5,0x0b,0xae,0x71,0x50,0x86,0x0b,0x8d,
 0x71,0x50,0x60,0x05,0x93,0x00,0x00,0x00,
 0x92,0x50,0x80,0x00,0x48,0x00,0x00,0x04,
 0x00,0x04,0xf0,0x04,0xe2,0xea,0x87,0x04,
 0xfa,0xaa,0xb7,0x04,0xf2,0x08,0x97,0x04,
 0xfa,0x4a,0xf7,0x04,0xe2,0xe8,0x87,0x02,
 0xff,0x05,0xb5,0x11,0x68,0xff,0x04,0xb5,
 0xd7,0x2d,0x04,0xb9,0x91,0x0d,0x04,0xb5,
 0xdd,0x4d,0x05,0x19,0x11,0x68,0xff,0x00,
 0xad,0x88,0xfc,0xf0,0x7b,0x68,0x68,0x68,
 0x68,0xa0,0x02,0x8c,0x8b,0xfd,0xc8,0x8c,
 0x8a,0xfd,0x8c,0xf9,0xff,0x64,0x00,0x4c,
 0x19,0xfe,0x35,0xb5,0xa3,0x94,0x28,0x06,
 0xd8,0xa2,0x26,0x95,0xd7,0x71,0xb2,0x3c,
 0xfd,0x56,0x1c,0x4a,0x19,0xb6,0xa3,0xb0,
 0x26,0x00,0x36,0x5a,0x30,0x6e,0x3c,0x4d,
 0x63,0x38,0x1b,0xd4,0x1c,0x13,0x64,0x89,
 0x36,0x4c,0xf2,0xba,0x2a,0x58,0xf4,0xfe,
 0xe1,0xfd,0xac,0x7e,0x79,0x90,0x92,0x95,
 0x94,0x93,0x09,0x08,0xbf,0xaf,0xb0,0xa0,
 0x01,0x00,0x0d,0x20,0x00,0x29,0x1f,0x68,
 0x3e,0x0e,0x00,0x00,0x18,0x9e,0x91,0x11,
 0x10,0x09,0x08,0x06,0x04,0x90,0x92,0x01,
 0x50,0x82,0x20,0x00,0x00,0x00,0x01,0x00,
 0x00,0xf0,0x00,0x30,0x80,0xff,0x80,0xff
};
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "system.h"
#include "rom.h"

extern CErrorInterface *gError;

CRom::CRom(char *romfile)
{
	mWriteEnable=FALSE;
	//strncpy(mFileName,romfile,1024);
	Reset();

	// Initialise ROM
	for(int loop=0;loop<ROM_SIZE;loop++) mRomData[loop]=DEFAULT_ROM_CONTENTS;

	// Load up the file

	memcpy( mRomData, bootimg, ROM_SIZE ) ;

#if 0 
	FILE	*fp;

	if((fp=fopen(mFileName,"rb"))==NULL)
	{
		CLynxException lynxerr;

		strcpy( lynxerr.mDesc, "boot ROM not found" ) ;
		throw(lynxerr);
	}

	// Read in the 512 bytes

	if(fread(mRomData,sizeof(char),ROM_SIZE,fp)!=ROM_SIZE)
	{
		CLynxException lynxerr;

		strcpy( lynxerr.mDesc, "boot ROM cannot be loaded" ) ;
		throw(lynxerr);
	}

	fclose(fp);

	// Check the code that has been loaded and report an error if its a
	// fake version of the bootrom

	UBYTE mRomCheck[16]={0x38,0x80,0x0A,0x90,0x04,0x8E,0x8B,0xFD,
						 0x18,0xE8,0x8E,0x87,0xFD,0xA2,0x02,0x8E};

	static bool firsttime=TRUE;

	if(firsttime)
	{
		firsttime=FALSE;
		for(ULONG loop=0;loop<16;loop++)
		{
			if(mRomCheck[loop]!=mRomData[loop])
			{
				gError->Warning("FAKE LYNXBOOT.IMG - CARTRIDGES WILL NOT WORK\n\n"
								"PLEASE READ THE ACCOMPANYING README.TXT FILE\n\n"
								"(Do not email the author asking for this image)\n");
				break;
			}
		}
	}
#endif
}

void CRom::Reset(void)
{
	// Nothing to do here
}

bool CRom::ContextSave(FILE *fp)
{	
	if(!fprintf(fp,"CRom::ContextSave")) return 0;
	if(!fwrite(mRomData,sizeof(UBYTE),ROM_SIZE,fp)) return 0;
	return 1;
}

bool CRom::ContextLoad(LSS_FILE *fp)
{
	char teststr[100]="XXXXXXXXXXXXXXXXX";
	if(!lss_read(teststr,sizeof(char),17,fp)) return 0;
	if(strcmp(teststr,"CRom::ContextSave")!=0) return 0;

	if(!lss_read(mRomData,sizeof(UBYTE),ROM_SIZE,fp)) return 0;
	return 1;
}


//END OF FILE