#include "osd_freebsd_cd.h"
#include "pce.h"

static int cd_drive_handle = 0;

int osd_cd_init(char* device)
{
  osd_cd_stop_audio();
	return 0 ;
}

void osd_cd_close()
{

  osd_cd_stop_audio();
}

void xbox_read_cd_sector( unsigned char *p, unsigned int sector ) ;

void xbox_stop_audio( ) ;

void osd_cd_resume(void)
{
}
void osd_cd_subchannel_info(unsigned short offset)
{
	put_8bit_addr(offset, 4);
}

void osd_cd_read(UChar* p, UInt32 sector)
{
	if ( CD_emulation == 1 )
	{
		xbox_stop_audio(  ) ;
		xbox_read_cd_sector( p, sector ) ;
		//return 2048 ;
	}
/*
  printf("Reading sector %d\n", sector);
  if (sector < 3590)
  {
	  printf("Invalid sector\n");
	  return 0;
  }
  lseek(cd_drive_handle, 2048 * sector, SEEK_SET);
  read(cd_drive_handle ,p, 2048);
*/
}

void xbox_pause_audio_hugo( int state ) ;

void osd_cd_stop_audio()
{
	xbox_stop_audio(  ) ;
}

void osd_cd_pause()
{
	xbox_pause_audio_hugo( 1 ) ;
}

void osd_cd_unpause()
{
	xbox_pause_audio_hugo( 0 ) ;
}

void osd_cd_track_info(UChar track,
			int* min,
			int* sec,
			int* fra,
			int* control)
{
	*min = bcdbin[CD_track[track].beg_min] ;
	*sec = bcdbin[CD_track[track].beg_sec] ;
	*fra = bcdbin[CD_track[track].beg_fra] ;
	*control = CD_track[track].type ;

}

void osd_cd_nb_tracks(int* first,
		      int* last)
{

 *first = 1 ;
 *last = nb_max_track ;

}


void osd_cd_length(int* min,
                   int* sec,
                   int* fra)
{
	
 *min = 73;
 *sec = 00;
 *fra = 00;

}


void xbox_play_track( UChar track, UChar repeat ) ;
void xbox_play_track_range( UChar track, UChar repeat, unsigned int frame_offset, unsigned int numframes ) ;

void xbox_play_cdda( unsigned int sectorFrom, unsigned int sectorTo, UChar repeat ) ;
void xbox_play_track_range( UChar track, UChar repeat, unsigned int frame_offset, unsigned int numframes ) ;

#define CD_SECS 60
#define CD_FRAMES 75 

UChar playingTrack = 0;

void osd_cd_play_audio_track(UChar track, UChar repeat)
{
	char xmsg[100] ;
	int sectorC ;

	playingTrack = track ;

	sprintf(xmsg, "track=%u,repeat=%u\r\n", track, repeat) ;
	writexbox(xmsg) ;

	if ( CD_emulation == 2 )
	{
		//sprintfx( "going to play xbox track %u\r\n", track ) ;
		xbox_play_track( track, repeat ) ;
	}
	else
	{
		sectorC = ( bcdbin[CD_track[track].beg_min] * CD_SECS * CD_FRAMES ) +
				  ( bcdbin[CD_track[track].beg_sec] * CD_FRAMES ) +
				  ( bcdbin[CD_track[track].beg_fra]  )  ;
		xbox_play_cdda( sectorC, sectorC + CD_track[track].length - 1, repeat ) ;
	}

}




void osd_cd_play_audio_range(
			     UChar min_from,
			     UChar sec_from,
			     UChar fra_from,
			     UChar min_to,
			     UChar sec_to,
			     UChar fra_to, UChar repeat)
{
	UChar track ;
	unsigned int frame_offset ;
	unsigned int numframes ;
	unsigned int sector ;
	unsigned int sectorB ;
	unsigned int sectorC ;

	char xmsg[200] ;

	sector  = ( min_from * CD_SECS * CD_FRAMES ) + ( sec_from * CD_FRAMES ) + fra_from ;
	sectorB = ( min_to * CD_SECS * CD_FRAMES ) + ( sec_to * CD_FRAMES ) + fra_to ;

	if ( CD_emulation == 2 )
	{

		for ( track = nb_max_track; track > 0x01; track--)
		{
			if ((sector >= CD_track[track].beg_lsn) && (sector <= CD_track[track].beg_lsn + CD_track[track].length))
				break;
		}

		sectorC = ( bcdbin[CD_track[track].beg_min] * CD_SECS * CD_FRAMES ) +
				  ( bcdbin[CD_track[track].beg_sec] * CD_FRAMES ) +
				  ( bcdbin[CD_track[track].beg_fra]  )  ;

		numframes = sectorB - sector ;
		frame_offset = sector - sectorC ;
		
		if ( numframes + 10 >= CD_track[track].length )
		{
			numframes = 999999; 
		}

		sprintf( xmsg, "min=%u,sec=%u,frm=%u,min=%u,sec=%u,frm=%u,track=%u,frame_offset=%u,numframes=%u\r\n", min_from, sec_from, fra_from, min_to, sec_to, fra_to, track, frame_offset, numframes ) ;
		writexbox (xmsg) ;

		playingTrack = track ;
		//  20/39 is because ( 1 cd frame = 1/75 seconds ) and ( 1 mp3 frame = 26ms )
		//xbox_play_track_range( track, repeat, (frame_offset*20)/39, (numframes*20)/39 ) ;
		xbox_play_track_range( track, repeat, 0, 9999999 );
	}
	else
	{
		xbox_play_cdda( sector, sectorB, repeat ) ;
	}

}

void osd_cd_status(int *status)
{
      *status = 0;
}
