//-----------------------------------------------------------------------------
// File: WMVCutScene.cpp
//
// Desc: This sample demonstrates how to play back WMV cut scenes using the
//       Direct3D overlay surface
//
// Hist: 10.10.01 - New for Novermber XDK
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>
#include <vector>
#include "zlib.h"
#include "unzip.h"
#include "debugclient.h"
#include "Mp3Player.h"

CDebugClient *g_debugClient ;

#ifdef __cplusplus
extern "C" {
#endif

strcasestr (char *s1, char *s2) ;

#include "pce.h"
//#include "crc_ctl.h"
extern UChar *ROM;
extern int ROM_size;

int hugomain (char* romfilename, char* savefilename, char* savepath, char* cdsystempath, int emulatecd, int forceUS ) ;

//int update_sound_main ();

char global_error_message[1024] ;

//SoundXBOX nothersound ;
//extern SoundXBOX nothersound ;

#ifdef __cplusplus
}
#endif

#include "..\common\undocumented.h"
#include "..\common\iosupport.h"
#include "CDDAXbox.h"


//WCHAR g_buf[1024];
// constants for controller dead zone / speed up banding etc.
const float GAMESEL_cfDeadZone = 0.3f;
const float GAMESEL_cfMaxThresh = 0.93f;
const float GAMESEL_cfMaxPossible = 1.0f;
const float GAMESEL_cfRectifyScale = GAMESEL_cfMaxPossible/(GAMESEL_cfMaxPossible-GAMESEL_cfDeadZone);
const float GAMESEL_cfSpeedBandFastest = 3.0f;	// seconds (don`t worry for PAL NTSC dif xbapp handles that)
const float GAMESEL_cfFastestScrollMult = 10.0f;
const float GAMESEL_cfSpeedBandMedium = 2.0f;	// if the pad is held at max for given seconds list will move faster
const float GAMESEL_cfMediumScrollMult = 5.0f;
const float GAMESEL_cfSpeedBandLowest = 1.0f;
const float GAMESEL_cfLowestScrollMult = 2.0f;


#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define SOUND_1 0x01
#define SOUND_2 0x02
#define SOUND_3 0x04
#define SOUND_4 0x08
#define SOUND_5 0x10
#define SOUND_6 0x20

#define NAMES_PER_PAGE 25
#define MAX_RESIST 1000000.0


#define CONSOLE_MEMORY_SIZE 0x8000


//-----------------------------------------------------------------------------
// Callouts for labelling the gamepad on the help screen
//-----------------------------------------------------------------------------
XBHELP_CALLOUT g_HelpCallouts[] = 
{
    { XBHELP_BACK_BUTTON,  XBHELP_PLACEMENT_2, L"Display help" },
    { XBHELP_A_BUTTON,     XBHELP_PLACEMENT_1, L"Play video" },
    { XBHELP_B_BUTTON,     XBHELP_PLACEMENT_1, L"Stop playback" },
};

#define NUM_HELP_CALLOUTS ( sizeof( g_HelpCallouts ) / sizeof( g_HelpCallouts[0] ) )

SoundXBOX *g_sound ;
CDDAXbox  *g_cdda ;
Mp3Player *g_mp3player ;
float     *g_apptime ;
UINT32    *g_numframes ;
DWORD     g_dwStartTime ;
DWORD     g_dwTimePaused ;

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx, int forceUS, int whichCard ) ;
	virtual void    cleanupConsole( ) ;
	virtual int     handleEvents() ;
	virtual int     init_texture() ;
	virtual int		init_white_texture();
	virtual int		render_to_texture() ;
	virtual void	FindAvailRoms( char *dir ) ;
	virtual void    loadCueSheet( char *cuefile ) ;
	virtual void    doStartSearchMenu() ;
	virtual void    doCodeListMenu() ;
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCheatMenu() ;
	virtual void    doFontSize() ;
	virtual void    doCDGame() ;
	virtual void    doSaveConfig() ;
	virtual void    doScreenSize() ;
	virtual void    doTextOffset() ;
	virtual void    doConfiguration() ;
	virtual void    updateCheats() ;
	virtual void    processEmu( BOOL render ) ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    deleteSaveFiles( int which ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip( char *hugozipfile ) ;
	virtual void    QuickSort( int start, int end ) ;
	virtual UInt16  ReadJoypad( int port );
	void			MenuBar( int xpos, int ypos, int xlen, int ylen ) ;
	

	float fGameSelect;
	float fCursorPos;
	float m_fFrameTime ;
	float fMaxCount;
	int   iGameSelect;
	int   iCursorPos;
	UINT32 m_numFrames ;
	int   keyTime ;
	CIoSupport m_io ;
	HANDLE m_hCdrom ;


	UINT32 topIdx  ;
	UINT32 curr  ;
	CDebugClient m_debugClient ;
	D3DPalette			*m_pd3dPalette ;

    CXBFont     m_Font;             // Font object
    CXBFont     m_FontSmall;             // Font object
    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
		unsigned char isDir ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;
	DWORD    m_dwStartPause ;
	int		m_nbytes ;
	int		m_nXOffset, m_nFontHeight ;
	int		m_namesPerPage ;
	char    m_szCurrentDir[MAX_PATH] ;

	LPDIRECT3DTEXTURE8	Texture;
	LPDIRECT3DTEXTURE8	WhiteTexture;
	LPD3DXSPRITE			Sprite;
	LPD3DXSPRITE			MenuSprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	int					m_droppedFrames ;	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	CDDAXbox			m_cdda;
	Mp3Player			m_mp3player;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_cuefile[500] ;
	char				g_rtcfile[500] ;
	char				g_chtfile[500] ;
	FILE                *m_logfile ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;

	int					m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ;

	typedef struct _cheat_code {
		char code[20] ;
		UINT32 adr ;
		UINT32 val ;
		byte   enabled ;
	} CHEAT_CODE;

	CHEAT_CODE *m_cheatCodes;

	UINT32 m_numCheats ;


};


unsigned long TAB_CONST2[256] = {
   0X0,
   0X77073096,
   0XEE0E612C,
   0X990951BA,
   0X76DC419,
   0X706AF48F,
   0XE963A535,
   0X9E6495A3,
   0XEDB8832,
   0X79DCB8A4,
   0XE0D5E91E,
   0X97D2D988,
   0X9B64C2B,
   0X7EB17CBD,
   0XE7B82D07,
   0X90BF1D91,
   0X1DB71064,
   0X6AB020F2,
   0XF3B97148,
   0X84BE41DE,
   0X1ADAD47D,
   0X6DDDE4EB,
   0XF4D4B551,
   0X83D385C7,
   0X136C9856,
   0X646BA8C0,
   0XFD62F97A,
   0X8A65C9EC,
   0X14015C4F,
   0X63066CD9,
   0XFA0F3D63,
   0X8D080DF5,
   0X3B6E20C8,
   0X4C69105E,
   0XD56041E4,
   0XA2677172,
   0X3C03E4D1,
   0X4B04D447,
   0XD20D85FD,
   0XA50AB56B,
   0X35B5A8FA,
   0X42B2986C,
   0XDBBBC9D6,
   0XACBCF940,
   0X32D86CE3,
   0X45DF5C75,
   0XDCD60DCF,
   0XABD13D59,
   0X26D930AC,
   0X51DE003A,
   0XC8D75180,
   0XBFD06116,
   0X21B4F4B5,
   0X56B3C423,
   0XCFBA9599,
   0XB8BDA50F,
   0X2802B89E,
   0X5F058808,
   0XC60CD9B2,
   0XB10BE924,
   0X2F6F7C87,
   0X58684C11,
   0XC1611DAB,
   0XB6662D3D,
   0X76DC4190,
   0X1DB7106,
   0X98D220BC,
   0XEFD5102A,
   0X71B18589,
   0X6B6B51F,
   0X9FBFE4A5,
   0XE8B8D433,
   0X7807C9A2,
   0XF00F934,
   0X9609A88E,
   0XE10E9818,
   0X7F6A0DBB,
   0X86D3D2D,
   0X91646C97,
   0XE6635C01,
   0X6B6B51F4,
   0X1C6C6162,
   0X856530D8,
   0XF262004E,
   0X6C0695ED,
   0X1B01A57B,
   0X8208F4C1,
   0XF50FC457,
   0X65B0D9C6,
   0X12B7E950,
   0X8BBEB8EA,
   0XFCB9887C,
   0X62DD1DDF,
   0X15DA2D49,
   0X8CD37CF3,
   0XFBD44C65,
   0X4DB26158,
   0X3AB551CE,
   0XA3BC0074,
   0XD4BB30E2,
   0X4ADFA541,
   0X3DD895D7,
   0XA4D1C46D,
   0XD3D6F4FB,
   0X4369E96A,
   0X346ED9FC,
   0XAD678846,
   0XDA60B8D0,
   0X44042D73,
   0X33031DE5,
   0XAA0A4C5F,
   0XDD0D7CC9,
   0X5005713C,
   0X270241AA,
   0XBE0B1010,
   0XC90C2086,
   0X5768B525,
   0X206F85B3,
   0XB966D409,
   0XCE61E49F,
   0X5EDEF90E,
   0X29D9C998,
   0XB0D09822,
   0XC7D7A8B4,
   0X59B33D17,
   0X2EB40D81,
   0XB7BD5C3B,
   0XC0BA6CAD,
   0XEDB88320,
   0X9ABFB3B6,
   0X3B6E20C,
   0X74B1D29A,
   0XEAD54739,
   0X9DD277AF,
   0X4DB2615,
   0X73DC1683,
   0XE3630B12,
   0X94643B84,
   0XD6D6A3E,
   0X7A6A5AA8,
   0XE40ECF0B,
   0X9309FF9D,
   0XA00AE27,
   0X7D079EB1,
   0XF00F9344,
   0X8708A3D2,
   0X1E01F268,
   0X6906C2FE,
   0XF762575D,
   0X806567CB,
   0X196C3671,
   0X6E6B06E7,
   0XFED41B76,
   0X89D32BE0,
   0X10DA7A5A,
   0X67DD4ACC,
   0XF9B9DF6F,
   0X8EBEEFF9,
   0X17B7BE43,
   0X60B08ED5,
   0XD6D6A3E8,
   0XA1D1937E,
   0X38D8C2C4,
   0X4FDFF252,
   0XD1BB67F1,
   0XA6BC5767,
   0X3FB506DD,
   0X48B2364B,
   0XD80D2BDA,
   0XAF0A1B4C,
   0X36034AF6,
   0X41047A60,
   0XDF60EFC3,
   0XA867DF55,
   0X316E8EEF,
   0X4669BE79,
   0XCB61B38C,
   0XBC66831A,
   0X256FD2A0,
   0X5268E236,
   0XCC0C7795,
   0XBB0B4703,
   0X220216B9,
   0X5505262F,
   0XC5BA3BBE,
   0XB2BD0B28,
   0X2BB45A92,
   0X5CB36A04,
   0XC2D7FFA7,
   0XB5D0CF31,
   0X2CD99E8B,
   0X5BDEAE1D,
   0X9B64C2B0,
   0XEC63F226,
   0X756AA39C,
   0X26D930A,
   0X9C0906A9,
   0XEB0E363F,
   0X72076785,
   0X5005713,
   0X95BF4A82,
   0XE2B87A14,
   0X7BB12BAE,
   0XCB61B38,
   0X92D28E9B,
   0XE5D5BE0D,
   0X7CDCEFB7,
   0XBDBDF21,
   0X86D3D2D4,
   0XF1D4E242,
   0X68DDB3F8,
   0X1FDA836E,
   0X81BE16CD,
   0XF6B9265B,
   0X6FB077E1,
   0X18B74777,
   0X88085AE6,
   0XFF0F6A70,
   0X66063BCA,
   0X11010B5C,
   0X8F659EFF,
   0XF862AE69,
   0X616BFFD3,
   0X166CCF45,
   0XA00AE278,
   0XD70DD2EE,
   0X4E048354,
   0X3903B3C2,
   0XA7672661,
   0XD06016F7,
   0X4969474D,
   0X3E6E77DB,
   0XAED16A4A,
   0XD9D65ADC,
   0X40DF0B66,
   0X37D83BF0,
   0XA9BCAE53,
   0XDEBB9EC5,
   0X47B2CF7F,
   0X30B5FFE9,
   0XBDBDF21C,
   0XCABAC28A,
   0X53B39330,
   0X24B4A3A6,
   0XBAD03605,
   0XCDD70693,
   0X54DE5729,
   0X23D967BF,
   0XB3667A2E,
   0XC4614AB8,
   0X5D681B02,
   0X2A6F2B94,
   0XB40BBE37,
   0XC30C8EA1,
   0X5A05DF1B,
   0X2D02EF8D
};



#define METHOD_BUFFERED                   0
#define METHOD_OUT_DIRECT     2
//#define FILE_READ_ACCESS                  0x00000001
#define FILE_DEVICE_CD_ROM                0x00000002

#define IOCTL_CDROM_BASE                FILE_DEVICE_CD_ROM
//#define CTL_CODE(DeviceType,Function,Method,Access) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method))

#define IOCTL_CDROM_READ_TOC         CTL_CODE(IOCTL_CDROM_BASE, 0x0000, METHOD_BUFFERED, FILE_READ_ACCESS)
//#define IOCTL_CDROM_RAW_READ         CTL_CODE(IOCTL_CDROM_BASE, 0x000F, METHOD_OUT_DIRECT,  FILE_READ_ACCESS)
#define IOCTL_CDROM_COOKED_READ         CTL_CODE(IOCTL_CDROM_BASE, 0x0010, METHOD_OUT_DIRECT,  FILE_READ_ACCESS)
#define IOCTL_CDROM_GET_DRIVE_GEOMETRY  CTL_CODE(IOCTL_CDROM_BASE, 0x0013, METHOD_BUFFERED, FILE_READ_ACCESS)

#define PACKED

#pragma pack(1)

typedef struct
{
  BYTE rsvd;
  BYTE ADR;
  BYTE trackNumber;
  BYTE rsvd2;
  BYTE addr[4];
}
PACKED TOCTRACK;

typedef struct
{
  WORD tocLen;
  BYTE firstTrack;
  BYTE lastTrack;
  TOCTRACK tracks[100];
}
PACKED TOC, *PTOC, FAR * LPTOC;

/*
typedef enum _TRACK_MODE_TYPE {
     YellowMode2,
     XAForm2,
     CDDA
} TRACK_MODE_TYPE, *PTRACK_MODE_TYPE;

typedef struct __RAW_READ_INFO {
     LARGE_INTEGER DiskOffset;
     ULONG SectorCount;
     TRACK_MODE_TYPE TrackMode;
} RAW_READ_INFO, *PRAW_READ_INFO;
*/

typedef enum _MEDIA_TYPE
{
  Unknown, 
  F5_1Pt2_512, 
  F3_1Pt44_512, 
  F3_2Pt88_512, 
  F3_20Pt8_512, 
  F3_720_512, 
  F5_360_512, 
  F5_320_512, 
  F5_320_1024, 
  F5_180_512, 
  F5_160_512, 
  RemovableMedia, 
  FixedMedia, 
  F3_120M_512, 
  F3_640_512, 
  F5_640_512, 
  F5_720_512, 
  F3_1Pt2_512, 
  F3_1Pt23_1024, 
  F5_1Pt23_1024, 
  F3_128Mb_512, 
  F3_230Mb_512, 
  F8_256_128, 
  F3_200Mb_512, 
  F3_240M_512, 
  F3_32M_512
} MEDIA_TYPE;

typedef struct _DISK_GEOMETRY 
{  
	LARGE_INTEGER Cylinders;  
	MEDIA_TYPE MediaType;  
	DWORD TracksPerCylinder;  
	DWORD SectorsPerTrack;  
	DWORD BytesPerSector;
} DISK_GEOMETRY;


#pragma pack()



typedef struct _UNICODE_STRING {
USHORT Length;
USHORT MaximumLength;
PSTR  Buffer;
} UNICODE_STRING, *PUNICODE_STRING;

#define IN

//extern "C" XBOXAPI DWORD WINAPI IoCreateSymbolicLink(IN PUNICODE_STRING SymbolicLinkName,IN PUNICODE_STRING DeviceName);
//extern "C" XBOXAPI DWORD WINAPI IoDeleteSymbolicLink(IN PUNICODE_STRING SymbolicLinkName);

#define DriveD "\\??\\D:"
#define DriveP "\\??\\P:"
#define CdRom "\\Device\\Cdrom0"
STRING DDeviceName = { strlen(CdRom), strlen(CdRom)+1, CdRom };
STRING DSymbolicLinkName = { strlen(DriveD), strlen(DriveD)+1, DriveD };
STRING PSymbolicLinkName = { strlen(DriveP), strlen(DriveP)+1, DriveP };

#define DriveC "\\??\\C:"
#define DeviceC "\\Device\\Harddisk0\\Partition1"
UNICODE_STRING CDeviceName = {strlen(DeviceC), strlen(DeviceC)+1, DeviceC };
UNICODE_STRING CSymbolicLinkName = { strlen(DriveC), strlen(DriveC)+1, DriveC };

#define DriveE "\\??\\E:"
#define DeviceE "\\Device\\Harddisk0\\Partition1"
UNICODE_STRING EDeviceName = { strlen(DeviceE) , strlen(DeviceE)+1, DeviceE};
UNICODE_STRING ESymbolicLinkName = { strlen(DriveE), strlen(DriveE)+1, DriveE };

#define DriveF "\\??\\F:"
#define DeviceF "\\Device\\Harddisk0\\Partition6"
UNICODE_STRING FDeviceName = { strlen(DeviceF) , strlen(DeviceF)+1, DeviceF};
UNICODE_STRING FSymbolicLinkName = { strlen(DriveF), strlen(DriveF)+1, DriveF };





#define CD_SECS 60
#define CD_FRAMES 75


void CXBoxSample::doCDGame()
{
	int fResult ;
	TOC toc;
	char xmsg[100] ;
	int sectorA, sectorB ;
	int menuChoice = 0 ;
	int  whichCard ;
	int bdone ;


	bdone = 0 ;






	while ( !bdone )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		MenuBar( 32, 16*(6+menuChoice)+3, 600, 19 ) ;

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"CD Menu" );
		m_Font.DrawText( m_nXOffset+  32, 16*6, menuChoice==0 ? 0xff000000 : 0xffffffff, L"Play inserted CD with System Card v3" );
		m_Font.DrawText( m_nXOffset+  32, 16*7, menuChoice==1 ? 0xff000000 : 0xffffffff, L"Play inserted CD with System Card v1" );
		m_Font.DrawText( m_nXOffset+  32, 16*8, menuChoice==2 ? 0xff000000 : 0xffffffff, L"Eject CD (resets XBox if HUGO was not loaded from CDRW/DVD)" );
		m_Font.DrawText( m_nXOffset+  32, 16*9, menuChoice==3 ? 0xff000000 : 0xffffffff, L"Load CD" );
		m_Font.DrawText( m_nXOffset+  32, 16*11, 0xffffffff, L"Press B to go back" );
		m_Font.End();

		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
	        XBInput_GetInput();
			return  ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			menuChoice = (menuChoice+1)%4 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			if ( menuChoice == 0 )
				menuChoice = 3 ;
			else
				menuChoice-- ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			switch ( menuChoice )
			{
				case 0 : whichCard = 0 ; bdone = 1 ;break ;
				case 1 : whichCard = 1 ; bdone = 1 ;break ;
				case 2 : m_io.EjectTray() ; break ;
				case 3 : m_io.CloseTray() ; break ;
				default : break ;
			}
		}


	}











	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						 0x00000000, 1.0f, 0L );
	RenderGradientBackground( 0xFF000000, 0xFF000000 );
	m_Font.Begin();
	m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Attempting to load CD game...please wait." ) ;
	m_Font.End();
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


//use flags to turn off eject thingy - xbox image -> project options
	//    /TestMediaTypes:0x80000007 


	ANSI_STRING filename;
	OBJECT_ATTRIBUTES attributes;
	IO_STATUS_BLOCK status;
	HANDLE hDevice;
	NTSTATUS error;
	DWORD dummy;
	DWORD byteCount ;

	RtlInitAnsiString(&filename, "\\Device\\Cdrom0" );

	InitializeObjectAttributes(&attributes, &filename, OBJ_CASE_INSENSITIVE, NULL);

	if (NT_SUCCESS(error = NtCreateFile(&m_hCdrom, GENERIC_READ |
		SYNCHRONIZE | FILE_READ_ATTRIBUTES, &attributes, &status, NULL, 0,
		FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE, FILE_OPEN,
		FILE_NON_DIRECTORY_FILE | FILE_SYNCHRONOUS_IO_NONALERT)))
	{
	}
	else
	{
		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Could not access CD - aborting." ) ;
		m_Font.End();
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		Sleep(2000) ;
		return ;
	}



	if ( m_hCdrom == INVALID_HANDLE_VALUE )
	{
		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Could not access CD - aborting." ) ;
		m_Font.End();
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		Sleep(2000) ;
		return ;
	}

	if ( ! DeviceIoControl(m_hCdrom, IOCTL_CDROM_READ_TOC, NULL, 0,	&toc, sizeof(TOC), &byteCount, NULL ) )
	{
		CloseHandle( m_hCdrom ) ;
		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Could not read TOC from CD - aborting." ) ;
		m_Font.End();
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		Sleep(2000) ;
		return  ;
	}

	nb_max_track = toc.lastTrack ;
	memset( CD_track, 0, sizeof(CD_track) ) ;

	for ( int i = toc.firstTrack; i <= toc.lastTrack; i++)
	{
		int val = 	( toc.tracks[i-1].addr[1] * 60 * 75 ) + 
					( toc.tracks[i-1].addr[2] * 75 ) +
					( toc.tracks[i-1].addr[3]  ) ;
		int frms, mins, secs ;

		mins = toc.tracks[i-1].addr[1] ;
		secs = toc.tracks[i-1].addr[2] ;
		frms = toc.tracks[i-1].addr[3] ;

		/*
		if ( secs < 2 )  //account for standard gap that seems to appear on all cue sheets
		{
			secs = 60 - secs ;
			mins-- ;
		}
		else
		{
			secs -= 2 ;
		}
*/

		CD_track[i].beg_min = binbcd[mins] ;
		CD_track[i].beg_sec = binbcd[secs] ;
		CD_track[i].beg_fra = binbcd[frms] ;
		CD_track[i].type = (((TOCTRACK)(toc.tracks[i-1])).ADR ) & 0x0F ;
		strcpy( CD_track[i].filename, "D:\\blank" ) ;



		sprintf( xmsg, "track #%u, type=%s, size=%u\r\n", i, CD_track[i].type ? "data" : "audio", val ) ;
		writexbox(xmsg) ;

	}




	for ( int i = 1 ; i <= nb_max_track ; i++ )
	{

		if ( i == nb_max_track )
		{
			sectorB = 73 * CD_SECS * CD_FRAMES ; 
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}
		else
		{
			sectorB = ( bcdbin[CD_track[i+1].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_fra]  )  ;
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}

	}



	unsigned char tmp_data[2048*2] ;
	unsigned int CRC ;

	CRC = -1 ;

	sectorA = ( bcdbin[CD_track[2].beg_min] * CD_SECS * CD_FRAMES ) +
			  ( bcdbin[CD_track[2].beg_sec] * CD_FRAMES ) +
			  ( bcdbin[CD_track[2].beg_fra]  )  ;

	m_io.ReadSector( m_hCdrom, sectorA+1, (LPSTR)tmp_data ) ;

	for (int index = 0; index < 2048; index++)
	{
		tmp_data[index] ^= CRC;
		CRC >>= 8;
		CRC ^= TAB_CONST2[tmp_data[index]];
	}
	CRC = ~CRC;


	
	m_state = IN_GAME ;

	

	





	char                cd_filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char systemcard[200] ;
	//char xmsg[100] ;

	global_error_message[0] = 0 ;

	m_numFrames = 0 ;
	m_droppedFrames = 0 ;

	switch ( whichCard )
	{
		case 1 : strcpy( systemcard, "D:\\PCEROMS\\SYSCARD1.PCE" ) ; break ; 
	//	case 2 : strcpy( systemcard, "D:\\PCEROMS\\ARCADECARD.PCE" ) ; break ; 
		default : strcpy( systemcard, "D:\\PCEROMS\\SYSCARD3.PCE" ) ; break ; 
	}

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;

	writexbox( "init1" ) ;

	sprintf( cd_filename, "D:\\PCEROMS\\%02.2X%02.2X%02.2X%02.2X.IMG", (CRC>>24)&0xFF, (CRC>>16)&0xFF, (CRC>>8)&0xFF, CRC&0xFF ) ;
	//strcpy( cd_filename, "D:\\PCEROMS\\RAWCD.IMG" ) ;

	current_cd_track = 2 ;


	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, strrchr( cd_filename, '\\' )+1 ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( sav_path, "%s.sta", g_saveprefix ) ;

	writexbox( g_sramfile ) ;
	writexbox("\r\n") ;
	writexbox( g_chtfile ) ;
	writexbox("\r\n") ;
	writexbox( sav_path) ;
	writexbox("\r\n") ;
	writexbox( g_saveprefix) ;
	writexbox("\r\n") ;

	m_sound.init() ;
	m_cdda.init() ;
	//m_mp3player.init() ;

	writexbox( "init1" ) ;
	cht_load() ;
	writexbox( "init1" ) ;

	// Create our texture
	init_texture();

	writexbox( "init1" ) ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	
	writexbox( "init1" ) ;





	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;

	m_steps = 0 ;

	writexbox( "init4" ) ;
	//Then start it up

	m_sound.insertSilence( 22050 ) ;
	m_sound.pause( FALSE ) ;
	m_cdda.pause( FALSE ) ;
	//m_mp3player.insertSilence( 22050 ) ;
	//m_mp3player.pause( FALSE ) ;

	writexbox( "init5" ) ;
	hugomain( cd_filename, g_sramfile, g_saveprefix, systemcard, 1, 0 ) ;

	//writexbox( "initout" ) ;
	m_state=MAIN_MENU ;

	//put 3 frames of data in the audio buffer
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;


	//last thing after finishing game
	CloseHandle( m_hCdrom ) ;
	m_hCdrom = INVALID_HANDLE_VALUE ;






	


}


CXBoxSample *g_app ;

//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBoxSample xbApp;

	g_app = &xbApp ;

	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;

    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}



//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
	g_sound = &m_sound ;
	g_cdda = &m_cdda ;
	g_mp3player = &m_mp3player ;
	g_apptime = &m_fAppTime ;
	g_numframes = &m_numFrames ;


}



int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	

	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, (320+64+40), XBUF_HEIGHT, 0, 0, D3DFMT_P8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];


	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];


	D3DCOLOR			*color_palette;
	

	m_pd3dDevice->CreatePalette( D3DPALETTE_256 , &m_pd3dPalette ) ;
	m_pd3dPalette->Lock( &color_palette, 0 ) ;


	color_palette[255] = 0xFFFFFFFF ;


	int r, g, b;
	for (int i = 0; i < 255; i++)
	{
		r = (i & 0x1C) << 1 ;
		g = (i & 0xe0) >> 2 ;
		b = (i & 0x03) << 4 ;

		r = r << 2 ;
		g = g << 2 ;
		b = b << 2 ;

		//r = (256*r) / 56 ;
		//g = (256*g) / 56 ;
		//b = (256*b) / 48 ;
		color_palette[i] = 	( 0xFF << 24 ) | ( (r) << 16 ) | ( (g) << 8 ) | (b)  ;
	}

	m_pd3dPalette->Unlock() ;

	m_pd3dDevice->SetPalette( 0, m_pd3dPalette ) ;

	return 0;
}

int CXBoxSample::init_white_texture()
{
	// Release any previous texture
	if (WhiteTexture) 
	{ 
		WhiteTexture->Release();
		WhiteTexture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, 16, 16, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &WhiteTexture);
	
	D3DSURFACE_DESC desc;
    WhiteTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 15;
	rectSource.right  = 15 ;

	D3DLOCKED_RECT d3dlr;
	WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memset( d3dlr.pBits, 0xFF, desc.Size ) ;

	// Unlock our texture
	WhiteTexture->UnlockRect(0);

	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	return 0;
}


//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create a font
    if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font12.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_cdda.dsound),  NULL ) ) )
        return E_FAIL;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_mp3player.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", L"PCESAV", OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
        return E_FAIL;

	m_sound.dsound_init() ;
	m_cdda.dsound_init() ;
	m_mp3player.dsound_init() ;

	m_sound.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;
	m_cdda.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;
	m_mp3player.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;

	m_state = INIT_SYSTEM ;
	m_hCdrom = INVALID_HANDLE_VALUE ;

	return S_OK ;
}

HRESULT CXBoxSample::InitializeWithScreen()
{
	FILE *inifile ;
	char initext[100] ;
	char *fpos, *epos ;
	int numread ;
	char tmpfilename[MAX_PATH] ;

	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						 0x00000000, 1.0f, 0L );
	RenderGradientBackground( 0xFF000000, 0xFF000000 );
	m_Font.Begin();
	m_Font.DrawText( m_nXOffset+ 32, 16*2, 0xffffffff, L"Reading pceroms directory...please wait." ) ;
	m_Font.End();
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

	strcpy( m_szCurrentDir, "D:\\PCEROMS\\" ) ;

	//if ( m_debugClient.Init( "192.168.123.77", 7654, 1 ) == 0 )
	//{
		//strcpy( global_error_message, "*debugclientinit" ) ;
		//return 0 ;
	//}

	//m_logfile = fopen( "D:\\PCEROMS\\err.log", "wb" ) ;


	g_debugClient = &m_debugClient ;


	fGameSelect = 0.0f;
	iGameSelect = 0;
	fCursorPos = 0.0f;
	iCursorPos = 0;
	fMaxCount = 0.0f;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	int *iparams[6] ;

	m_nXOffset = 0 ;
	m_nFontHeight = 16 ;
	m_nScreenX = 50 ;
	m_nScreenY = 50 ;
	m_nScreenMaxX = 600 ;
	m_nScreenMaxY = 400 ;

	iparams[0] = &m_nXOffset ;
	iparams[1] = &m_nFontHeight ;
	iparams[2] = &m_nScreenX ;
	iparams[3] = &m_nScreenY ;
	iparams[4] = &m_nScreenMaxX ;
	iparams[5] = &m_nScreenMaxY ;

	int paramnum ;
	paramnum =0 ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, "hugo.ini" ) ;

	inifile = fopen( tmpfilename, "r" ) ;

	if ( inifile != NULL )
	{
		numread = fread( initext, sizeof(char), 100, inifile ) ;
		fclose( inifile ) ;

		fpos = initext ;

		while ( ( paramnum < 6 ) && ( ( epos = strchr( fpos, ' ' ) ) != NULL )  )
		{
			*epos = 0 ;

			*iparams[paramnum] = atoi( fpos ) ;

			fpos = epos + 1 ;

			if ( fpos - initext > 99 )
				break ;
			paramnum++ ;
		}

	}

	if ( m_nFontHeight <= 12 )
		m_nFontHeight = 12 ;
	else
		m_nFontHeight = 16 ;

	if ( m_nFontHeight == 16 )
	{
		if ( m_FontSmall.Destroy() == S_OK )
		{
			if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font.xpr" ) ) )
			{
				if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font12.xpr" ) ) )
					return 0;
			}
		}
	}

	m_namesPerPage =  (25*14 ) / ( m_nFontHeight+2) ;


	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pAlignBuff = NULL ;
	WhiteTexture = NULL ;
	Texture = NULL ;
	Sprite = NULL ;
	MenuSprite = NULL ;
	m_cheatCodes = NULL ;
	m_numCheats = 0 ;

	init_white_texture();

	g_saveprefix[0] = 0 ;

	FindAvailRoms( "D:\\PCEROMS\\*" ) ;


	m_memBuf1 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memBuf2 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memMatches = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_consoleMemory = hard_pce->RAM ;


//BEGIN ONE TIME



//END ONE TIME	
	
	
	m_state = MAIN_MENU ;

	if ( m_mp3player.loadFile( "D:\\PCEROMS\\HUGOTHEME.MP3", 1, 0, 9999999 ) )
	{
	}
	else
	{
		m_mp3player.insertSilence( 22050 ) ;
		m_mp3player.pause( FALSE ) ;
	}

    return S_OK;
}


void CXBoxSample::doSaveConfig()
{
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, "hugo.ini" ) ;

	inifile = fopen( tmpfilename, "wb" ) ;

	if ( inifile != NULL )
	{
		fprintf( inifile, "%u %u %u %u %u %u  \r\n", m_nXOffset, m_nFontHeight, m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ) ;
		fclose( inifile ) ;
	}

}

void CXBoxSample::doConfiguration()
{

	int menuChoice = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		MenuBar( 32, 16*(6+menuChoice)+3, 600, 19 ) ;

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"CONFIGURATION" );
		m_Font.DrawText( m_nXOffset+  32, 16*6, menuChoice==0 ? 0xff000000 : 0xffffffff, L"Set Game List Font Size" );
		m_Font.DrawText( m_nXOffset+  32, 16*7, menuChoice==1 ? 0xff000000 : 0xffffffff, L"Set Text Offset (push menu text to the right)" );
		m_Font.DrawText( m_nXOffset+  32, 16*8, menuChoice==2 ? 0xff000000 : 0xffffffff, L"Set Game Screen Size/Position" );
		m_Font.DrawText( m_nXOffset+  32, 16*10, 0xffffffff, L"Press B to go back" );
		m_Font.End();

		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
	        XBInput_GetInput();
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			menuChoice = (menuChoice+1)%3 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			menuChoice = (menuChoice-1)%3 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			switch ( menuChoice )
			{
				case 0 : doFontSize() ; break ;
				case 1 : doTextOffset() ; break ;
				case 2 : doScreenSize() ; break ;
				default : break ;
			}
		}


	}

}


void CXBoxSample::doFontSize()
{
	WCHAR str[200];
	int value ;

	value = m_nFontHeight ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		swprintf( str, L"Use DPAD to adjust current value : %u", value ) ;

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"Set Game List Font Size" );
		m_Font.DrawText( m_nXOffset+  32, 16*6, 0xffffffff, str) ;
		m_Font.DrawText( m_nXOffset+  32, 16*8, 0xffffffff, L"Press A to accept" );
		m_Font.DrawText( m_nXOffset+  32, 16*9, 0xffffffff, L"Press B to go back" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( value == 12 )
				value = 16 ;
			else
				value = 12 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( value == 12 )
				value = 16 ;
			else
				value = 12 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( value == 12 )
				value = 16 ;
			else
				value = 12 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( value == 12 )
				value = 16 ;
			else
				value = 12 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			if ( m_nFontHeight != value )
			{
				m_nFontHeight = value ;
				m_namesPerPage =  (25*14 ) / ( m_nFontHeight+2) ;

				if ( m_FontSmall.Destroy() == S_OK )
				{
					if( FAILED( m_FontSmall.Create( m_pd3dDevice, ( value == 16 ) ? "Font.xpr" : "Font12.xpr" ) ) )
					{
						if( FAILED( m_FontSmall.Create( m_pd3dDevice, ( value == 16 ) ? "Font12.xpr" : "Font.xpr" ) ) )
							return ;
					}
				}

				doSaveConfig() ;
				// Create a font
			}

			break ;
		}


	}

}

void CXBoxSample::doScreenSize()
{
	WCHAR str[200];
	int x, y, maxx, maxy ;
	float fx, fy, fmaxx, fmaxy ;

	x = m_nScreenX ;
	y = m_nScreenY ;
	maxx = m_nScreenMaxX;
	maxy = m_nScreenMaxY ;

	fx = x ;
	fy = y ;
	fmaxx = maxx ;
	fmaxy = maxy ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		x = fx ;
		y = fy ;
		maxx = fmaxx ;
		maxy = fmaxy ;
		MenuBar( x, y, maxx, maxy ) ;

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  132, 16*11, 0xff00ff00, L"Set Game Screen Size" );

		m_Font.DrawText( m_nXOffset+  132, 16*13, 0xff00ff00, L"Use RThumb and LThumb to adjust screen size/pos" );
		m_Font.DrawText( m_nXOffset+  132, 16*14, 0xff00ff00, L"Press A to accept" );
		m_Font.DrawText( m_nXOffset+  132, 16*15, 0xff00ff00, L"Press B to go back" );

		swprintf( str, L"X=%u Y=%u MAXX=%u MAXY=%u", x, y, maxx, maxy ) ;
		m_Font.DrawText( m_nXOffset+  132, 16*17, 0xff00ff00, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_nScreenX = x ;
			m_nScreenY = y ;
			m_nScreenMaxX = maxx ;
			m_nScreenMaxY = maxy ;
			doSaveConfig() ;
			break ;
		}
		else
		{
			if ( g_Gamepads[0].hDevice )
			{
				fx += g_Gamepads[0].fX1 ;
				fy -= g_Gamepads[0].fY1 ;
				fmaxx += g_Gamepads[0].fX2 ;
				fmaxy -= g_Gamepads[0].fY2 ;
			}
		}
	}

}

void CXBoxSample::doTextOffset()
{
	WCHAR str[200];
	int value ;

	value = m_nXOffset ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		swprintf( str, L"Use DPAD to adjust current value : %u", value ) ;

		m_Font.Begin();
		m_Font.DrawText( value+  32, 16*4, 0xffffffff, L"Set Menu Text Offset" );
		m_Font.DrawText( value+  32, 16*6, 0xffffffff, str) ;
		m_Font.DrawText( value+  32, 16*8, 0xffffffff, L"Press A to accept" );
		m_Font.DrawText( value+  32, 16*9, 0xffffffff, L"Press B to go back" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_nXOffset = value ;
			doSaveConfig() ;
			break ;
		}


	}

}



void CXBoxSample::doStartSearchMenu()
{

	memcpy( m_memBuf1, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+ 32, 16*2, 0xffffffff, L"The search has begun.  " );
		m_Font.DrawText(  m_nXOffset+32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
	}
}

void CXBoxSample::doEditCode( int which )
{
	CHEAT_CODE code ;
	int curr_pos ;
	int val1, val2 ;

	if ( which < 0 )
	{
		strcpy( code.code, "01000000" ) ;
		code.enabled = 1 ;
		code.adr = 0x0000 ;
		code.val = 0 ;
	}
	else
	{
		memcpy( &code, &(m_cheatCodes[which]), sizeof(CHEAT_CODE) ) ;
	}


	curr_pos = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();

		if ( which < 0 )
			m_Font.DrawText(m_nXOffset+  32, 16*2, 0xffffffff, L"Add New Cheat Code" );
		else
			m_Font.DrawText( m_nXOffset+ 32, 16*2, 0xffffffff, L"Edit Cheat Code" );

		m_Font.DrawText( m_nXOffset+ 32, 16*4, 0xffffffff, L"Press B to cancel." );
		m_Font.DrawText( m_nXOffset+ 32, 16*5, 0xffffffff, L"Press A to save." );
		m_Font.DrawText( m_nXOffset+ 32, 16*6, 0xffffffff, L"Use DPAD to select/change values." );

		WCHAR str[200];

		for ( int i = 0 ; i < 8 ; i++ )
		{
			swprintf( str, L"%c", (code.code)[i] ) ;
			if ( i == curr_pos+2 )
				m_Font.DrawText( m_nXOffset+  50 + ( i * 16 ), 16*9, 0xff00ff00, str ) ;
			else
				m_Font.DrawText( m_nXOffset+  50 + ( i * 16 ), 16*9, 0xffffffff, str ) ;
		}

		swprintf( str, L"Address : %04.4X", code.adr ) ;
		m_Font.DrawText( m_nXOffset+  50 , 16*11, 0xffffffff, str ) ;
		swprintf( str, L"Value : %u", code.val ) ;
		m_Font.DrawText( m_nXOffset+  50 , 16*12, 0xffffffff, str ) ;
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		{
			if ( ( code.adr > 0x7FFF ) )
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );

					m_Font.Begin();
					m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"The Address must be between 0x0000 and 0x7FFF" );
					m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to try again." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
			else
			{
				if ( which < 0 )
				{
					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;
					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
				}
				else
				{
					memcpy( &(m_cheatCodes[which]), &code, sizeof(CHEAT_CODE) ) ;
				}
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0 )
						code.val = 0xF0 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val - 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x00 )
						code.val = 0x0F + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val - 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0 )
						code.adr = 0xF0 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr - 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0 )
						code.adr = 0x0F + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr - 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0 )
						code.adr = 0xF000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr - 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0 )
						code.adr = 0x0F00 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr - 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val + 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val + 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr + 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr + 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr + 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr + 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( curr_pos == 0 )
				curr_pos = 5 ;
			else
				curr_pos-- ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( curr_pos == 5 )
				curr_pos = 0 ;
			else
				curr_pos++ ;
		}
	}


}

void CXBoxSample::doCodeListMenu()
{

	int selected  ;
	int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;

	selected = cheatTopIdx = 0 ;

	if ( m_numCheats == 0 )
	{
		while ( 1 )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );

			m_Font.Begin();
			m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
			m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
			m_Font.DrawText( m_nXOffset+  32, 16*6, 0xffffffff, L"There are no cheat codes in the list." ) ;

			m_Font.End();

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return ;
			}
		}
	}
	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Press A to add a new code." );
		m_Font.DrawText( m_nXOffset+  32, 16*6, 0xffffffff, L"Press X to edit the selected code." );
		m_Font.DrawText( m_nXOffset+  32, 16*7, 0xffffffff, L"Press Y to enable/disable the selected code." );
		m_Font.DrawText( m_nXOffset+  32, 16*8, 0xffffffff, L"Press BLACK to delete the selected code." );
		m_Font.DrawText( m_nXOffset+  32, 16*9, 0xffffffff, L"Press UP/DOWN/LS/RS to select code." );

		MenuBar( m_nXOffset+32, 16*(11+(selected-cheatTopIdx)) + 3, 600, 19 ) ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+10) ; idx++ )
		{
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( str, L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			if ( selected == idx )
				m_Font.DrawText( m_nXOffset+32, 16*(11+(idx-cheatTopIdx)), 0xff000000, str );
			else
				m_Font.DrawText( m_nXOffset+32, 16*(11+(idx-cheatTopIdx)), 0xffffffff, str );
		}
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doEditCode( -1 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			doEditCode( selected ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			if ( m_cheatCodes[selected].enabled )
				m_cheatCodes[selected].enabled = 0 ;
			else
				m_cheatCodes[selected].enabled = 1 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

			memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

			if ( selected < m_numCheats-1 )
			{
				memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
			}

			free( m_cheatCodes ) ;

			m_cheatCodes = tempbuf ;
			m_numCheats-- ;
			if ( m_numCheats == 0 )
				break ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + 10 < m_numCheats )
			{
				cheatTopIdx += 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= 10 )
			{
				cheatTopIdx -= 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (10-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
					selected++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
					selected-- ;
			}
		}

		
		
		
		
	}
}

void CXBoxSample::doAddFoundCodes()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			code.adr = i ;
			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"The search found 1 to 4 possible matches for your search." );
		m_Font.DrawText( m_nXOffset+  32, 16*3, 0xffffffff, L"They have been added to your list." );
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu()
{

	WCHAR str[200];
	int value ;

	memcpy( m_memBuf2, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	value = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Search Options" );
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"Press B to go back to the Options menu." );

		swprintf( str, L"Press X to search for this value : %u", value );
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, str );

		m_Font.DrawText( m_nXOffset+  32, 16*6, 0xffffffff, L"Press Y to search for values less than before." );
		m_Font.DrawText( m_nXOffset+  32, 16*7, 0xffffffff, L"Press A to search for values greater than before." );
		m_Font.DrawText( m_nXOffset+  32, 16*8, 0xffffffff, L"Press BLACK to search for values equal to before." );
		m_Font.DrawText( m_nXOffset+  32, 16*9, 0xffffffff, L"Press WHITE to search for values not equal to before." );
		m_Font.DrawText( m_nXOffset+  32, 16*10, 0xffffffff, L"Press DPAD-UP to add 1 to the value" ) ;
		m_Font.DrawText( m_nXOffset+  32, 16*11, 0xffffffff, L"Press DPAD-DOWN to subtract 1 from the value" ) ;
		m_Font.DrawText( m_nXOffset+  32, 16*12, 0xffffffff, L"Press DPAD-RIGHT to add 10 to the value" ) ;
		m_Font.DrawText( m_nXOffset+  32, 16*13, 0xffffffff, L"Press DPAD-LEFT to subtract 10 from the value" ) ;
		m_Font.DrawText( m_nXOffset+  32, 16*14, 0xffffffff, L"Press LS+RS to add the found codes to your list" ) ;

		swprintf( str, L"Number of hits from last search : %u", m_currentMemMatches );
		m_Font.DrawText( m_nXOffset+  32, 16*16, 0xffffffff, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] < m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}

			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf2[i] == value )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] > m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] == m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] != m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 5 ) )
			{
				doAddFoundCodes() ;
				break ;
			}
			else
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );

					m_Font.Begin();
					m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"You can only add when you have narrowed " ) ;
					m_Font.DrawText( m_nXOffset+  32, 16*3, 0xffffffff, L"it down to less than 5 matches." );
					m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"Press B to go back." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}

void CXBoxSample::doCheatMenu()
{

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"OPTIONS MENU" );
		m_Font.DrawText( m_nXOffset+  32, 16*4, 0xffffffff, L"B - Return to Game" );
		m_Font.DrawText( m_nXOffset+  32, 16*5, 0xffffffff, L"START+BACK - Quit Game" );
		m_Font.DrawText( m_nXOffset+  32, 16*6, 0xffffffff, L"BLACK - Start Search for Cheat Code" );
		m_Font.DrawText( m_nXOffset+  32, 16*7, 0xffffffff, L"A - Continue Cheat Search" );
		m_Font.DrawText( m_nXOffset+  32, 16*8, 0xffffffff, L"RS+LS - Cheat Code List" );

		WCHAR sndstr[5000];
		for ( int i = 0 ; i < 6 ; i++ )
		{
			//swprintf( sndstr, L"Sound channel %u is %S", i+1, ( soundChannels & ( 1<<i ) ) ? "ON" : "OFF" ) ;
			//m_Font.DrawText( m_nXOffset+  32, 16*(16+i), 0xffffffff, sndstr );
		}

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sound.pause( FALSE ) ;
			m_cdda.pause( FALSE ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = IN_GAME ;
			break ;
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			m_cdda.cleanup() ;
			m_mp3player.cleanup() ;
			cleanupConsole() ;
			m_state = MAIN_MENU ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doContinueSearchMenu() ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			doStartSearchMenu() ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			doCodeListMenu() ;
		}


	}

}


//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sound.pause( TRUE ) ;
			m_cdda.pause( TRUE ) ;
			m_mp3player.pause( TRUE ) ;
			m_state = IN_GAME_PAUSED ;
			m_dwStartPause = GetTickCount();
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		m_mp3player.process() ;

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) )
		{
			LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
			XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
		}
		else if ( (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_X]) && (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_B]) )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );
			m_Font.Begin();
			m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Reloading game list..." ) ;
			m_Font.End();
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			if ( numfiles > 0 )
			{
				delete [] files;
				files = NULL;
			}

			numfiles = 0 ;

			char tmpdir[MAX_PATH] ;
			sprintf( tmpdir, "%s*", m_szCurrentDir ) ;

			FindAvailRoms(tmpdir) ;
			curr = 0 ;
			topIdx = 0 ;
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				if ( files[curr].isDir )
				{
					numfiles = 0 ;

					char tmpdir[MAX_PATH] ;
					char *p ;

					if ( curr )
						sprintf( tmpdir, "%s%s\\*", m_szCurrentDir, (char*)files[curr].filename ) ;
					else
					{
						strcpy( tmpdir, m_szCurrentDir ) ;

						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						strcat( tmpdir, "\\*" ) ;
					}

					FindAvailRoms( tmpdir ) ;
					curr = 0 ;
					topIdx = 0 ;
				}
				else
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );
					m_Font.Begin();
					m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
					m_Font.End();
					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
					m_state = IN_GAME ;
					initConsole(curr, 0, 0) ;
				}
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				if ( files[curr].isDir )
				{
					numfiles = 0 ;

					char tmpdir[MAX_PATH] ;
					char *p ;
					if ( curr )
						sprintf( tmpdir, "%s%s\\*", m_szCurrentDir, (char*)files[curr].filename ) ;
					else
					{
						strcpy( tmpdir, m_szCurrentDir ) ;

						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						strcat( tmpdir, "\\*" ) ;
					}
					FindAvailRoms( tmpdir ) ;
					curr = 0 ;
					topIdx = 0 ;
				}
				else
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );
					m_Font.Begin();
					m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
					m_Font.End();
					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
					m_state = IN_GAME ;
					initConsole(curr,1, 0) ;
				}
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
			{
				if ( files[curr].isDir )
				{
					numfiles = 0 ;

					char tmpdir[MAX_PATH] ;
					char *p ;
					if ( curr )
						sprintf( tmpdir, "%s%s\\*", m_szCurrentDir, (char*)files[curr].filename ) ;
					else
					{
						strcpy( tmpdir, m_szCurrentDir ) ;

						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						p = strrchr( tmpdir, '\\' ) ;
						if ( p )
							*p = 0 ;
						strcat( tmpdir, "\\*" ) ;
					}
					FindAvailRoms( tmpdir ) ;
					curr = 0 ;
					topIdx = 0 ;
				}
				else
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );
					m_Font.Begin();
					m_Font.DrawText( m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
					m_Font.End();
					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
					m_state = IN_GAME ;
					initConsole(curr,0,1) ;
				}
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
			{
				m_mp3player.stop() ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
			{
				doConfiguration() ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_RIGHT_THUMB )
			{
				doCDGame() ;
				return S_OK ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		m_sound.pause( TRUE ) ;
		m_cdda.pause( TRUE ) ;
		m_mp3player.pause( TRUE ) ;
		m_bPaused =  TRUE ;
		doCheatMenu() ;

		if ( m_state == MAIN_MENU )
		{
		}

		return S_OK ;
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture()
{

	//DOXXX
	RECT src, dst;
	byte *curr1, *curr2 ;
	char xmsg[100] ;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = io.screen_h - 1 ;
	rectSource.right  = io.screen_w  - 1;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	//sprintf(xmsg, "h=%u,w=%u\r\n", io.screen_h, io.screen_w) ;
	//writexbox( xmsg) ;

	curr1 = g_pBlitBuff ;
	//DOXXX
	curr2 = osd_gfx_buffer ;

	for ( int y = 0 ; y < io.screen_h ; y++ )
	{
		curr1 = ((byte*)g_pBlitBuff) + ( y*d3dlr.Pitch ) ;
		curr2 = ((byte*)osd_gfx_buffer) + ( y*(320+64+40) ) + ( ( (320+64+40)-io.screen_w ) /2 )  ;
		memcpy( curr1, curr2, io.screen_w ) ;
	}
	
	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 1);


	// Swizzle the blittled surface back to the texture
//	XGSwizzleRect(osd_gfx_buffer2, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);

	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;



	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 0;
	src.bottom = theHeight + 1;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;
	float mx, my ;



	mx = (float)m_nScreenMaxX / (float)io.screen_w ;
	my = (float)m_nScreenMaxY / (float)io.screen_h ;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(mx, my);
	D3DXVECTOR2 vecTranslate(m_nScreenX, m_nScreenY );


	//mx = 640.0f / io.screen_w ;
	//my = 480.0f / io.screen_h ;
	//mx = 580.0f / io.screen_w ;
	//my = 400.0f / io.screen_h ;



	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	//D3DXVECTOR2 vecScale( mx,my ) ;
	//D3DXVECTOR2 vecScale( min(mx,my), min(mx,my) ) ;
	//D3DXVECTOR2 vecScale( (io.screen_w <= 320) ? 2 : 1 , (io.screen_w <= 320) ? 2 : 1);
	//D3DXVECTOR2 vecTranslate( 10, 20 ) ;
	//D3DXVECTOR2 vecTranslate( ( 640.0f - ( (float)io.screen_w * ( min(mx,my) ) ) )/2,
		                      //( 480.0f - ( (float)io.screen_h * ( min(mx,my) ) ) )/2 );
	//D3DXVECTOR2 vecTranslate( ( 640.0f - ( (float)io.screen_w * ( mx ) ) )/2,
		                      //( 480.0f - ( (float)io.screen_h * ( my ) ) )/2 );
	//D3DXVECTOR2 vecTranslate( (io.screen_w <= 320) ? 320 - io.screen_w : 320 - ( io.screen_w/2), 
	//	                      (io.screen_w <= 320) ? 240 - io.screen_h : 240 - ( io.screen_h/2)  );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

void CXBoxSample::MenuBar( int xpos, int ypos, int xlen, int ylen )
{
	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( xpos, ypos ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	RECT rectSource;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = ylen - 1 ;
	rectSource.right  = xlen - 1;
	
	MenuSprite->Draw(WhiteTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
}


//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		// Clear the zbuffer
		//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 //0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		//RenderGradientBackground( 0xff404040, 0xff404080 );

		if ( global_error_message[0] != 0 )
		{
			WCHAR str[5000];

			m_Font.Begin();
			//swprintf( str, L"%S", global_error_message );
			//m_Font.DrawText( 32, 48, 0x40ffffff, str );
			m_Font.DrawText( m_nXOffset+ 32, 48, 0xffffffff, L"ERROR" );
			m_Font.End();
		}
		else
		{

			processEmu( TRUE ) ;

			if ( m_msgDelay > 0 )
			{
				m_msgDelay-- ;
				m_Font.Begin();
				m_Font.DrawText( m_nXOffset+  32, 32, 0xffffff00, m_strMessage );
				m_Font.End();
			}
			else
			{
				//float elapsedTime ;
				//m_Font.Begin();
				//WCHAR str[2000];
				//swprintf( str, L"width = %u, height = %u", io.screen_w, io.screen_h ) ;
				//elapsedTime = ( (float)GetTickCount() - (float)g_dwStartTime - (float)g_dwTimePaused ) / 1000.0f ;
				//swprintf( str, L"numbytes apptime %5.5f, sndbytes %u, avg %6.5f, fps %5.5f cfps %5.5f", elapsedTime, m_sound.m_totalBytesWritten, 
					//((float)m_sound.m_totalBytesWritten) / elapsedTime, m_fFPS, ((float)m_numFrames) / m_fAppTime );
				//m_Font.DrawText( 30, 320, 0xFFffffff, str );
				//m_Font.End();
			}
		}
		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText( m_nXOffset+32, 16*3,  0xffffffff, L"HUGO for XBOX");
			m_Font.DrawText( m_nXOffset+32, 16*5,  0xffffffff, L"Main Menu Controls");
			m_Font.DrawText( m_nXOffset+32, 16*6,  0xffffffff, L" A/B/BLACK - Play Selected Game");
			m_Font.DrawText( m_nXOffset+32, 16*7,  0xffffffff, L" A=Normal/SysCard 3,B=Force US,BLACK=SysCard 1");
			m_Font.DrawText( m_nXOffset+32, 16*8,  0xffffffff, L" Y - Show This Help Screen");
			m_Font.DrawText( m_nXOffset+32, 16*9,  0xffffffff, L" WHITE - Stop MP3");
			m_Font.DrawText( m_nXOffset+32, 16*10,  0xffffffff, L" UP/DOWN - Select Game");
			m_Font.DrawText( m_nXOffset+32, 16*11,  0xffffffff, L" RIGHT/LEFT - Next/Prev Page");
			m_Font.DrawText( m_nXOffset+32, 16*12,  0xffffffff, L" LS/RS - Next/Prev Letter");
			m_Font.DrawText( m_nXOffset+32, 16*13,  0xffffffff, L" START+BACK+LS+RS - Exit to dashboard");
			m_Font.DrawText( m_nXOffset+32, 16*14,  0xffffffff, L" X+B - Reload list");
			m_Font.DrawText( m_nXOffset+32, 16*15,  0xffffffff, L" RANALOG - Press to bring up CD menu");
			m_Font.DrawText( m_nXOffset+32, 16*16,  0xff00ff00, L" Lines colored like this have save files on the HD.");

			m_Font.DrawText( m_nXOffset+32, 16*17, 0xffffffff, L"In-Game Controls");
			m_Font.DrawText( m_nXOffset+32, 16*18, 0xffffffff, L" A - A Button");
			m_Font.DrawText( m_nXOffset+32, 16*19, 0xffffffff, L" X - B Button");
			m_Font.DrawText( m_nXOffset+32, 16*20, 0xffffffff, L" DPAD - Joystick Movement");
			m_Font.DrawText( m_nXOffset+32, 16*21, 0xffffffff, L" START - Start");
			m_Font.DrawText( m_nXOffset+32, 16*22, 0xffffffff, L" BACK - Select");
			m_Font.DrawText( m_nXOffset+32, 16*23, 0xffffffff, L" Y - Options Menu");
			m_Font.DrawText( m_nXOffset+32, 16*24, 0xffffffff, L" RANALOG U/D/L/R - Adjust MP3/SFX volume");
			m_Font.DrawText( m_nXOffset+32, 16*25, 0xffffffff, L" LS+BLACK - Save state");
			m_Font.DrawText( m_nXOffset+32, 16*26, 0xffffffff, L" LS+WHITE - Load state");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText( m_nXOffset+48, 32, 0xffffffff, L"HUGO for XBOX - made by me");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) )
		{
			deleteSaveFiles( curr ) ;
		}
		else
		{
			WCHAR str[2000];
			swprintf( str, L"HUGO for XBOX  Y-Help Screen  Found %u games", numfiles);

			m_Font.Begin(); 
			m_FontSmall.Begin(); 
			m_Font.DrawText( m_nXOffset+ 48, 32, 0xffffffff, str );
			//m_Font.DrawText(48, 32, 0x40ffffff, L"Gnuboy for XBOX  Y-Help Screen");


			
			
			float fWinX = 32, fWinY = 64;

			MenuBar( m_nXOffset+fWinX, fWinY+ (( m_nFontHeight+2)*(curr-topIdx)) + 3, 600, m_nFontHeight+3 ) ;

			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+m_namesPerPage) ; idx++ )
			{
				if ( curr == idx )
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText( m_nXOffset+fWinX  , fWinY, 0xffff00ff, files[idx].name );
					else
						m_FontSmall.DrawText( m_nXOffset+fWinX , fWinY, 0xff000000, files[idx].name );
				}
				else
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText( m_nXOffset+fWinX, fWinY, 0xff00ff00, files[idx].name );
					else
						m_FontSmall.DrawText( m_nXOffset+fWinX, fWinY, 0xffffffff, files[idx].name );
				}
				fWinY += (m_nFontHeight + 2);
			}
			

			// end font drawing
			m_Font.End();
			m_FontSmall.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
		InitializeWithScreen() ;
	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

int CXBoxSample::handleEvents()
{

	updateCheats() ;

	XBInput_GetInput();

	for ( int i = 0 ; i < 4 ; i++ )
	{
		if(g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_state = IN_GAME_PAUSED ;
			m_sound.pause( TRUE ) ;
			m_cdda.pause( TRUE ) ;
			m_mp3player.pause( TRUE ) ;
			m_dwStartPause = GetTickCount();
			doCheatMenu() ;

			if ( m_state == MAIN_MENU )
			{
				return 1 ;
			}
		}
/*
		if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			loadgame() ;
		}
		else if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			savegame() ;
		}
*/
	
	}

	return 0 ;
}

UInt16 CXBoxSample::ReadJoypad( int port )
{

	UInt16 value ;
	char xmsg[100] ;


	value = 0 ;
#define	JOY_A		0x01
#define	JOY_B		0x02
#define	JOY_SELECT	0x04
#define	JOY_START	0x08
#define	JOY_UP		0x10
#define	JOY_RIGHT	0x20
#define	JOY_DOWN	0x40
#define	JOY_LEFT	0x80
#define JOY_AUTOI	0x100
#define JOY_AUTOII	0x200

	updateCheats() ;

	XBInput_GetInput();

	if ( g_Gamepads[port].hDevice )
	{

		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			value |= JOY_A ;
		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			value |= JOY_B ;
		if ( ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) || ( g_Gamepads[port].fX1 < 0 ) )
			value |= JOY_LEFT ;
		if ( ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_UP ) || ( g_Gamepads[port].fY1 > 0 ) )
			value |= JOY_UP ;
		if ( ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) || ( g_Gamepads[port].fX1 > 0) )
			value |= JOY_RIGHT ;
		if ( ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) || ( g_Gamepads[port].fY1 < 0) )
			value |= JOY_DOWN ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_START )  
			value |= JOY_START ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_BACK )  
			value |= JOY_SELECT ;

		if ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
		}
		else
		{
		}

		if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			loadgame() ;
		}
		else if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			savegame() ;
		}

		//sprintf( xmsg, "x=%d,y=%d,x=%d,y=%d\r\n", g_Gamepads[port].sThumbRX, g_Gamepads[port].sThumbRX, g_Gamepads[port].fX2, g_Gamepads[port].fY2 ) ;

		if ( g_Gamepads[port].fX2 )
		{
			m_sound.adjust_volume( (int) ( g_Gamepads[port].fX2 * 25.0 ) ) ;
		}
		if ( g_Gamepads[port].fY2 )
		{
			m_cdda.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
			m_mp3player.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
		}
	
	}

	return value ;
}

void CXBoxSample::QuickSort( int lo, int hi )
{
	int i = lo;
	int j = hi;
	char partitionStr[200];
	FILENAME tmpf;

	strcpy( partitionStr, (const char*)files[(i+j)/2].filename ) ;
	do
	{
		while ( strcmp( (const char*)files[i].filename, partitionStr ) < 0 ) i++ ;
		while ( strcmp( partitionStr, (const char*)files[j].filename ) < 0 ) j-- ;

		if (i <= j)
		{
			memcpy( &tmpf, &(files[i]), sizeof(tmpf) ) ;
			memcpy( &(files[i]), &(files[j]), sizeof(tmpf) ) ;
			memcpy( &(files[j]), &tmpf, sizeof(tmpf) ) ;
			i++;
			j--;
		}
	} while (i <= j);

	if (lo < j) QuickSort(lo, j);
	if (i < hi) QuickSort(i, hi);

	
}


void CXBoxSample::FindAvailRoms( char *dir)
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( dir, &oFindData);
	int  numfound ;
	char parentDir[MAX_PATH] ;
	char *p ;
	
	//writexbox( dir ) ;

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}

	// Allocate a buffer to blit our frames to
	files = new FILENAME[4096];

	numfiles = 0 ;

	strcpy( parentDir, dir ) ;

	//writexbox( "find1\r\n" ) ;

	p = strrchr( parentDir, '*' ) ;

	if ( p )
		*p = 0 ;

	strcpy( m_szCurrentDir, parentDir ) ;

	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	strcat( parentDir, "\\" ) ;


	//writexbox( "find1\r\n" ) ;

	//writexbox( m_szCurrentDir ) ;

	strcpy ( (char*)files[numfiles].filename, ".." ) ;
	files[numfiles].name[0] = 0 ;
	//strcpy( (char*)(files[numfiles].filename), parentDir ) ;
	//strcat( (char*)files[numfiles].filename, "*" ) ;
	//strlwr( (char*)( files[numfiles].filename )) ;
    swprintf( files[numfiles].name, L"<%S>", parentDir );
	files[numfiles].isDir = 1 ;

	numfiles++ ;



	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{

		files[numfiles].name[0] = 0 ;
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
		strlwr( (char*)( files[numfiles].filename )) ;
		files[numfiles].isDir = ( oFindData.dwFileAttributes  & FILE_ATTRIBUTE_DIRECTORY ) ;
		if ( files[numfiles].isDir )
		{
			swprintf( files[numfiles].name, L"<%S>", files[numfiles].filename );
		}
		else
			swprintf( files[numfiles].name, L"%S", files[numfiles].filename );

		numfiles++ ;

		if ( numfiles > 4096 )
		{
			numfiles-- ;
			break ;
		}

	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	numfound = numfiles ;

	QuickSort( 0, numfiles-1 ) ;
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{
	char c ;
	int  lcv ;

		if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv < numfiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
				lcv++ ;

			if ( lcv < numfiles )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
				lcv-- ;

			if ( lcv >= 0 )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( topIdx >= m_namesPerPage )
			{
				topIdx -= m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( topIdx + m_namesPerPage < numfiles )
			{
				topIdx += m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (m_namesPerPage-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

		if ( ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_DPAD_UP ) || ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) )
		{
			keyTime++ ;
		}
		else
		{
			keyTime = 0 ;
		}

		if ( keyTime > 20 )
		{
			if ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				if ( curr == topIdx )
				{
					if ( curr > 0 )
					{
						topIdx-- ;
						curr-- ;
					}
				}
				else
				{
					if ( curr > 0 )
						curr-- ;
				}
			}
			else
			{
				if ( curr == topIdx + (m_namesPerPage-1) )
				{
					if ( curr < numfiles - 1 )
					{
						topIdx++ ;
						curr++ ;
					}
				}
				else
				{
					if ( curr < numfiles-1 )
						curr++ ;
				}
			}
		}
}


#define CD_SECS 60
#define CD_FRAMES 75

void CXBoxSample::loadCueSheet( char *cuefile ) 
{
	FILE  *infile ;
	char  *cuedata ;
	unsigned int filesize ;
	char  *line ;
	char  *rpos ;
	char  *npos ;
	char  *msf ;
	char  *stringpos ;
	byte  mins, secs, frms, track, tracktype ;
	char  trackfilename[256] ;
	char  *tok ;
	int   sectorA, sectorB ;
	char  *lastslashA ;
	char  *lastslashB ;
	//char  xmsg[100] ;
	int   totalsectors ;

	memset( trackfilename, 0, 256 ) ;
	memset( CD_track, 0, sizeof(CD_track) ) ;

	track = mins = secs = frms = 0 ;

	writexbox( "about to open cue\r\n" ) ;

	infile = fopen( cuefile, "rb" ) ;

	if ( !infile )
	{
		return ;
	}

	fseek( infile, 0, SEEK_END ) ;
	filesize = ftell( infile ) ;
	fseek( infile, 0, SEEK_SET ) ;

	//sprintf( xmsg, "cuesize=%u\r\n", filesize ) ;
	//writexbox( xmsg ) ;

	cuedata = (char*)malloc( filesize+1 ) ;
	memset( cuedata, 0, filesize+1 ) ;

	fread( cuedata, sizeof(char), filesize, infile ) ;

	fclose( infile ) ;

	writexbox( "allocated and closed file\r\n" ) ;

	line = cuedata ;


	while ( *line )
	{
		writexbox( "top loop\r\n" ) ;

		rpos = strchr( line, '\r' ) ;
		npos = strchr( line, '\n' ) ;

		if ( npos > rpos )
			rpos = npos ;

		if ( rpos )
			*rpos = 0 ;

		writexbox( "removed trailing line\r\n" ) ;

		strupr( line ) ;

		//writexbox( line ) ;
		//writexbox( "\r\n" ) ;

		if ( stringpos = strstr( line, "TRACK " ) )
		{
			writexbox( "gottrack\r\n" ) ;
			if ( strstr( line, "AUDIO" ) )
				tracktype = 0 ;
			else
				tracktype = 4 ;

			tok = strtok( stringpos+5, " \t\r\n" ) ;


			track = atoi( tok ) ;


			if ( ( track < 0 ) || ( track > 255 ) )
			{
				track = 255 ;
			}


		}
		else if ( ( stringpos = strstr( line, "INDEX 1 " ) ) || ( stringpos = strstr( line, "INDEX 01 " ) ) )
		{
			writexbox( "gotindex\r\n" ) ;
			msf = strtok( stringpos+8, " \t\r\n" ) ;
			if ( strlen(msf) >= 8 )
			{
				*(msf+2) = 0 ;
				*(msf+5) = 0 ;
				*(msf+8) = 0 ;

				mins = atoi( msf ) ;
				secs = atoi( msf+3 ) ;
				frms = atoi( msf+6 ) ;

				if ( secs > 57 )  //account for standard gap that seems to appear on all cue sheets
				{
					secs = secs + 2 - 60 ;
					mins++ ;
				}
				else
				{
					secs += 2 ;
				}
			}
			CD_track[track].beg_fra = binbcd[frms] ;
			CD_track[track].beg_min = binbcd[mins] ;
			CD_track[track].beg_sec = binbcd[secs] ;  
			CD_track[track].type = tracktype ;
			strcpy( CD_track[track].filename, trackfilename ) ;
		}
		else if ( stringpos = strstr( line, "FILE " ) )
		{
			writexbox( "gotfile\r\n" ) ;
			tok = strtok( stringpos+4, " \r\n\t\"" ) ;

			lastslashA = strrchr( tok, '/' ) ;
			lastslashB = strrchr( tok, '\\' ) ;

			if ( lastslashB > lastslashA )
				lastslashA = lastslashB ;

			if ( lastslashB )
			{
				*lastslashB = 0 ;
				tok = lastslashB + 1 ;
			}
			
			strcpy( trackfilename, m_szCurrentDir ) ;
			strcat( trackfilename, tok ) ;

		}

		line = rpos + 1 ;

		if ( line - cuedata >= filesize )
			break ;

	}

	nb_max_track = track ;
	totalsectors = 0 ;


	for ( int i = 1 ; i <= nb_max_track ; i++ )
	{

		if ( i == nb_max_track )
		{
			sectorB = 73 * CD_SECS * CD_FRAMES ; 
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}
		else
		{
			sectorB = ( bcdbin[CD_track[i+1].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_fra]  )  ;
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}

		CD_track[i].beg_lsn = totalsectors;	

		totalsectors += CD_track[i].length ;

		//sprintf(xmsg, "trk=%u,type=%u,min=%u,sec=%u,fra=%u,lsn=%u,length=%ufilename=%s\r\n", i, CD_track[i].type, 
			//bcdbin[CD_track[i].beg_min], bcdbin[CD_track[i].beg_sec], bcdbin[CD_track[i].beg_fra], 
			//CD_track[i].beg_lsn, CD_track[i].length, CD_track[i].filename ) ;
		//writexbox( xmsg ) ;
	}

	free (cuedata) ;

	writexbox( "returning from cue\r\n" ) ;

}

void CXBoxSample::initConsole( UINT32 idx, int forceUS, int whichCard )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char systemcard[200] ;
	//char xmsg[100] ;

	global_error_message[0] = 0 ;

	m_numFrames = 0 ;
	m_droppedFrames = 0 ;
//	soundChannels = 0xFF ;
//	bkgHalt = 0 ;

	switch ( whichCard )
	{
		case 1 : strcpy( systemcard, "D:\\PCEROMS\\SYSCARD1.PCE" ) ; break ; 
	//	case 2 : strcpy( systemcard, "D:\\PCEROMS\\ARCADECARD.PCE" ) ; break ; 
		default : strcpy( systemcard, "D:\\PCEROMS\\SYSCARD3.PCE" ) ; break ; 
	}

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;

	writexbox( "init1" ) ;

	strcpy((char*)filename, m_szCurrentDir ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;


	//sprintf( xmsg, "currdir=%s\r\n", m_szCurrentDir ) ;
	//writexbox( xmsg ) ;
	//sprintf( xmsg, "filename==%s\r\n", filename ) ;
	//writexbox( xmsg) ;
	//sprintf( xmsg, "ffilename=%s\r\n", (const char*)files[idx].filename ) ;
	//writexbox( xmsg ) ;

	current_cd_track = 2 ;
	nb_max_track =24 ;

	memset( CD_track, 0, sizeof(CD_track) ) ;


	strcpy( g_cuefile, "" ) ;

	if (strcasestr (filename, ".MP3"))
	{
		if ( m_mp3player.loadFile( filename, 1, 0, 70*60*75 ) )
		{
			//writexbox( "nonomp3\r\n") ;
		}
		else
		{
			m_mp3player.insertSilence( 22050 ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = MAIN_MENU ;
			return  ;
		}
	}
	else if (strcasestr (filename, ".CUE"))
	{
		writexbox( "processing cue\r\n" ) ;

		strcpy( g_cuefile, filename ) ;
		loadCueSheet( g_cuefile ) ;
		filename[0] = 0 ;

		for ( int i = 0 ; i < nb_max_track ; i++ )
		{
			if ( CD_track[i].type == 4 )
			{
				current_cd_track = i ;
				strcpy( filename, CD_track[i].filename ) ;
				break ;
			}
		}

		//sprintf( xmsg, "filename fom cue=%s", filename ) ;
		//writexbox( xmsg ) ;

		if ( filename[0] == 0 )
		{
			m_state = MAIN_MENU ;
			return ;
		}
	}

	char *p;


	//writexbox( "init1" ) ;

	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, strrchr( filename, '\\' )+1 ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( sav_path, "%s.sta", g_saveprefix ) ;

//	nonoise = 0 ;
	
	writexbox( g_sramfile ) ;
	writexbox("\r\n") ;
	writexbox( g_chtfile ) ;
	writexbox("\r\n") ;
	writexbox( sav_path) ;
	writexbox("\r\n") ;
	writexbox( g_saveprefix) ;
	writexbox("\r\n") ;

	m_sound.init() ;
	m_cdda.init() ;
	//m_mp3player.init() ;

	writexbox( "init1" ) ;
	cht_load() ;
	writexbox( "init1" ) ;

	// Create our texture
	init_texture();

	writexbox( "init1" ) ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	
	writexbox( "init1" ) ;





	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;

	m_steps = 0 ;

	writexbox( "init4" ) ;
	//Then start it up

	m_sound.insertSilence( 22050 ) ;
	m_sound.pause( FALSE ) ;
	m_cdda.pause( FALSE ) ;
	//m_mp3player.insertSilence( 22050 ) ;
	//m_mp3player.pause( FALSE ) ;

	writexbox( "init5" ) ;
	hugomain( filename, g_sramfile, g_saveprefix, systemcard, 0, forceUS ) ;

	//writexbox( "initout" ) ;
	m_state=MAIN_MENU ;

	//put 3 frames of data in the audio buffer
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;


}

void CXBoxSample::cleanupConsole( )
{
	//sram_save();
	//rtc_save();
	cht_save() ;


	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}


}

void CXBoxSample::cht_load()
{
	FILE *f;
	CHEAT_CODE code ;
	int fsize ;
	int numread ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	

	f = fopen(g_chtfile, "rb");
	if (!f) return ;

	fseek( f, 0, SEEK_END ) ;
	fsize = ftell( f ) ;
	fseek( f, 0, SEEK_SET ) ;

	m_numCheats = fsize / sizeof(CHEAT_CODE) ;

	m_cheatCodes = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) *  m_numCheats );


	numread = 0 ;
	fread(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
}

void CXBoxSample::cht_save()
{
	FILE *f;
	CHEAT_CODE code ;

	if ( m_numCheats == 0 )
	{
		DeleteFile( g_chtfile ) ;
		return ;
	}

	f = fopen(g_chtfile, "wb");
	if (!f) return ;

	fwrite(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
	
}

BOOL CXBoxSample::hasFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( sav_path, "%s.sta", g_saveprefix ) ;

	infile = fopen( g_sramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_chtfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( sav_path, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	return FALSE ;

}
void CXBoxSample::updateCheats( )
{
	for ( int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( m_cheatCodes[i].enabled )
			m_consoleMemory[ m_cheatCodes[i].adr ] = ( m_cheatCodes[i].val & 0xFF ) ;
	}
}

void CXBoxSample::deleteSaveFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( sav_path, "%s.sta", g_saveprefix ) ;

	DeleteFile( g_sramfile ) ;
	DeleteFile( g_chtfile ) ;
	DeleteFile( sav_path ) ;

}
#ifdef __cplusplus
extern "C" {
#endif


void audio_callback()
{
	//g_sound->process( *g_apptime, *g_numframes ) ;

}
void xbox_read_cd_sector( unsigned char *p, unsigned int sector ) 
{
	int result ;
	char xmsg[100] ;

	//sprintf(xmsg, "reading sector %u\r\n", sector) ;
	//writexbox(xmsg) ;
	result = g_app->m_io.ReadSector( g_app->m_hCdrom, sector, (LPSTR)p ) ;

	//if ( result < 2048 )
		//writexbox("FAILED\r\n" ) ;
}
void xbox_play_cdda( unsigned int sectorFrom, unsigned int sectorTo, UChar repeat ) 
{
	g_cdda->play_sectors( sectorFrom, sectorTo, repeat, g_app->m_hCdrom ) ;
}

void xbox_stop_audio( ) 
{
	g_mp3player->stop( ) ;
	g_cdda->stop( ) ;
}

void xbox_pause_audio( int state ) 
{
	g_mp3player->pause( state ) ;
	g_cdda->pause( state ) ;
}


void xbox_play_track( UChar track, UChar repeat ) 
{
	if ( ! g_mp3player->loadFile( CD_track[track].filename, repeat, 0, 75*60*70 ) )
	{
		g_mp3player->insertSilence( 22050 ) ;
		g_mp3player->pause( 0 ) ;
	}

}

void xbox_play_track_range( UChar track, UChar repeat, unsigned int frame_offset, unsigned int numframes ) 
{

	if ( ! g_mp3player->loadFile( CD_track[track].filename, repeat, frame_offset, numframes ) )
	{
		g_mp3player->insertSilence( 22050 ) ;
		g_mp3player->pause( 0 ) ;
	}
}

int xbox_got_cue()
{
	return ( ( g_app->g_cuefile ) && ( g_app->g_cuefile[0] ) ) ;
}

DWORD cpp_GetTickCount()
{
//	writexbox( "before tick") ;
	return GetTickCount() ;
//	writexbox( "after tick") ;
}

void cpp_Sleep( DWORD amt )
{
	char msg[50] ;

//	sprintf( msg, "before sleep %u", amt ) ;
	//writexbox( msg ) ;
	Sleep(amt) ;
	//writexbox( "after sleep") ;
}

void xbox_set_RAM_location() 
{
	g_app->m_consoleMemory = hard_pce->RAM ;

}

void writexbox( char *msg )
{

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;

	//g_debugClient->Send( msg, strlen(msg) ) ;
	//g_debugClient->WaitKey() ;
}

void writexboxwait( char *msg )
{

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;

	//g_debugClient->Send( msg, strlen(msg) ) ;
	//g_debugClient->WaitKey() ;
}

UInt16 xbox_read_input(UInt16 port) 
{
	//writexbox( "before readinput") ;
	return g_app->ReadJoypad( port ) ;
	//writexbox( "after readinput") ;
}

int xbox_check_events()
{
	//writexbox( "before events") ;
	return g_app->handleEvents() ;
	//writexbox( "after events") ;
}

void xbox_put_image()
{
	//writexbox( "before render") ;
	g_sound->process() ;
	g_cdda->process() ;
	g_mp3player->process() ;
	g_app->render_to_texture() ;
	//writexbox( "after render") ;
}

void xbox_open_zip( char *hugozipfile )
{
	//writexbox( "before zip") ;
	g_app->rom_load_zip( hugozipfile ) ;
	//writexbox( "after zip") ;
}

#ifdef __cplusplus
}
#endif

void CXBoxSample::processEmu( BOOL render )
{
			
			handleEvents();
			updateCheats() ;

		    exe_go ();

//			doneFrame = 0 ;

			//m_nbytes = update_sound_main() ;



			if ( render )
			{
				render_to_texture();
				m_numFrames++ ;
			}


//			m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;

			while ( m_sound.m_bDanger )
			{
				handleEvents();
				updateCheats() ;
			    exe_go ();
//				doneFrame = 0 ;
				//m_nbytes = update_sound_main() ;


				//m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;
			}



}


int CXBoxSample::rom_load_zip( char *hugozipfile )
{
	byte c, *data, *header;
	int len = 0, rlen;

	//writexbox( "ttt\r\n" ) ;
    unzFile file = unzOpen(hugozipfile);

    if(file == NULL)
		return 0 ;

	//writexbox( "ttt\r\n" ) ;

    char filename[132];
    int filesize = 0;
    int port = unzGoToFirstFile(file);
    unz_file_info info;

	//writexbox( "ttt\r\n" ) ;
    while(port == UNZ_OK)
    {
		char name[132];
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ((int) info.uncompressed_size > filesize)
		{
			strcpy(filename,name);
			filesize = info.uncompressed_size;
		}
		port = unzGoToNextFile(file);
    }

	//writexbox( "ttt\r\n" ) ;
    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || filesize == 0)
    {
		unzClose(file) ;
		return 0 ;
    }
	//writexbox( "ttt\r\n" ) ;

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
	//writexbox( "ttt\r\n" ) ;
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		return 0 ;
    }

	//writexbox( "ttt\r\n" ) ;

	data = (byte*)malloc( info.uncompressed_size ) ;

	//writexbox( "ttt\r\n" ) ;

	int l = unzReadCurrentFile(file,data,info.uncompressed_size);
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(data) ;
	    unzClose(file);
		return 0 ;
	}

	//writexbox( "ttt\r\n" ) ;
    unzClose(file);

/*
	fsize = ftell (fp);

	fseek (fp, fsize & 0x1fff, SEEK_SET);
	fsize &= ~0x1fff;

	ROM = (UChar *) malloc (fsize);
	ROM_size = fsize / 0x2000;
	fread (ROM, 1, fsize, fp);
*/

	filesize = info.uncompressed_size ;
	filesize &= ~0x1fff;  //524288  524800

	//writexbox( "ttt\r\n" ) ;

	ROM = (UChar *) malloc (filesize);
	ROM_size = filesize / 0x2000;
	memcpy(ROM, data + (info.uncompressed_size & 0x1fff), filesize ) ;

	free(data) ;

	//writexbox( "ttt\r\n" ) ;

	return 1;
}

//sometimes items are just gone
//re-load list
//pAL/ntsc
//quit app to return to dashboard
