// hugo210.cpp : Defines the entry point for the application.
//

//#include "stdafx.h"

//#include "windows.h"
#include "afxwin.h"
//#include <ddraw.h>

unsigned char screenbuf[ (320+64+40) * 256*3 ];

//DDSURFACEDESC2 ddsd;
HWND g_hWnd;

char g_statefile[500] ;
DWORD m_color_palette[256];
int currpad ;

#ifdef __cplusplus
extern "C" {
#endif

extern FILE *debuglog ;
extern int dologging ;
extern int xwidth ;
extern int xheight ;

#undef __cplusplus

#include "pce.h"

#define __cplusplus




int hugomain (char* romfilename, char* savefilename, char* savepath, char* cdsystempath, int emulatecd, int forceUS ) ;

#ifdef __cplusplus
}
#endif



#define MAX_LOADSTRING 100



// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];								// The title bar text

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

//#include "pce.h"


#define CD_SECS 60
#define CD_FRAMES 75

void loadCueSheet( char *cuefile ) 
{
	FILE  *infile ;
	char  *cuedata ;
	unsigned int filesize ;
	char  *line ;
	char  *rpos ;
	char  *npos ;
	char  *msf ;
	char  *stringpos ;
	unsigned char mins, secs, frms, track, tracktype ;
	char  trackfilename[256] ;
	char  *tok ;
	int   sectorA, sectorB ;
	char  *lastslashA ;
	char  *lastslashB ;
	//char  xmsg[100] ;
	int   totalsectors ;
	int smbfile ;
	int dosamba = 0 ;
	char cuepath[500] ;

	memset( trackfilename, 0, 256 ) ;
	memset( CD_track, 0, sizeof(CD_track) ) ;

	track = mins = secs = frms = 0 ;

	writexbox( "about to open cue\r\n" ) ;

	strcpy( cuepath, cuefile ) ;

	if ( strrchr( cuepath, '\\' ) )
		*(strrchr( cuepath, '\\' )+1) = 0 ;


	dosamba = ( ( strncmp( cuefile, "SMB:", 4 ) == 0 ) || ( strncmp( cuefile, "smb:", 4 ) == 0 ) ) ;

	{

		infile = fopen( cuefile, "rb" ) ;

		if ( !infile )
		{
			return ;
		}

		fseek( infile, 0, SEEK_END ) ;
		filesize = ftell( infile ) ;
		fseek( infile, 0, SEEK_SET ) ;

		//sprintf( xmsg, "cuesize=%u\r\n", filesize ) ;
		//writexbox( xmsg ) ;

		cuedata = (char*)malloc( filesize+1 ) ;
		memset( cuedata, 0, filesize+1 ) ;

		fread( cuedata, sizeof(char), filesize, infile ) ;

		fclose( infile ) ;
	}

	writexbox( "allocated and closed file\r\n" ) ;

	line = cuedata ;


	while ( *line )
	{
		writexbox( "top loop\r\n" ) ;

		rpos = strchr( line, '\r' ) ;
		npos = strchr( line, '\n' ) ;

		if ( npos > rpos )
			rpos = npos ;

		if ( rpos )
			*rpos = 0 ;

		//writexbox( "removed trailing line\r\n" ) ;

		strupr( line ) ;

		//writexbox( line ) ;
		//writexbox( "\r\n" ) ;

		if ( stringpos = strstr( line, "TRACK " ) )
		{
			//writexbox( "gottrack\r\n" ) ;
			if ( strstr( line, "AUDIO" ) )
				tracktype = 0 ;
			else
				tracktype = 4 ;

			tok = strtok( stringpos+5, " \t\r\n" ) ;


			track = atoi( tok ) ;


			if ( ( track < 0 ) || ( track > 255 ) )
			{
				track = 255 ;
			}


		}
		else if ( ( stringpos = strstr( line, "INDEX 1 " ) ) || ( stringpos = strstr( line, "INDEX 01 " ) ) )
		{
			//writexbox( "gotindex\r\n" ) ;
			msf = strtok( stringpos+8, " \t\r\n" ) ;
			if ( strlen(msf) >= 8 )
			{
				*(msf+2) = 0 ;
				*(msf+5) = 0 ;
				*(msf+8) = 0 ;

				mins = atoi( msf ) ;
				secs = atoi( msf+3 ) ;
				frms = atoi( msf+6 ) ;

				if ( secs > 57 )  //account for standard gap that seems to appear on all cue sheets
				{
					secs = secs + 2 - 60 ;
					mins++ ;
				}
				else
				{
					secs += 2 ;
				}
			}


			CD_track[track].beg_fra = binbcd[frms] ;
			CD_track[track].beg_min = binbcd[mins] ;
			CD_track[track].beg_sec = binbcd[secs] ;  
			CD_track[track].type = tracktype ;


			strcpy( CD_track[track].filename, trackfilename ) ;
		}
		else if ( stringpos = strstr( line, "FILE " ) )
		{
			//writexbox( "gotfile\r\n" ) ;
			tok = strtok( stringpos+4, " \r\n\t\"" ) ;

			lastslashA = strrchr( tok, '/' ) ;
			lastslashB = strrchr( tok, '\\' ) ;

			if ( lastslashB > lastslashA )
				lastslashA = lastslashB ;

			if ( lastslashB )
			{
				*lastslashB = 0 ;
				tok = lastslashB + 1 ;
			}
			
			if ( dosamba )
			{
				strcpy( trackfilename, tok ) ;
			}
			else
			{
				strcpy( trackfilename, cuepath ) ;
				strcat( trackfilename, tok ) ;

				//sprintfx( trackfilename ) ;
			}

		}

		line = rpos + 1 ;

		if ( line - cuedata >= filesize )
			break ;

	}

	nb_max_track = track ;
	totalsectors = 0 ;


	for ( int i = 1 ; i <= nb_max_track ; i++ )
	{

		if ( i == nb_max_track )
		{
			sectorB = 73 * CD_SECS * CD_FRAMES ; 
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}
		else
		{
			sectorB = ( bcdbin[CD_track[i+1].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i+1].beg_fra]  )  ;
	
			sectorA = ( bcdbin[CD_track[i].beg_min] * CD_SECS * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_sec] * CD_FRAMES ) +
					  ( bcdbin[CD_track[i].beg_fra]  )  ;
	
			CD_track[i].length = sectorB - sectorA ;
		}

		CD_track[i].beg_lsn = totalsectors;	

		totalsectors += CD_track[i].length ;

//		sprintfx("trk=%u,type=%u,min=%u,sec=%u,fra=%u,lsn=%u,length=%ufilename=%s\r\n", i, CD_track[i].type, 
			//bcdbin[CD_track[i].beg_min], bcdbin[CD_track[i].beg_sec], bcdbin[CD_track[i].beg_fra], 
			//CD_track[i].beg_lsn, CD_track[i].length, CD_track[i].filename ) ;
		//writexbox( xmsg ) ;
	}
/*


  CD_track[1].beg_min = binbcd[00];
  CD_track[1].beg_sec = binbcd[02];
  CD_track[1].beg_fra = binbcd[00];

  CD_track[1].type = 0;
  CD_track[1].beg_lsn = 0;	// Number of sector since the
  // beginning of track 1

  CD_track[1].length = 47 * CD_FRAMES + 65;	// Most common

  // CD_track[0x01].length=53 * CD_FRAMES + 65;

  // CD_track[0x01].length=0 * CD_FRAMES + 16;


// Fra = CD_track[0x01].length % CD_FRAMES;
// Sec = (CD_track[0x01].length) % (CD_FRAMES * CD_SECS) / CD_SECS;
// Min = (CD_track[0x01].length) (CD_FRAMES * CD_SECS);

// Second track is the main code track
  unsigned char Min, Sec, Fra ;
  nb_sect2msf (CD_track[1].length, &Min, &Sec, &Fra);

  CD_track[2].beg_min = binbcd[bcdbin[CD_track[1].beg_min] + Min];
  CD_track[2].beg_sec = binbcd[bcdbin[CD_track[1].beg_sec] + Sec];
  CD_track[2].beg_fra = binbcd[bcdbin[CD_track[1].beg_fra] + Fra];

  CD_track[2].type = 4;
  CD_track[2].beg_lsn =
    msf2nb_sect (bcdbin[CD_track[2].beg_min] - bcdbin[CD_track[1].beg_min],
		 bcdbin[CD_track[2].beg_sec] - bcdbin[CD_track[1].beg_sec],
		 bcdbin[CD_track[2].beg_fra] - bcdbin[CD_track[1].beg_fra]);

for ( int i = 1 ; i < 4 ; i++ )
{
		sprintfx("trk=%u,type=%u,min=%u,sec=%u,fra=%u,lsn=%u,length=%ufilename=%s\r\n", i, CD_track[i].type, 
			bcdbin[CD_track[i].beg_min], bcdbin[CD_track[i].beg_sec], bcdbin[CD_track[i].beg_fra], 
			CD_track[i].beg_lsn, CD_track[i].length, CD_track[i].filename ) ;
}
*/
	free (cuedata) ;

	writexbox( "returning from cue\r\n" ) ;

}




int emulating ;

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	MSG msg;
	CBitmap *bitmap ;

	m_color_palette[255] = 0xFFFFFFFF ;


	currpad = 0 ;

	int r, g, b;
	for (int i = 0; i < 255; i++)
	{
		r = (i & 0x1C)  ;
		g = (i & 0xe0) >> 2 ;
		b = (i & 0x03) << 3 ;

		//r = (256*r) / 56 ;
		//g = (256*g) / 56 ;
		//b = (256*b) / 48 ;
		m_color_palette[i] = 	( (r) << 11 ) | ( (g) << 5 ) | (b)  ;
	}

	MyRegisterClass(hInstance);


	emulating = 1 ;
	xwidth = 320 ;
	xheight = 256 ;


	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	//hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TESTWIN2);

	/*
	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		//if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
*/


	memset( CD_track, 0, sizeof(CD_track) ) ;

	debuglog = fopen( "f:\\pce\\debuglog.txt", "wb" ) ;


	//loadCueSheet( "f:\\pce\\dvd1\\dungeon_explorer_2_\\dungeon_explorer_2_.cue") , 
	loadCueSheet( "F:\\pce\\dvd1\\far_east_of_eden2_\\far_east_of_eden2_.cue") , 

	current_cd_track = 2 ;

	for (  i = 0 ; i < nb_max_track ; i++ )
	{
		if ( CD_track[i].type == 4 )
		{
			current_cd_track = i ;
			break ;
		}
	}

	dologging = 0 ;

	hugomain( CD_track[current_cd_track].filename, 
		      "f:\\pce\\saveram.srm",
			  "f:\\pce\\dvd1\\",
			  "c:\\hugo\\syscard3.pce",0,0) ;

	fclose(debuglog) ;

/*


	loadCueSheet( "f:\\pce\\macross_2036_\\macross_2036_.cue") , 

	current_cd_track = 2 ;

	hugomain( "f:\\pce\\macross_2036_\\macross_2036_02.iso", 
		      "f:\\pce\\macross_2036_\\macross_2036_02.srm",
			  "f:\\pce\\macross_2036_\\",
			  "c:\\hugo\\syscard3.pce",0,0) ;

*/	
	return 0;
}





//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= NULL ;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= "mywinclass";
	wcex.hIconSm		= NULL ;

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow("mywinclass", "mytitle", WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   g_hWnd = hWnd ;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	TCHAR szHello[MAX_LOADSTRING];
CBitmap* pBitmap ; /* pointer to current CBitmap */;
       CDC srcDC; // select current bitmap into a compatible CDC

	switch (message) 
	{
	case WM_KEYDOWN :
		{
			switch ( wParam )
			{
				case VK_DOWN : currpad |= 0x40 ; break ; 
				case VK_UP : currpad |= 0x10 ; break ; 
				case VK_LEFT : currpad |= 0x80 ; break ; 
				case VK_RIGHT : currpad |= 0x20 ; break ; 
				case VK_RETURN : currpad |= 0x08 ; break ; 
				case VK_TAB : currpad |= 0x04 ; break ; 
				case 'Z' : currpad |= 0x01 ; break ; 
				case 'X' : currpad |= 0x02 ; break ; 
			}

			break ;
		}
	case WM_KEYUP :
		{
			switch ( wParam )
			{
				case VK_DOWN : currpad &= ~0x40 ; break ; 
				case VK_UP : currpad &= ~0x10 ; break ; 
				case VK_LEFT : currpad &= ~0x80 ; break ; 
				case VK_RIGHT : currpad &= ~0x20 ; break ; 
				case VK_RETURN : currpad &= ~0x08 ; break ; 
				case VK_TAB : currpad &= ~0x04 ; break ; 
				case 'Z' : currpad &= ~0x01 ; break ; 
				case 'X' : currpad &= ~0x02 ; break ; 
			}

			break ;
		}
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				/*
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;*/
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
			case WM_LBUTTONDOWN :

				emulating = 0 ;
				break ;
			case WM_RBUTTONDOWN :

				dologging = 1 ;
				break ;

		case WM_PAINT:
			//hdc = BeginPaint(hWnd, &ps);
			// TODO: Add any drawing code here...
			//RECT rt;
			//GetClientRect(hWnd, &rt);




			
			
			//DrawText(hdc, "howdy", 5, &rt, DT_CENTER);
			//EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
			emulating = 0 ;
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}









int handleEvents()
{
	MSG msg ;

	io.JOY[0] = currpad;

	if (GetMessage(&msg, NULL, 0, 0)) 
	{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
	}
	return !emulating ;
}


#ifdef __cplusplus
extern "C" {
#endif

DWORD cpp_GetTickCount()
{
//	writexbox( "before tick") ;
	return GetTickCount() ;
//	writexbox( "after tick") ;
}

void xbox_open_zip( char *hugozipfile )
{
	//writexbox( "before zip") ;
	//writexbox( "after zip") ;
}

void cpp_Sleep_hugo( DWORD amt )
{
}

int xbox_got_cue()
{
	return 1 ;
}

void xbox_dovolume( int vol )
{
}
extern unsigned char* osd_gfx_buffer;

void xbox_put_image()
{

	unsigned char *curr1, *curr2 ;
	DWORD color ;

	curr1 = (unsigned char*)screenbuf ;

	int srcdiff ;
	int dstdiff ;

	srcdiff = 320+64+40 - ( xwidth ) ;
	dstdiff = (320+64+40)*2 - (xwidth*2) ;

	//curr2 = osd_gfx_buffer ;
	curr2 = ((unsigned char*)osd_gfx_buffer) + ( 0*(320+64+40) ) + ( ( (320+64+40)-xwidth ) /2 )  ;

	for ( int y = 0 ; y < xheight ; y++ )
	{
		//curr1 = ((byte*)g_pBlitBuff) + ( y*d3dlr.Pitch ) ;
		//curr2 = ((byte*)osd_gfx_buffer) + ( y*(320+64+40) ) + ( ( (320+64+40)-io.screen_w ) /2 )  ;

		for ( int x = 0 ; x < xwidth ; x++ )
		{
			*( (WORD*)curr1) = m_color_palette[*curr2++] ;
			curr1 += 2 ;
		}

		//curr1 += dstdiff ;
		curr2 += srcdiff ;
	}

 HDC hdc = GetDC( g_hWnd ) ;

 BITMAPINFO bmi;
 memset(&bmi, 0, sizeof(bmi));
 bmi.bmiHeader.biSize        = sizeof (BITMAPINFOHEADER);
 bmi.bmiHeader.biWidth       = xwidth;
 bmi.bmiHeader.biHeight      = -((long) xheight); // top-down image
 bmi.bmiHeader.biPlanes      = 1;
 bmi.bmiHeader.biBitCount    = 16;
 bmi.bmiHeader.biCompression = BI_RGB;
 bmi.bmiHeader.biSizeImage   = 0;

 SetDIBitsToDevice (hdc, 0, 0, xwidth, xheight, 0, 0, 0, xheight, screenbuf, &bmi, DIB_RGB_COLORS);

 // Deallocate primary DC
 //m_StaticPic.ReleaseDC (dc);
 ReleaseDC(g_hWnd, hdc);

}

int xbox_sopen( char *name, char* type )
{
	return 0 ;
}

void* xbox_ropen( char *name, char* type, int tracknum )
{
	return 0 ;
}

char* xbox_get_statefile() 
{
	return g_statefile ;
}


unsigned int xbox_rlength( void *fd )
{
	return 0;
}

int xbox_rclose( void *fd )
{
	return 1 ;
}

int xbox_rseek( void *fd, int pos, int type )
{
	return 0 ;
}

int xbox_sread( void *buf, int size1, int size2, int fd )
{
	return 0;
}


int xbox_sclose( int fd )
{
	return 1;
}

int xbox_sseek( int fd, int pos, int type )
{
	return 0 ;
}


int xbox_rread( void *buf, int size1, int size2, void *fd )
{

	return 0 ;
}

void xbox_set_RAM_location() 
{
}

void xbox_read_cd_sector( unsigned char *p, unsigned int sector ) 
{
}
void xbox_stop_audio( ) 
{
}
void writexbox( char *) 
{
}

void sprintfx( const char *fmt, ... )
{
}
void xbox_pause_audio_hugo( int state ) 
{
}
void xbox_play_cdda( unsigned int sectorFrom, unsigned int sectorTo, unsigned char repeat ) 
{
}
void xbox_play_track( unsigned char track, unsigned char repeat ) 
{
}
void xbox_play_track_range( unsigned char track, unsigned char repeat, unsigned int frame_offset, unsigned int numframes ) 
{
}
unsigned int xbox_read_input(int port) 
{
	return 0;
}
int xbox_check_events()
{
	//writexbox( "before events") ;
	return handleEvents() ;
	//writexbox( "after events") ;
	//return 0 ;
}

#ifdef __cplusplus
}
#endif
