/**************************************************************************//*                 Generic Graphic source file                            *//*                                                                        *//*         Adapted by Zeograd (Olivier Jolly) for using Allegro           *//*                                                                        *//**************************************************************************/

#include "pce.h"


void SetPalette(void)
{
  SInt16 i;

  osd_gfx_set_color(255, 0x3f, 0x3f, 0x3f);

  for (i = 0; i < 255; i++)
    osd_gfx_set_color(i, (i & 0x1C) << 1, (i & 0xe0) >> 2, (i & 0x03) << 4);
}


/*
 * calc_fullscreen_aspect:
 * Generic utility that takes the width x height of the current output screen
 * and sets up a gfx lib independent struct generic_rect (gfx.h) with the
 * aspect-correct scaling values, provided option.want_fullscreen_aspect
 * has been set in the config or via the command line.
 */
void calc_fullscreen_aspect(unsigned short physical_screen_width, unsigned short physical_screen_height,
                            struct generic_rect *rect)
{
  /*
   * Routine not called often so extra sanity checks pose no penalty.
   */
  if (physical_screen_height == 0)
  {
    printf("calc_fullscreen_aspect: physical_screen_height is 0!  Aborting . . .\n");
    exit(0);
  }

  if (io.screen_h == 0)
  {
    printf("calc_fullscreen_aspect: io.screen_h is 0!  Aborting . . .\n");
    exit(0);
  }

  if (option.want_fullscreen_aspect)
  {
    float physical_screen_ratio, pce_ratio;
    int new_size;

    physical_screen_ratio = (float) physical_screen_width / physical_screen_height;

    pce_ratio = (io.screen_w / physical_screen_ratio) / io.screen_h;

    if (pce_ratio < 1.0)
    {
      new_size = (physical_screen_width * pce_ratio);

      (*rect).start_x = (physical_screen_width - new_size) / 2;
      (*rect).start_y = 0;
      (*rect).end_x = new_size;
      (*rect).end_y = physical_screen_height;
    }
    else
    {
      new_size = physical_screen_height / pce_ratio;

      (*rect).start_x = 0;
      (*rect).start_y = (physical_screen_height - new_size) / 2;
      (*rect).end_x = physical_screen_width;
      (*rect).end_y = new_size;
    }
  }
  else
  {
    (*rect).start_x = (*rect).start_y = 0;
    (*rect).end_x = physical_screen_width;
    (*rect).end_y = physical_screen_height;
  }
}

//! Computes the new screen height and eventually change the screen mode
void change_pce_screen_height()
{
	//! minimal theorical line where to begin drawing
	int min_display;
	
	//! maximal theorical line where to end drawing
	int max_display;

	int cur_display;

	int temp_vds = io.VDC[VPR].B.h;
	int temp_vsw = io.VDC[VPR].B.l;
	int temp_vdw = io.VDC[VDW].W;
	int temp_vcr = io.VDC[VCR].W;
	
	printf("Changing pce screen mode\nVDS = %04x VSW = %04x VDW = %04x VCR = %04x\n",
			temp_vds,
			temp_vsw,
			temp_vdw,
			temp_vcr
	);
	
	if (temp_vdw == 0)
		return;
	
	min_display = temp_vds + temp_vsw;
	
	max_display = cur_display = min_display;
	while (cur_display < 242 + 14)
		{
			cur_display += temp_vdw;
			max_display = cur_display;
		
			cur_display += 3 + temp_vcr;
		}
	
	min_display = (min_display > 14 ? min_display : 14);
	
	printf("min_display = %d\tmax_display = %d\n", min_display, max_display);
	
	//! Number of lines to render
	io.screen_h = max_display - min_display + 1;
	
	printf("%d lines to render\n", io.screen_h);
	
	(*osd_gfx_driver_list[video_driver].mode) ();
}
