/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

static void UpdateFKB(void);

/* UsrInputType[] is user-specified.  InputType[] is current
	(game loading can override user settings) 
*/
static int UsrInputType[2]={SI_GAMEPAD,SI_GAMEPAD};
static int InputType[2];

static int UsrInputTypeFC={SI_NONE};
static int InputTypeFC;

static uint32 JSreturn;
static int mouseused=0;	/* Set to 1 if mouse functions are ever called. */
int NoWaiting=0;

static void GetMouseData(void);


static int InitKeyboard(void)
{ 
  if(keyboard_init()==-1) 
  {
   puts("Error initializing keyboard.");
   return 0;
  }
  keyboard_translatekeys(TRANSLATE_CURSORKEYS | TRANSLATE_DIAGONAL);
  winit|=2;
  return 1;
}

static void DoCheatSeq(void)
{
 keyboard_close();
 vga_setmode(TEXT);

 DoConsoleCheatConfig();
 InitVideo();
 InitKeyboard();
}


#ifdef LINUX
#include "joystick.c"
#endif

static char *keys;
static int DIPS=0;
static uint8 keyonce[256];
#define KEY(__a) keys[SCANCODE_##__a]
#define keyonly(__a,__z) {if(KEY(__a)){if(!keyonce[SCANCODE_##__a]) {keyonce[SCANCODE_##__a]=1;__z}}else{keyonce[SCANCODE_##__a]=0;}}
static int JoySwap=0;
static int cidisabled=0;
static int KeyboardUpdate(void)
{

 if(!keyboard_update()) 
   if(keys)
    return 0;

  keys=keyboard_getstate();

  if(InputTypeFC==SIFC_FKB)
  {
   keyonly(SCROLLLOCK,cidisabled^=1;
    FCEUI_DispMessage("Family Keyboard %sabled.",cidisabled?"en":"dis");)
   if(cidisabled) return(1);
  }

  keyonly(F3,LockConsole();)  
  keyonly(F4,UnlockConsole();)

  NoWaiting&=~1;
  if(KEY(GRAVE))
   NoWaiting|=1;

  if(gametype==GIT_FDS)
  {
   keyonly(S,DriverInterface(DES_FDSSELECT,0);)
   keyonly(I,DriverInterface(DES_FDSINSERT,0);)
   keyonly(E,DriverInterface(DES_FDSEJECT,0);)
  }
 if(gametype!=GIT_NSF)
 {
  keyonly(F2,DoCheatSeq();)
  keyonly(F5,FCEUI_SaveState();)
  keyonly(F7,FCEUI_LoadState();)
  keyonly(F9,FCEUI_SaveSnapshot();)
 }
 else
 {
  keyonly(CURSORLEFT,DriverInterface(DES_NSFDEC,0);)
  keyonly(CURSORRIGHT,DriverInterface(DES_NSFINC,0);)
  if( KEY(ENTER)) DriverInterface(DES_NSFRES,0);
  if( KEY(CURSORUP)) DriverInterface(DES_NSFINC,0);
  if( KEY(CURSORDOWN)) DriverInterface(DES_NSFDEC,0);
 }

 keyonly(F10,DriverInterface(DES_RESET,0);)
 keyonly(F11,DriverInterface(DES_POWER,0);)
 if(KEY(F12) || KEY(ESCAPE)) FCEUI_CloseGame();

 if(gametype==GIT_VSUNI)
 {
   keyonly(C,DriverInterface(DES_VSUNICOIN,0);)
   keyonly(V,DIPS^=1;DriverInterface(DES_VSUNITOGGLEDIPVIEW,0);)
   if(!(DIPS&1)) goto DIPSless;
   keyonly(1,DriverInterface(DES_VSUNIDIPSET,(void *)1);)
   keyonly(2,DriverInterface(DES_VSUNIDIPSET,(void *)2);)
   keyonly(3,DriverInterface(DES_VSUNIDIPSET,(void *)3);)
   keyonly(4,DriverInterface(DES_VSUNIDIPSET,(void *)4);)
   keyonly(5,DriverInterface(DES_VSUNIDIPSET,(void *)5);)
   keyonly(6,DriverInterface(DES_VSUNIDIPSET,(void *)6);)
   keyonly(7,DriverInterface(DES_VSUNIDIPSET,(void *)7);)
   keyonly(8,DriverInterface(DES_VSUNIDIPSET,(void *)8);)
 }
 else
 {
  keyonly(H,DriverInterface(DES_NTSCSELHUE,0);)
  keyonly(T,DriverInterface(DES_NTSCSELTINT,0);)
  if(KEY(KEYPADMINUS) || KEY(MINUS)) DriverInterface(DES_NTSCDEC,0);
  if(KEY(KEYPADPLUS) || KEY(EQUAL)) DriverInterface(DES_NTSCINC,0);

  DIPSless:
  keyonly(0,FCEUI_SelectState(0);)
  keyonly(1,FCEUI_SelectState(1);)
  keyonly(2,FCEUI_SelectState(2);)
  keyonly(3,FCEUI_SelectState(3);)
  keyonly(4,FCEUI_SelectState(4);)
  keyonly(5,FCEUI_SelectState(5);)
  keyonly(6,FCEUI_SelectState(6);)
  keyonly(7,FCEUI_SelectState(7);)
  keyonly(8,FCEUI_SelectState(8);)
  keyonly(9,FCEUI_SelectState(9);)
 }
 return 1;
}

static uint32 KeyboardDodo(void)
{
 uint32 JS=0;

 if(gametype!=GIT_NSF)
 {
  int x,y;
  x=y=0;
  keyonly(CAPSLOCK,
                   {
                    char tmp[64];
                    JoySwap=(JoySwap+8)%32;
                    sprintf(tmp,"Joystick %d selected.",(JoySwap>>3)+1);
                    FCEUI_DispMessage(tmp);
                   })

  if(KEY(LEFTALT) || KEY(X))        JS|=JOY_A<<JoySwap;
  if(KEY(LEFTCONTROL) || KEY(SPACE) || KEY(Z) ) JS |=JOY_B<<JoySwap;
  if(KEY(ENTER))       JS |= JOY_START<<JoySwap;
  if(KEY(TAB))         JS |= JOY_SELECT<<JoySwap;
  if(KEY(CURSORDOWN))  y|= JOY_DOWN;
  if(KEY(CURSORUP))    y|= JOY_UP;
  if(KEY(CURSORLEFT))  x|= JOY_LEFT;
  if(KEY(CURSORRIGHT)) x|= JOY_RIGHT;
  if(y!=(JOY_DOWN|JOY_UP)) JS|=y<<JoySwap;
  if(x!=(JOY_LEFT|JOY_RIGHT)) JS|=x<<JoySwap;
 }
 return JS;
}

static int powerpadsc[2][12]={
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              },
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              }
                             };

static uint32 powerpadbuf[2];
static int powerpadside=0;

static uint32 UpdatePPadData(int w)
{
 static const char shifttableA[12]={8,9,0,1,11,7,4,2,10,6,5,3};
 static const char shifttableB[12]={1,0,9,8,2,4,7,11,3,5,6,10};
 uint32 r=0;
 int *ppadtsc=powerpadsc[w];
 int x;

 if(powerpadside&(1<<w))
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableA[x];
 }
 else
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableB[x];
 }
 return r;
}
void FCEUD_UpdateInput(void)
{
  int x;
  int t=0;
  static uint32 KeyBJS=0;
  uint32 JS;
  int b;

  b=KeyboardUpdate();

  for(x=0;x<2;x++)
   switch(InputType[x])
   {
    case SI_GAMEPAD:t|=1;break;
    case SI_ARKANOID:t|=2;break;
    case SI_ZAPPER:t|=2;break;
    case SI_POWERPAD:powerpadbuf[x]=UpdatePPadData(x);break;
   }

  switch(InputTypeFC)
  {
   case SIFC_ARKANOID:t|=2;break;
   case SIFC_SHADOW:t|=2;break;
   case SIFC_FKB:if(cidisabled) UpdateFKB();break;
  }

  if(t&1)
  {
   if(b)
    KeyBJS=KeyboardDodo();
   JS=KeyBJS;
   #ifdef LINUX
   if(joy[0]|joy[1]|joy[2]|joy[3])
    JS|=(uint32)GetJSOr();
   #endif
   JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);
  }
  if(t&2)
   GetMouseData();
}
static uint32 MouseData[3];

static void InitMouse(void)
{
    vga_setmousesupport(1);
    mouse_setxrange(0,260);
    mouse_setyrange(0,260);
    mouse_setscale(1);
}

static uint8 fkbkeys[0x48];

static void InitOtherInput(void)
{
   void *InputDPtr;

   int t;
   int x;
   int attrib;

   for(t=0,x=0;x<2;x++)
   {
    attrib=0;
    InputDPtr=0;
    switch(InputType[x])
    {
     case SI_POWERPAD:InputDPtr=&powerpadbuf[x];break;
     case SI_GAMEPAD:InputDPtr=((uint8 *)&JSreturn)+(x<<1);break;     
     case SI_ARKANOID:InputDPtr=MouseData;t|=1;break;
     case SI_ZAPPER:InputDPtr=MouseData;
                                t|=1;
                                attrib=1;
                                break;
    }
    FCEUI_SetInput(x,InputType[x],InputDPtr,attrib);
   }

   attrib=0;
   InputDPtr=0;
   switch(InputTypeFC)
   {
    case SIFC_SHADOW:InputDPtr=MouseData;t|=1;attrib=1;break;
    case SIFC_ARKANOID:InputDPtr=MouseData;t|=1;break;
    case SIFC_FKB:InputDPtr=fkbkeys;break;
   }

   FCEUI_SetInputFC(InputTypeFC,InputDPtr,attrib);
   FCEUI_DisableFourScore(eoptions&EO_NOFOURSCORE);

   if(t)
    InitMouse();

}

static void GetMouseData(void)
{
 int z;
 mouse_update();
 MouseData[0]=mouse_getx();
 MouseData[1]=mouse_gety();
 z=mouse_getbutton();
 MouseData[2]=((z&MOUSE_LEFTBUTTON)?1:0)|((z&MOUSE_RIGHTBUTTON)?2:0);
 mouseused=1;
}

int fkbmap[0x48]=
{
 SCANCODE_F1,SCANCODE_F2,SCANCODE_F3,SCANCODE_F4,SCANCODE_F5,SCANCODE_F6,SCANCODE_F7,SCANCODE_F8,
 SCANCODE_1,SCANCODE_2,SCANCODE_3,SCANCODE_4,SCANCODE_5,SCANCODE_6,SCANCODE_7,SCANCODE_8,SCANCODE_9,SCANCODE_0,
        SCANCODE_MINUS,SCANCODE_EQUAL,SCANCODE_BACKSLASH,SCANCODE_BACKSPACE,
 SCANCODE_ESCAPE,SCANCODE_Q,SCANCODE_W,SCANCODE_E,SCANCODE_R,SCANCODE_T,SCANCODE_Y,SCANCODE_U,SCANCODE_I,SCANCODE_O,
        SCANCODE_P,SCANCODE_GRAVE,SCANCODE_BRACKET_LEFT,SCANCODE_ENTER,
 SCANCODE_LEFTCONTROL,SCANCODE_A,SCANCODE_S,SCANCODE_D,SCANCODE_F,SCANCODE_G,SCANCODE_H,SCANCODE_J,SCANCODE_K,
        SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,SCANCODE_BRACKET_RIGHT,SCANCODE_INSERT,
 SCANCODE_LEFTSHIFT,SCANCODE_Z,SCANCODE_X,SCANCODE_C,SCANCODE_V,SCANCODE_B,SCANCODE_N,SCANCODE_M,SCANCODE_COMMA,
        SCANCODE_PERIOD,SCANCODE_SLASH,SCANCODE_RIGHTALT,SCANCODE_RIGHTSHIFT,SCANCODE_LEFTALT,SCANCODE_SPACE,
 SCANCODE_REMOVE,SCANCODE_END,SCANCODE_PAGEDOWN,
 SCANCODE_CURSORUP,SCANCODE_CURSORLEFT,SCANCODE_CURSORRIGHT,SCANCODE_CURSORDOWN
};

static void UpdateFKB(void)
{
 int x;

 for(x=0;x<0x48;x++)
 {
  fkbkeys[x]=0;
  if(keys[fkbmap[x]])
   fkbkeys[x]=1;
 }
}
