/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *  Copyright (C) 2002 Paul Kuliniewicz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>

#include <sys/stat.h>
#include <sys/types.h>

#include <string.h>

#include <SDL.h>


#include "sdl.h"

DSETTINGS Settings={800,600,8,0,8,239};

int NoWaiting=0;
int sdlgametype;

static void ParseGI(FCEUGI *gi)
{
 sdlgametype=gi->type;
}

void FCEUD_PrintError(char *s)
{
 puts(s);
}

#include "fs.h"		// "mkdir"s, base directory stuff, config loading/saving
			//  argument parsing

int main(int argc, char *argv[])
{
 FCEUGI *tmp;

 puts("Starting FCE Ultra "VERSION_STRING"...\n");

 FCEUI_Initialize();
 
 /* PK: Need to init joystick stuff too */
 if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK)) //|SDL_INIT_AUDIO)==-1)
 {
  printf("Could not initialize SDL: %s.\n", SDL_GetError());
  return(-1);
 }

 BaseDirInit();
 
 /* PK: load config goodies */
 LoadConfig();

 if(!(ParseArgs(argc,argv)))
  return(-1);
 
 InitializeSDLVideo();
 InitializeSDLSound();
 InitializeSDLInput();

 if((tmp=FCEUI_LoadGame(argv[argc-1])))
 {
  ParseGI(tmp);
  FCEUI_Emulate();
 }
 SaveConfig();

 SDL_Quit();

 return(0);
}
