/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"


#define MMC3R mapbyte3
#define MQW mapbyte4
#define MQP mapbyte4[5]


static int atable[16]={0,0,0,0,0,0,0,0,1,3,7,0xF,0x1F,0x3F,0x7F,0xFF};

static uint32 CalcCHR(uint32 b)
{
 b&=atable[MQW[2]&0xF];
 b|=MQW[0];
 b+=(MQW[2]&0x10)<<4;
 return(b);
}

static uint32 CalcPRG(uint32 b)
{
  b&=(MQW[3]&0x3F)^0xFF;
  b&=0x3F;
  b|=MQW[1];
  return(b);
}

static void DoPRG(void)
{
 ROM_BANK8(0x8000^((MMC3_cmd&0x40)<<8),CalcPRG(MMC3R[6]));
 ROM_BANK8(0xc000^((MMC3_cmd&0x40)<<8),CalcPRG(~1));
 ROM_BANK8(0xa000,CalcPRG(MMC3R[7]));
 ROM_BANK8(0xe000,CalcPRG(~0));
}

static void DoCHR(void)
{
 uint32 xor;
 int x;

 xor=(MMC3_cmd&0x80)<<5;
 for(x=0;x<2;x++)
 {
  VROM_BANK1((x*0x800)^xor,CalcCHR(MMC3R[x]));
  VROM_BANK1((x*0x800+0x400)^xor,CalcCHR(MMC3R[x]+1));
 }
 for(x=0;x<4;x++)
  VROM_BANK1((x*0x400+0x1000)^xor,CalcCHR(MMC3R[2+x]));
}

static DECLFW(Mapper45_q)
{
 MQW[MQP]=V;
 MQP=(MQP+1)&3;

 DoPRG();
 DoCHR();
}


static DECLFW(Mapper45_write)
{
        switch(A&0xE001){
        case 0x8000:
	         if((V&0x40) != (MMC3_cmd&0x40))
		  DoPRG();
        	if(VROM_size)
	         if((V&0x80) != (MMC3_cmd&0x80))
		  DoCHR();
	         MMC3_cmd = V;
	         break;

        case 0x8001:if((MMC3_cmd&7)<=1)
		     V&=~1;
		    MMC3R[MMC3_cmd&7]=V;
		    if((MMC3_cmd&7)>=6)
		     DoPRG();
		    else
		     DoCHR();
		    break;

        case 0xA000:
        MIRROR_SET(V&1);
        break;

        case 0xc000:IRQLatch=V;
                    if(resetmode==1)
                     {IRQCount=IRQLatch;}
                    break;
        case 0xc001:resetmode=1;
                    IRQCount=IRQLatch;
                    break;
        case 0xE000:IRQa=0;X6502_IRQEnd(FCEU_IQEXT);
                    if(resetmode==1)
                     IRQCount=IRQLatch;
                    break;
        case 0xE001:IRQa=1;
                    if(resetmode==1)
                     IRQCount=IRQLatch;
                    break;



 }
}

void Mapper45_init(void)
{
 int x;

 MMC3_cmd=0;
 for(x=0;x<8;x++)
  MMC3R[x]=0;
 for(x=0;x<4;x++)
  MQW[0]=0;
 DoCHR();
 DoPRG();

 SetWriteHandler(0x6000,0x6000,Mapper45_q);
 SetWriteHandler(0x8000,0xFFFF,Mapper45_write);
 GameHBIRQHook=MMC3_hb;
}
