/*
 *  Copyright (C) 2002-2004  The DOSBox Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// ******************************************************
// SDL CDROM 
// ******************************************************

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "dosbox.h"
//#include "SDL.h"
#include "support.h"
#include "cdrom.h"
#include "..\..\..\iosupport.h"
#include "..\..\..\iso9660.h"

HANDLE m_doscdrom ;
CIoSupport m_ioM ;
CISO9660 m_dosiso9660 ;

CDROM_Interface_SDL::CDROM_Interface_SDL(void) 
{
	driveID		= 0;
	oldLeadOut	= 0;
	//cd			= 0;

	m_doscdrom = m_ioM.OpenCDROM() ;
	m_dosiso9660.Init( m_doscdrom ) ;
	m_dosiso9660.OpenDisc() ;
};

CDROM_Interface_SDL::~CDROM_Interface_SDL(void) 
{
#ifndef _XBOX
	StopAudio();
	SDL_CDClose(cd);
#endif

	m_ioM.CloseCDROM( m_doscdrom ) ;

	//cd		= 0;
};

bool CDROM_Interface_SDL::ReadSectors(PhysPt buffer, bool raw, unsigned long sector, unsigned long num)
{
	//HANDLE cdHandle = (HANDLE)cd->id ;
	int  numread ;
	Bitu	buflen	= raw ? num*RAW_SECTOR_SIZE : num*COOKED_SECTOR_SIZE;
	Bit8u*	bufdata = new Bit8u[buflen];


	if ( !raw )
		numread = m_ioM.ReadSomeSectors( m_doscdrom, sector, (char*)bufdata, num ) ;
	else
	{
		numread = 0 ;
	}

	MEM_BlockWrite(buffer,bufdata,buflen);
	delete[] bufdata;

	return (numread > 0 ); 
};

bool CDROM_Interface_SDL::SetDevice (char* path, int forceCD) 
{ 
	char buffer[512];
	strcpy(buffer,path);
	upcase(buffer);

#ifdef _XBOX
		driveID = forceCD;
		return true;
#endif

#if 0
	int num = SDL_CDNumDrives();
	if ((forceCD>=0) && (forceCD<num)) {
		driveID = forceCD;
		return true;
	};	
	
	const char* cdname = 0;
	for (int i=0; i<num; i++) {
		cdname = SDL_CDName(i);
		if (strcmp(buffer,cdname)==0) {
			cd = SDL_CDOpen(i);
			SDL_CDStatus(cd);
			driveID = i;
			return true;
		};
	};
	return false; 
#endif
};

bool CDROM_Interface_SDL::GetAudioTracks	(int& stTrack, int& end, TMSF& leadOut)
{

	stTrack = 1 ;
	end = m_ioM.m_toc.cLastTrack;

	leadOut.fr = m_ioM.m_toc.tracks[end].lAddr[3] ;
	leadOut.sec = m_ioM.m_toc.tracks[end].lAddr[2] ;
	leadOut.min = m_ioM.m_toc.tracks[end].lAddr[1] ;

	return true ;

#if 0
	if (CD_INDRIVE(SDL_CDStatus(cd))) {
		stTrack		= 1;
		end			= cd->numtracks;
		FRAMES_TO_MSF(cd->track[cd->numtracks].offset,&leadOut.min,&leadOut.sec,&leadOut.fr);
	}
	return CD_INDRIVE(SDL_CDStatus(cd));
#endif
};

bool CDROM_Interface_SDL::GetAudioTrackInfo (int track, TMSF& start, unsigned char& attr)
{
	start.fr = m_ioM.m_toc.tracks[track-1].lAddr[3] ;
	start.sec = m_ioM.m_toc.tracks[track-1].lAddr[2] ;
	start.min = m_ioM.m_toc.tracks[track-1].lAddr[1] ;

	start.sec += 2 ;

	if ( start.sec > 59 )
	{
		start.sec -= 60 ;
		start.min++ ;
	}

	attr = m_ioM.m_toc.tracks[track-1].cAdrCtrl ;

	return true ;

#if 0
	if (CD_INDRIVE(SDL_CDStatus(cd))) {
		FRAMES_TO_MSF(cd->track[track-1].offset+150,&start.min,&start.sec,&start.fr);
		attr	= cd->track[track-1].type;
	}
	return CD_INDRIVE(SDL_CDStatus(cd));	
#endif
};

bool CDROM_Interface_SDL::GetAudioSub (unsigned char& attr, unsigned char& track, unsigned char& index, TMSF& relPos, TMSF& absPos)
{
	track = 1 ;
	index = 1 ;
	attr = m_ioM.m_toc.tracks[track].cAdrCtrl ;

	relPos.min = 0 ;
	relPos.sec = 0 ;
	relPos.fr = 0 ;

	absPos.min = 0 ;
	absPos.sec = 0 ;
	absPos.fr = 0 ;

	return true  ;

#if 0
	if (CD_INDRIVE(SDL_CDStatus(cd))) {
		track	= cd->cur_track;
		index	= cd->cur_track;
		attr	= cd->track[track].type;
		FRAMES_TO_MSF(cd->cur_frame,&relPos.min,&relPos.sec,&relPos.fr);
		FRAMES_TO_MSF(cd->cur_frame+cd->track[track].offset,&absPos.min,&absPos.sec,&absPos.fr);
	}
	return CD_INDRIVE(SDL_CDStatus(cd));		
#endif
};

bool CDROM_Interface_SDL::GetAudioStatus (bool& playing, bool& pause)
{
	playing = false ;
	pause = false ;

	return true ;

#if 0
	if (CD_INDRIVE(SDL_CDStatus(cd))) {
		playing = (cd->status==CD_PLAYING);
		pause	= (cd->status==CD_PAUSED);
	}
	return CD_INDRIVE(SDL_CDStatus(cd));
#endif
};
	
bool CDROM_Interface_SDL::GetMediaTrayStatus (bool& mediaPresent, bool& mediaChanged, bool& trayOpen)
{
	mediaPresent = m_doscdrom != NULL ;
	mediaChanged = false ;
	trayOpen = false ;

	return true ;

#if 0
	SDL_CDStatus(cd);
	mediaPresent = (cd->status!=CD_TRAYEMPTY) && (cd->status!=CD_ERROR);
	mediaChanged = (oldLeadOut!=cd->track[cd->numtracks].offset);
	trayOpen	 = !mediaPresent;
	oldLeadOut	 = cd->track[cd->numtracks].offset;
	if (mediaChanged) SDL_CDStatus(cd);
	return true;
#endif
};

bool CDROM_Interface_SDL::PlayAudioSector (unsigned long start,unsigned long len) 
{ 
	return true ;
#if 0
	// Has to be there, otherwise wrong cd status report (dunno why, sdl bug ?)
	SDL_CDClose(cd);
	cd = SDL_CDOpen(driveID);
	bool success = (SDL_CDPlay(cd,start+150,len)==0);
	return success;
#endif
};

bool CDROM_Interface_SDL::PauseAudio (bool resume) 
{ 
	return true ;

#if 0
	bool success;
	if (resume) success = (SDL_CDResume(cd)==0);
	else		success = (SDL_CDPause (cd)==0);
	return success;
#endif
};

bool CDROM_Interface_SDL::StopAudio	(void) 
{
	return true ;

#if 0
	// Has to be there, otherwise wrong cd status report (dunno why, sdl bug ?)
	SDL_CDClose(cd);
	cd = SDL_CDOpen(driveID);
	bool success = (SDL_CDStop(cd)==0);
	return success;
#endif
};

bool CDROM_Interface_SDL::LoadUnloadMedia(bool unload) 
{
	return true ;

#if 0
	bool success = (SDL_CDEject(cd)==0);
	return success;
#endif
};	

int CDROM_GetMountType(char* path, int forceCD)
// 0 - physical CDROM
// 1 - Iso file
// 2 - subdirectory
{
	// 1. Smells like a real cdrom 
	// if ((strlen(path)<=3) && (path[2]=='\\') && (strchr(path,'\\')==strrchr(path,'\\')) && 	(GetDriveType(path)==DRIVE_CDROM)) return 0;

	return 0 ;

#if 0
	const char* cdName;
	char buffer[512];
	strcpy(buffer,path);
#if defined (WIN32)
	upcase(buffer);
#endif

	int num = SDL_CDNumDrives();
	// If cd drive is forced then check if its in range and return 0
	if ((forceCD>=0) && (forceCD<num)) {
		LOG(LOG_ALL,LOG_ERROR)("CDROM: Using drive %d",forceCD);
		return 0;
	}

	// compare names
	for (int i=0; i<num; i++) {
		cdName = SDL_CDName(i);
		if (strcmp(buffer,cdName)==0) return 0;
	};
	
	// Detect ISO
	struct stat file_stat;
	stat(path, &file_stat);
	if (S_ISREG(file_stat.st_mode)) return 1;

        return 2;
#endif
};

// ******************************************************
// Fake CDROM
// ******************************************************

bool CDROM_Interface_Fake :: GetAudioTracks	(int& stTrack, int& end, TMSF& leadOut)
{
	stTrack = end = 1;
	leadOut.min	= 60;
	leadOut.sec = leadOut.fr = 0;
	return true;
};

bool CDROM_Interface_Fake :: GetAudioTrackInfo	(int track, TMSF& start, unsigned char& attr)
{
	if (track>1) return false;
	start.min = start.fr = 0;
	start.sec = 2;
	attr	  = 0x60; // data / permitted
	return true;
};

bool CDROM_Interface_Fake :: GetAudioSub (unsigned char& attr, unsigned char& track, unsigned char& index, TMSF& relPos, TMSF& absPos)
{
	attr	= 0;
	track	= index = 1;
	relPos.min = relPos.fr = 0; relPos.sec = 2;
	absPos.min = absPos.fr = 0; absPos.sec = 2;
	return true;
}

bool CDROM_Interface_Fake :: GetAudioStatus	(bool& playing, bool& pause) 
{
	playing = pause = false;
	return true;
}

bool CDROM_Interface_Fake :: GetMediaTrayStatus	(bool& mediaPresent, bool& mediaChanged, bool& trayOpen)
{
	mediaPresent = true;
	mediaChanged = false;
	trayOpen	 = false;
	return true;
};


