// SpeechDll.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "5220intf.h"

extern DWORD buffer_len;
extern int emulation_rate;
extern DWORD ssample_pos;

extern unsigned char *tms5220_speechrom;
extern unsigned long tms5220_speechROMlen;

#if 0
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	if (ul_reason_for_call == DLL_PROCESS_ATTACH) {
		OutputDebugString("SpeechDLL for Classic99 version 1.1\n");
		OutputDebugString("Free code by the MESS team, ported by Tursi\n");
	}
    return TRUE;
}
#endif

void sSpeechInit(unsigned char *pROM, int nRomLen, int nBufferLen, int nEmulationRate) {
	/* determine the output sample rate and buffer size */
	buffer_len = nBufferLen;
	emulation_rate = nEmulationRate;
	ssample_pos = 0;

	tms5220_speechROMlen=nRomLen;
	tms5220_speechrom=pROM;

	tms5220_sh_start();
}

void sSpeechStop() {
	tms5220_sh_stop();
}

unsigned char sSpeechRead() {
	return tms5220_status_r(0);		// address passed is irrelevant
}

void sSpeechWrite(unsigned char Byte) {
	tms5220_data_w(0, Byte);			// address passed is irrelevant
}

void sSpeechProcess(unsigned char *pBuf, int nMax) {
	tms5220_sh_update(pBuf, nMax);
}
