/**********************************************************************************************

     TMS5220 interface

     Written for MAME by Frank Palazzolo
     With help from Neill Corlett
     Additional tweaking by Aaron Giles
     Speech ROM support and a few bug fixes by R Nabet

***********************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <windows.h>
#include <mmsystem.h>
#include <dsound.h>
#include <string.h>

#include "tms5220.h"
#include "5220intf.h"

/* these describe the current state of the output buffer */
DWORD sample_pos;
DWORD buffer_len;
int emulation_rate;
static int INUSE=0;

struct TMS5220interface *intf;

/* static function prototypes */
static void tms5220_update (int force);

/**********************************************************************************************

     tms5220_sh_start -- allocate buffers and reset the 5220

***********************************************************************************************/

int tms5220_sh_start ()
{
    /* reset the 5220 */
    tms5220_reset ();
    tms5220_set_irq (NULL);

    return 0;
}

/**********************************************************************************************

     tms5220_sh_stop -- free buffers

***********************************************************************************************/

void tms5220_sh_stop (void)
{
}

/**********************************************************************************************

     tms5220_sh_update -- update the speech chip

***********************************************************************************************/

void tms5220_sh_update (unsigned char *pBuf, int nMax)
{
	if (INUSE)
		return;				// synchronization

	// fill the buffer stream if it's time 
	// first check how much space we have

	INUSE=1;

	if (nMax>=0) {
		tms5220_process (pBuf, nMax);					// fill new buffer 
	}

	INUSE=0;
}

/**********************************************************************************************

     tms5220_data_w -- write data to the sound chip

***********************************************************************************************/

void tms5220_data_w (int offset, int data)
{
    /* bring up to date first */
    tms5220_update (0);
    tms5220_data_write (data);
}

/**********************************************************************************************

     tms5220_status_r -- read status from the sound chip

***********************************************************************************************/

int tms5220_status_r (int offset)
{
    /* bring up to date first */
    tms5220_update (1);
    return tms5220_read ();
}

/**********************************************************************************************

     tms5220_ready_r -- return the not ready status from the sound chip

***********************************************************************************************/

int tms5220_ready_r (void)
{
    /* bring up to date first */
    tms5220_update (0);
    return tms5220_ready_read ();
}



/**********************************************************************************************

     tms5220_int_r -- return the int status from the sound chip

***********************************************************************************************/

int tms5220_int_r (void)
{
    /* bring up to date first */
    tms5220_update (0);
    return tms5220_int_read ();
}



/**********************************************************************************************

     tms5220_update -- update the sound chip so that it is in sync with CPU execution

***********************************************************************************************/

static void tms5220_update (int force)
{

// this was all about filling the output buffer, so I'll just use the
// 'sh' update routine 

//tms5220_sh_update();
}

