#pragma once
//#include "stdafx.h"
#include <xtl.h>
#define OPCODE inline void

// Opcode function defines
#include <vector>
#include "Opcodes.h"
#include "Direct3D.h"
#include "Chip8 headers.h"
#include "Hacks.h"
#include "DirectInput.h"
#include "Chip8.h"

using namespace std;
extern WORD opcode;
extern uint PC;
extern byte memory[0xFFF];
extern byte screen[0x2000+1];
extern HWND hWnd;
extern bool bExtendedScreen;
extern bool bExit;
extern bool keys[16];
extern uint DT, ST;
extern uint SP;
extern uint HP48Pointer;
extern uint SubPointer;
extern uint iRoutinesJumped;
extern uint I;
extern byte V[16];
extern uint rom_length;
extern bool bDebugOutput;
extern bool bRenderingText;
extern WORD lastOpcode;
extern uint lastPC;
extern bool bRealQuit;
extern uint StopDrawCalltimes;
extern uint stack[16];
extern void (*JumpTableMath[])();

#define get_reg V[ (opcode&0x0F00)>>8 ]
#define get_reg2 V[ (opcode&0x00F0)>>4 ]

OPCODE DrawSprite(bool bExtended)
{
#ifdef _DEBUG
	static uint iCallTimes;
	if (StopDrawCalltimes > 0)
	{
		iCallTimes++;
		if (iCallTimes >= StopDrawCalltimes)
			return;
	}
#endif

//	TRACE("CPU: Executing opcode 0xD000 (standard)...\n");
	int height,width,x,y,coord;
    WORD Pixel;

	x = get_reg;
	y = get_reg2;

	//char temp[200];
	if (x > 128 || y > 64)
	{
		/*wsprintf(temp,"Write coordinates range outside screen!\nX = %i, Y = %i.",x,y);
		RenderText(temp,DT_CRITICAL_ERROR|QUIT_EMULATOR);*/
		return;
	}

	if (!bExtended)
	{
		height = opcode&0x000F;
		width = 8;
	} else {
		height = 16;
		width = 16;
	}

	char msg[100];
#ifdef _DEBUG
	//wsprintf(msg,"Drawing standard sprite at x: 0x%X, y: 0x%X, height: 0x%X, from: 0x%X.\n",x,y,height,I);
	//DRAWTRACE(msg);
#endif
		
	PONG_HACK(x,y);
	PONG2_HACK(x,y);

	int offset = I;
	V[0xF] = 0;
	int number_of_pixels = 0;
	for(int row=0; row<height; row++)
    {
		if (I+row > rom_length && I+row < Chip8FontAddress)
		{
			//wsprintf(msg,"Trying to get data outside rom memory (0x%X)!\n",I+row);
			//RenderText(msg,DT_CRITICAL_ERROR|QUIT_EMULATOR);
		}
		if (!bExtended)
			Pixel = memory[I+row]; // Byte Per Line
		else
		{
			Pixel = (memory[offset] << 8) + memory[offset+1];
			offset += 2;
		}
		for(int line=0; line<width; line++)
		{
			bool bSet = false;
			if (!bExtended)
				bSet = ( Pixel & (0x80>>line) ) != 0;
			else
				bSet = ( Pixel & (0x8000>>line) ) != 0;
			if(bSet)
			{
				if (!bExtendedScreen)
					coord = ( line + x + ( (y+row) * 64) );
				else
					coord = ( line + x + ( (y+row) * 128) );
				if (coord > 0x2080)
				{
					/*wsprintf(temp,"Trying to write outside screen!\nX = %i, Y = %i, Line = %i, Row = %i, Coordinates = 0x%X",x,y,line,row,coord);
					RenderText(temp,DT_CRITICAL_ERROR|QUIT_EMULATOR);*/
					return;
				}
				if(screen[coord] == 1) V[0xF] = 1;
				screen[coord] ^= 1;
			}
		}
    }
	RenderScreen();
}

OPCODE Scroll_Down()
{
	int lines = opcode&0x000F;
	int width = screen_width();
	char temp[128*64];
	ZeroMemory(temp,sizeof(temp));
	memcpy(temp+(width*lines),screen,(128*64)-width*lines);
	memcpy(screen,temp,sizeof(temp));
	RenderScreen();
}

OPCODE Scroll_Right()
{
	byte temp_screenr[128*64];
	int scroll_right = bExtendedScreen ? 4 : 2;
	ZeroMemory(temp_screenr,sizeof(temp_screenr));
	for (int i=0; i<64; i++)
	{
		for (int j=0; j<128; j++)
		{
			if (screen[i*128+j])
				if ( ( (i*128+j) + scroll_right ) < ( (i+1)*128 ) )
					temp_screenr[(i*128+j)+scroll_right] = 1;
		}
	}
	memcpy(screen,temp_screenr,sizeof(screen));
	RenderScreen();
}

OPCODE Scroll_Left()
{
	byte temp_screenl[128*64];
	int scroll_left; scroll_left = bExtendedScreen ? 4 : 2;
	ZeroMemory(temp_screenl,sizeof(temp_screenl));
	for (int i=0; i<64; i++)
	{
		for (int j=0; j<128; j++)
		{
			if (screen[i*128+j])
				if ( ( (i*128+j) - scroll_left ) >= (i*128) )
					temp_screenl[(i*128+j)-scroll_left] = 1;
		}
	}
	memcpy(screen,temp_screenl,sizeof(screen));
	RenderScreen();
}

OPCODE TerminateSystem()
{
	RenderText("The game has requested to terminate the system.",QUIT_EMULATOR);
	bRealQuit = true;
}

OPCODE EnableExtScreen()
{
	bExtendedScreen = true;
	UpdateInfo();
}

OPCODE DisableExtScreen()
{
	bExtendedScreen = false;
	UpdateInfo();
}

OPCODE ClearScreen()
{
	ZeroMemory(screen,128*64);
	RenderScreen();
}

OPCODE ReturnFromSub()
{
	valid_addr_or_op(PC, type_jumpcheck);
	iRoutinesJumped--;
	PC = stack[iRoutinesJumped];
}

OPCODE Various()
{
	switch (opcode&0x00F0)
	{
		// SuperChip8 opcodes below.
		case 0x00C0: // Scroll the screen down X lines
			Scroll_Down();
			return;
		case 0x00F0:
			switch(opcode&0x000F)
			{
				case 0x000B: // Scroll screen 4 pixels right
					Scroll_Right();
					return;
				case 0x000C: // Scroll screen 4 pixels left
					Scroll_Left();
					break;
				case 0x000D: // Requests to terminate the system.
					TerminateSystem();
					break;
				case 0x000E: // Disable extended screen mode 
					DisableExtScreen();
					break;
				case 0x000F: // Enable extended screen mode (128x64)
					EnableExtScreen();
					break;
			}
			return;
		// SuperChip 8 opcodes end
		// 0x00E0 case begin
		case 0x00E0:
			switch(opcode&0x000F)
			{
				case 0x0000: // Clear screen
					ClearScreen();
					break;
				case 0x000E: // Return from subroutine call
					ReturnFromSub();
					break;
			}
			break;
			// 0x00E0 case end
		default:
			UnknownInstruction();
			break;
	}
}

OPCODE Jump_XXX()
{
	PC = (opcode&0x0FFF);
	PC -= 2;
}

OPCODE Jump_Sub()
{
	valid_addr_or_op( (opcode&0x0FFF),type_offset );
	stack[iRoutinesJumped] = PC;
	PC = (opcode&0x0FFF);
	PC -= 2;
	iRoutinesJumped++;
}

OPCODE Skip_Reg_Eq_XXX() { if (get_reg == (opcode&0x00FF)) PC += 2; }
OPCODE Skip_Reg_NEq_XXX() { if (get_reg != (opcode&0x00FF)) PC += 2; }
OPCODE Skip_Reg_Eq_Reg() { if (get_reg == get_reg2) PC += 2; }
OPCODE Move_Reg_XXX() { get_reg = opcode&0x00FF; }
OPCODE Add_Reg_XXX() { get_reg += opcode&0x00FF; }

OPCODE Math_Move_XY() { get_reg = get_reg2; }
OPCODE Math_OR() { get_reg |= get_reg2; }
OPCODE Math_AND() { get_reg &= get_reg2; }
OPCODE Math_XOR (){ get_reg ^= get_reg2; }

OPCODE Math_Add_XY_Carry() 
{
	V[0xF] = get_reg & 0x01;
	get_reg += get_reg2;
}

OPCODE Math_Sub_XY_Carry() 
{
	if(get_reg >= get_reg2) V[0xF] = 0x1;
	else V[0xF] = 0x0;
	get_reg -= get_reg2;
}

OPCODE Math_Shift_Right()
{
	V[0xF] = get_reg & 0x01;
	get_reg >>= 1;
}

OPCODE Math_Sub_YX()
{
	if(get_reg2 >= get_reg) V[0xF] = 0x1;
	else V[0xF] = 0x0;
	get_reg = get_reg2 - get_reg;
}

OPCODE Math_Shift_Left()
{
	V[0xF] = ( (get_reg>>7) & 0x01);
	get_reg <<= 1;
}

OPCODE Math()
{
	JumpTableMath[opcode&0x000F]();
	//switch(opcode&0x000F)
	//{
	//	case 0x0: // Move register X into register Y
	//		break;
	//	case 0x1: // OR reg Y into register X
	//		break;
	//	case 0x2: // AND reg Y into register X
	//		break;
	//	case 0x3: // Exclusive OR register X into register Y
	//		break;
	//	case 0x4: // Add register Y to register X, carry in V[F]
	//		break;
	//	case 0x5: // Subtract XXX from register Y, borrow in V[F]
	//		break;
	//	case 0x6: // Shift XXX right 1, bit 1 goes into V[F]
	//		break;
	//	case 0x7: // Subtract reg X from register Y, result in register X
	//		break;
	//	case 0x8: // Empty opcodes
	//	case 0x9:
	//	case 0xA:
	//	case 0xB:
	//	case 0xC:
	//	case 0xD:
	//		TRACE("Warning: trying to execute empty math opcode!\n");
	//		break;
	//	case 0xE: // Shift XXX left 1, bit 1 goes into V[F]
	//		break;
	//	case 0xF: // Empty opcode
	//		TRACE("Warning: trying to execute empty math opcode!\n");
	//		break;
	//}
}

OPCODE Skip_Reg_NEq_Reg() { if (get_reg != get_reg2) PC += 2; }
OPCODE Load_I_XXX() { I = opcode&0x0FFF; /*ITRACE("Opcode0A",opcode,I);*/ }
OPCODE Jump_XXX_V0() { PC = (opcode&0x0FFF)+V[0]; }
OPCODE Rand_Number() { get_reg = ( rand() & (opcode&0x00FF) ); }
//get_reg = rand()&(opcode&0x00FF);
OPCODE Draw() 
{ 
	if (bRenderingText) return;
	DrawSprite( ( (opcode&0x000F) == 0 ) ); 
}

OPCODE Skip_Key()
{
	uint key = get_reg;
	switch(opcode&0x00FF)
	{
		case 0x9E: // Skip if pressed
			if (keys[key]) PC += 2;
			break;
		case 0xA1: // Skip if not pressed
			if (!keys[key]) PC += 2;
			break;
	}
}

OPCODE System()
{
	int i;
	switch(opcode&0x00FF)
	{
		case 0x07: // Get delay timer into register X
			get_reg = DT;
			break;
		case 0x0A: // Wait for keypress, put key in register X
			int key; key = CheckKeyRegisters();
			if (key > -1 && key < 16)
				get_reg = key;
			else
				PC -= 2;
			//get_reg = 0;
			break;
		case 0x15: // Set the delay timer to XXX
			DT = get_reg;
			break;
		case 0x18: // Set the sound timer to XXX
			ST = get_reg;
			break;
		case 0x1E: // Add register X to I
			I += get_reg;
			//ITRACE("Opcode F01E",opcode,I);
			break;
		case 0x29: // Point I to the sprite for hexadecimal character in register X
			I = Chip8FontAddress + (get_reg * 5);
			//ITRACE("Opcode F029",opcode,I);
			break;
		case 0x30: // Point I to the sprite for hexadecimal character in register X (SuperChip only)
			I = SChip8FontAddress + (get_reg * 10);
			//ITRACE("Opcode F030",opcode,I);
			break;
		case 0x33: // Store the bcd representation of XXX at location I,I+1,I+2
			i = get_reg;
			//BYTE BCD[3];
			//BCD[0] = i/100;
			//BCD[1] = i - ((i - (BCD[0]*100))/10);
			//BCD[2] = ((i - ((BCD[0]*100) + (BCD[1]*10))));
			//memory[I] = BCD[0];
			//memory[I+1] = BCD[1];
			//memory[I+2] = BCD[2];
			memory[I]   = (i/100);
			memory[I+1] = (i%100)/10;
			memory[I+2] = (i%10);
			break;
		case 0x55: // Store registers v[0] to V[X] at location I onwards 
			for (i=0; i <= ((opcode&0x0F00) >> 8); i++)
			{
				//ITRACE("Opcode F055",opcode,I);
				memory[I+i] = V[i];
			}
			break;
		case 0x65: // Load registers V[0] to V[X] from location I onwards 
			for (i=0; i <= ((opcode&0x0F00) >> 8); i++)
			{
				//ITRACE("Opcode F065",opcode,I);
				V[i] = memory[I+i];
			}
			break;
		case 0x75:
			for (i=0; i <= ((opcode&0x0F00) >> 8); i++)
				memory[HP48Pointer+i] = V[i];
			break;
		case 0x85:
			for (i=0; i <= ((opcode&0x0F00) >> 8); i++)
				V[i] = memory[HP48Pointer+i];
			break;
		default:
			// Unknown instruction or unhandled
			UnknownInstruction();
			break;
	}
}