#include "DirectInput.h"
#include "Direct3D.h"

extern bool bExit;
extern HINSTANCE hInst;
extern HWND hWnd;

enum Chip8_Keys
{
	KEY0 = 9, KEY1, KEY2, KEY3, KEY4, KEY5, KEY6, KEY7, KEY8, KEY9, KEYA,
	KEYB, KEYC, KEYD, KEYE, KEYF, KEYENTER, KEY_STEPIN, KEY_STEPOVER,
	KEY_STEPOUT
};

#if 0
DIACTION g_DirectionMappings[] =
{
    // Gamepad
	/*{ KEY0,  DIBUTTON_ANY(0), 0, TEXT("Key 0"), },
    { KEY1,  DIBUTTON_ANY(1), 0, TEXT("Key 1"), },
    { KEY2,  DIBUTTON_ANY(2), 0, TEXT("Key 2"), },
    { KEY3,  DIBUTTON_ANY(3), 0, TEXT("Key 3"), },
    { KEY4,  DIBUTTON_ANY(4), 0, TEXT("Key 4"), },
    { KEY5,  DIBUTTON_ANY(5), 0, TEXT("Key 5"), },
    { KEY6,  DIBUTTON_ANY(6), 0, TEXT("Key 6"), },
    { KEY7,  DIBUTTON_ANY(7), 0, TEXT("Key 7"), },
    { KEY8,  DIBUTTON_ANY(8), 0, TEXT("Key 8"), },
    { KEY9,  DIBUTTON_ANY(9), 0, TEXT("Key 9"), },
    { KEYA,  DIBUTTON_ANY(10), 0, TEXT("Key A"), },
    { KEYB,  DIBUTTON_ANY(11), 0, TEXT("Key B"), },
    { KEYC,  DIBUTTON_ANY(12), 0, TEXT("Key C"), },
    { KEYD,  DIBUTTON_ANY(13), 0, TEXT("Key D"), },
    { KEYE,  DIBUTTON_ANY(14), 0, TEXT("Key E"), },
    { KEYF,  DIBUTTON_ANY(15), 0, TEXT("Key F"), },
	{ KEYENTER, DIBUTTON_ANY(16), 0, "Key Enter", },*/

	// Keyboard
	{ KEY0,  DIKEYBOARD_X, 0, TEXT("Key 0"), },
    { KEY1,  DIKEYBOARD_1, 0, TEXT("Key 1"), },
    { KEY2,  DIKEYBOARD_2, 0, TEXT("Key 2"), },
    { KEY3,  DIKEYBOARD_3, 0, TEXT("Key 3"), },
    { KEY4,  DIKEYBOARD_Q, 0, TEXT("Key 4"), },
    { KEY5,  DIKEYBOARD_W, 0, TEXT("Key 5"), },
    { KEY6,  DIKEYBOARD_E, 0, TEXT("Key 6"), },
    { KEY7,  DIKEYBOARD_A, 0, TEXT("Key 7"), },
    { KEY8,  DIKEYBOARD_S, 0, TEXT("Key 8"), },
    { KEY9,  DIKEYBOARD_D, 0, TEXT("Key 9"), },
    { KEYA,  DIKEYBOARD_Z, 0, TEXT("Key A"), },
    { KEYB,  DIKEYBOARD_C, 0, TEXT("Key B"), },
    { KEYC,  DIKEYBOARD_4, 0, TEXT("Key C"), },
    { KEYD,  DIKEYBOARD_R, 0, TEXT("Key D"), },
    { KEYE,  DIKEYBOARD_F, 0, TEXT("Key E"), },
    { KEYF,  DIKEYBOARD_V, 0, TEXT("Key F"), },
	{ KEYENTER,		 DIKEYBOARD_RETURN, 0, "Key Enter", },
	{ KEY_STEPIN,	 DIKEYBOARD_F11,	0, "Step in/out", },
	{ KEY_STEPOVER,	 DIKEYBOARD_F10,	0, "Step over", },
	{ KEY_STEPOUT, DIKEYBOARD_LSHIFT, 0, "", },
	{ KEY_STEPOUT, DIKEYBOARD_RSHIFT, 0, "", },
};

void DestroyDInput()
{
	DI_Destroy();
}
#endif

int GetKeyboardPress()
{
#if 0
	__UserInput result;
	ZeroMemory(&result,sizeof(result));
	DI_GetBufferedData(&result,NULL,false);

	for (int i=0; i<16; i++)
		if (result.button[i] & 0x80) return i;
	if (result.kLeft & 0x80) return 16;
	if (result.kRight & 0x80) return 17;
	if (result.kUp & 0x80) return 18;
	if (result.kDown & 0x80) return 19;
	if (result.button[16] & 0x80) return 20;
	if (result.bQuit & 0x80) return 0xFF;
#endif
	return -1;
}

int CheckKeyRegisters()
{
	for (int i=0; i<16; i++)
		if (keys[i]) return i;
	return -1;
}

bool InitDInput()
{
#if 0
	Profile_Info def_profile;
	def_profile.diActions = g_DirectionMappings;
	def_profile.dwActions = sizeof(g_DirectionMappings) / sizeof(DIACTION);
	def_profile.profile = "Default";
	
	DInputInit_Info info;
	info.bShowProfiles = false;
	info.dwGenre = DIVIRTUAL_ARCADE_SIDE2SIDE;
	info.dwLeftRightConst = DIAXIS_ARCADES_MOVE;
	info.dwUpDownConst = DIAXIS_ARCADES_LATERAL;
	info.dwStartConst = DIBUTTON_ARCADES_MENU;
	info.hWnd = hWnd;
	info.NumOfKeys = 20; // CHANGE WHEN ADDING KEYS
	info.pAddCallback = NULL;
	info.pProfiles.push_back(def_profile);
	info.regpath = "Software\\Doom's infested key\\Chuit";
	info.title = emu_title;
	// CHANGE WHEN ADDING KEYS
	info.iValues.push_back(KEY0); info.iValues.push_back(KEY1); info.iValues.push_back(KEY2);
	info.iValues.push_back(KEY3); info.iValues.push_back(KEY4); info.iValues.push_back(KEY5);
	info.iValues.push_back(KEY6); info.iValues.push_back(KEY7); info.iValues.push_back(KEY8);
	info.iValues.push_back(KEY9); info.iValues.push_back(KEYA); info.iValues.push_back(KEYB);
	info.iValues.push_back(KEYC); info.iValues.push_back(KEYD); info.iValues.push_back(KEYE);
	info.iValues.push_back(KEYF); info.iValues.push_back(KEYENTER);
	info.iValues.push_back(KEY_STEPIN); info.iValues.push_back(KEY_STEPOVER);
	info.iValues.push_back(KEY_STEPOUT);
	// CHANGE WHEN ADDING KEYS

	HRESULT hr;
	if (FAILED(hr = DI_Init(&info)))
	{
		char msg[100];
		wsprintf("Failed to initialize DirectInput!\nReturned error: 0x%X",DXGetErrorString9(hr));
		MessageBox(hWnd,msg,emu_title,MB_ICONERROR);
		return false;
	}
#endif
	return true;
}

void ClearKeys()
{
	for (int i=0; i<16; i++)
		keys[i] = false;
}
#if 0
bool AddCallback(const DIDEVICEINSTANCE* pdidi)
{
	if ( (pdidi->dwDevType & 0xFF) != DI8DEVTYPE_KEYBOARD)
		return false;
	else
		return true;
}
#endif
