#include "Debug.h"
#include "main.h"
#include "direct3d.h"
#include "directinput.h"
#include "Chip8 headers.h"
#include <vector>
extern byte V[0xF+1]; // Registers
extern uint PC;
extern uint I;
extern uint DT;
extern uint ST;
extern HWND hWnd;
extern byte memory[0xFFF];
extern WORD opcode;
extern bool bExtendedScreen;
extern uint iRoutinesJumped;
extern byte screen[128*64];
extern uint HP48Pointer;
extern uint rom_length;
extern uint stack[16];
extern bool keys[16];
using namespace std;

bool bFound = false;
uint BreakPC = 0;
uint BreakTimes = 0;
uint BreakHit = 0;
bool bTerminate = false;
HWND hDebugWin;

#define LIST_GETSTRING(hListbox,index,buffer) \
	SendMessage(hListbox,LB_GETTEXT,index,(LPARAM)buffer)
#define LIST_GETCURRENTINDEX(hListbox) \
	SendMessage(hListbox,LB_GETCURSEL,0,0)
#define LIST_ADDSTRING(hListbox,text) \
	SendMessage(hListbox,LB_ADDSTRING,0,(LPARAM)text)
#define LIST_SETTAG(hListbox,index,tag) \
	SendMessage(hListbox,LB_SETITEMDATA,(WPARAM)index,(LPARAM)tag)
#define LIST_GETTAG(hListbox,index) \
	SendMessage(hListbox,LB_GETITEMDATA,(WPARAM)index,0)
#define LIST_SETSELECTION(hListbox,index) \
	SendMessage(hListbox,LB_SETCURSEL,index,0)
#define GET_TEXT(hItem,buffer,length) \
	SendMessage(hItem,WM_GETTEXT,length,(LPARAM)buffer);

void ShowDebugDlg()
{
	HANDLE hThread = CreateThread(NULL,NULL,InputThread,NULL,CREATE_SUSPENDED,NULL);
	SetThreadPriority(hThread,THREAD_PRIORITY_IDLE);
	ResumeThread(hThread);
	DialogBox(GetModuleHandle(NULL),"IDD_DEBUGGER",hWnd,DebugWnd);
	bTerminate = true;
}

void FillDebugData(HWND hDebugWnd)
{
	char text[10];

	wsprintf(text,"%0.2X",V[0]);
	SetDlgItemText(hDebugWnd,IDC_V0,text);
	wsprintf(text,"%0.2X",V[1]);
	SetDlgItemText(hDebugWnd,IDC_V1,text);
	wsprintf(text,"%0.2X",V[2]);
	SetDlgItemText(hDebugWnd,IDC_V2,text);
	wsprintf(text,"%0.2X",V[3]);
	SetDlgItemText(hDebugWnd,IDC_V3,text);
	wsprintf(text,"%0.2X",V[4]);
	SetDlgItemText(hDebugWnd,IDC_V4,text);
	wsprintf(text,"%0.2X",V[5]);
	SetDlgItemText(hDebugWnd,IDC_V5,text);
	wsprintf(text,"%0.2X",V[6]);
	SetDlgItemText(hDebugWnd,IDC_V6,text);
	wsprintf(text,"%0.2X",V[7]);
	SetDlgItemText(hDebugWnd,IDC_V7,text);
	wsprintf(text,"%0.2X",V[8]);
	SetDlgItemText(hDebugWnd,IDC_V8,text);
	wsprintf(text,"%0.2X",V[9]);
	SetDlgItemText(hDebugWnd,IDC_V9,text);
	wsprintf(text,"%0.2X",V[10]);
	SetDlgItemText(hDebugWnd,IDC_V10,text);
	wsprintf(text,"%0.2X",V[11]);
	SetDlgItemText(hDebugWnd,IDC_V11,text);
	wsprintf(text,"%0.2X",V[12]);
	SetDlgItemText(hDebugWnd,IDC_V12,text);
	wsprintf(text,"%0.2X",V[13]);
	SetDlgItemText(hDebugWnd,IDC_V13,text);
	wsprintf(text,"%0.2X",V[14]);
	SetDlgItemText(hDebugWnd,IDC_V14,text);
	wsprintf(text,"%0.2X",V[15]);
	SetDlgItemText(hDebugWnd,IDC_V15,text);
	wsprintf(text,"%0.3X",PC);
	SetDlgItemText(hDebugWnd,IDC_PC,text);
	wsprintf(text,"%0.3X",I);
	SetDlgItemText(hDebugWnd,IDC_I,text);
	wsprintf(text,"%0.3X",DT);
	SetDlgItemText(hDebugWnd,IDC_DELAYTIMER,text);
	wsprintf(text,"%0.3X",ST);
	SetDlgItemText(hDebugWnd,IDC_SOUNDTIMER,text);
	LIST_SETSELECTION( GetDlgItem(hDebugWnd,IDC_OPS), (PC - 0x200) / 2 );
	SendMessage( GetDlgItem(hDebugWnd,IDC_OPS), LB_SETTOPINDEX, (PC - 0x200) / 2, 0 );
}

INT_PTR CALLBACK DebugWnd(HWND hDlg,UINT message,WPARAM wParam,LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			hDebugWin = hDlg;	
			RECT rDebug;
			long lScrnWidth, lScrnHeight;
			int xpos, ypos;
			GetClientRect(hDlg,&rDebug);
			lScrnWidth = GetSystemMetrics(SM_CXSCREEN);
			lScrnHeight = GetSystemMetrics(SM_CYSCREEN);
			xpos = (lScrnWidth / 2) - (rDebug.right / 2);
			ypos = (lScrnHeight / 2) - (rDebug.bottom / 2);
			SetWindowPos(hDlg,NULL,xpos,ypos,0,0,SWP_NOSIZE);

			FillDebugData(hDlg);
			AddOps(hDlg);
			return TRUE;
		case WM_SETTEXT:
			break;
		case WM_COMMAND:
			WORD nId;
			WORD nSomethingElse;
			nId = LOWORD(wParam);
			nSomethingElse = HIWORD(wParam);
			if (nSomethingElse != BN_CLICKED) break;
			if (nId == IDOK || nId == IDCANCEL || nId == IDC_NODEBUG) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}

			//char buffer[MAX_PATH];
			WORD OpCode;
			HWND hListBox;
			uint TargetPC;
			hListBox = GetDlgItem(hDlg,IDC_OPS);
			OpCode = (WORD)LIST_GETTAG( hListBox,LIST_GETCURRENTINDEX(hListBox) );
			TargetPC = 0x200 + ((uint)LIST_GETCURRENTINDEX(hListBox) * 2);
			
			#define ShowPopupMenu(menu) \
			GetCursorPos(&p); \
			hMenu = LoadMenu(GetModuleHandle(NULL),MAKEINTRESOURCE(menu)); \
			hMenu = GetSubMenu(hMenu,0); \
			nID = TrackPopupMenu(hMenu,TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RETURNCMD,p.x,p.y,0,hDlg,NULL);

			int nID;
			HMENU hMenu;
			POINT p;
			nID = 0xFFFFFFFF;
			switch(LOWORD(wParam))
			{
				case IDC_STEP:			ShowPopupMenu(IDR_STEP); break;
				case IDC_OPCODES:		ShowPopupMenu(IDR_OPCODES); break;
				case IDC_BREAKPOINTS:	ShowPopupMenu(IDR_BREAKPOINTS); break;
				case IDC_STATES:		ShowPopupMenu(IDR_STATES); break;
				case IDC_PRESSKEY:		PressKey(hDlg); break;
				case IDC_SYNCOPS:		AddOps(hDlg); break;
			}
			switch(nID)
			{
				case ID_STEP_IN:		  EmulationThread(NULL); break;
				case ID_STEP_OVER:
					CreateBreakPoint(hDlg,PC+2);
					GotoBreakPoint(NULL);
					break;
				case ID_STEP_OUT:		  StepOut();
				case ID_OPCODES_NEXT:	  NextOp(OpCode,TargetPC); break;
				case ID_OPCODES_RUNTO:	  RunToOp(hDlg,TargetPC); break;
				case ID_OPCODES_SKIPTO:   SkipToOp(TargetPC); break;
				case ID_STATES_SAVE:	  SaveState("Chuit_savestate.state"); break;
				case ID_STATES_LOAD:	  LoadState("Chuit_savestate.state"); break;
				case ID_BREAKPOINTS_SET:  CreateBreakPoint(hDlg,TargetPC); break;
				case ID_BREAKPOINTS_GOTO: 
					CreateThread(NULL,NULL,GotoBreakPoint,NULL,NULL,NULL);
					break;
			}
			//SetRegisters();
			FillDebugData(hDlg);
			return TRUE;
		case WM_DESTROY:
			break;
	}
    return FALSE;
}

void RunToOp(HWND hDlg,uint TargetPC)
{
	uint BackupPC = PC;
	//SkipToOp(TargetPC); // To check if the opcode can be reached
	//if (PC == BackupPC) return; // Failure
	//PC = BackupPC;
	EnableWindow( GetDlgItem(hDlg,IDC_STEP), false );
	EnableWindow( GetDlgItem(hDlg,IDC_NEXTOP), false );
	EnableWindow( GetDlgItem(hDlg,IDC_RUNTOOP), false );
	EnableWindow( GetDlgItem(hDlg,IDC_SKIPTOOP), false );
	EnableWindow( GetDlgItem(hDlg,IDC_SAVESTATE), false );
	EnableWindow( GetDlgItem(hDlg,IDC_LOADSTATE), false );
	EnableWindow( GetDlgItem(hDlg,IDC_NODEBUG), false );
	EnableWindow( GetDlgItem(hDlg,IDC_PRESSKEY), false );

	SaveState("temp.state");
	HANDLE hThread = CreateThread(NULL,NULL,RunToOpThread,(LPVOID)(__int64)TargetPC,NULL,NULL);
	for (int i=0; i<100; i++)
	{
		Sleep(10);
		if (bFound) break;
	}
	if (!bFound)
	{
		bFound = true; //Signal thread to terminate
		MessageBox(NULL,"Unable to reach destination or it took too long time.",emu_title,MB_ICONERROR);
		PC = BackupPC;
		LoadState("temp.state");
	}

	EnableWindow( GetDlgItem(hDlg,IDC_STEP), true );
	EnableWindow( GetDlgItem(hDlg,IDC_NEXTOP), true );
	EnableWindow( GetDlgItem(hDlg,IDC_RUNTOOP), true );
	EnableWindow( GetDlgItem(hDlg,IDC_SKIPTOOP), true );
	EnableWindow( GetDlgItem(hDlg,IDC_SAVESTATE), true );
	EnableWindow( GetDlgItem(hDlg,IDC_LOADSTATE), true );
	EnableWindow( GetDlgItem(hDlg,IDC_NODEBUG), true );
	EnableWindow( GetDlgItem(hDlg,IDC_PRESSKEY), true );
	bFound = false;
}

void SkipToOp(uint TargetPC)
{
	WORD NewOp = 0xFFFF;
	uint NewPC = PC;
	int StackPC = 0;
	vector<int> Stack;

	while (NewPC != TargetPC)
	{
		NewOp = ((memory[NewPC]<<8) + memory[NewPC+1]);
		switch(NewOp & 0xF000)
		{
			case 0x1000: NewPC = NewOp & 0x0FFF; break;
			case 0x2000: 
				Stack.push_back(NewPC);
				NewPC = NewOp & 0x0FFF;
				StackPC++;
				break;
			case 0x0000:
				if ( (NewOp & 0x00FF) == 0x00EE )
				{
					NewPC = Stack[StackPC];
					Stack.pop_back();
					StackPC--;
				}
				break;
		}
		NewPC += 2;
		if (NewPC > TargetPC)
		{
			MessageBox(NULL,"Target opcode cannot be reached!",emu_title,MB_ICONERROR);
			return;
		}
	}
	PC = NewPC;
}

void NextOp(WORD OpCode, uint TargetPC)
{
	/*uint BackupPC = PC;
	SkipToOp(TargetPC); // To check if the opcode can be reached
	if (PC == BackupPC) return; // Failure
	PC = BackupPC;*/

	WORD NewOp = 0xFFFF;
	/*int NewPC = PC;
	int StackPC = 0;
	vector<int> Stack;*/

	for(;;)
	{
		NewOp = ((memory[PC]<<8) + memory[PC+1]);
		if ( ((NewOp & 0xF000) == (OpCode & 0xF000)) &&
			 PC > TargetPC) break;
		EmulationThread(NULL);
		/*switch(NewOp & 0xF000)
		{
			case 0x1000: NewPC = NewOp & 0x0FFF; break;
			case 0x2000: 
				Stack.push_back(NewPC);
				NewPC = NewOp & 0x0FFF;
				StackPC++;
				break;
			case 0x0000:
				if ( (NewOp & 0x00FF) == 0x00EE )
				{
					NewPC = Stack[StackPC];
					Stack.pop_back();
					StackPC--;
				}
				break;
		}
		NewPC += 2;*/
	}
}

void AddOps(HWND hDebugWnd)
{
	HWND hListBox = GetDlgItem(hDebugWnd,IDC_OPS);
	WORD NewOp = 0xFFFF;
	uint NewPC = PC; //0x200;
	int StackPC = 0;
	int index = 0;
	vector<int> Stack;
	char* buffer;
	bool bInvalid = false;
	SendMessage( GetDlgItem(hDebugWnd,IDC_OPS), LB_SETTOPINDEX, 0, 0 );
	SendMessage(hListBox,LB_RESETCONTENT,0,0);

	if (NewPC > 0x200)
	{
		while(NewPC > 0x200)
		{
			index = (int)LIST_ADDSTRING(hListBox,"<Unknown data>");
			NewPC -= 2;
		}
	}
	SendMessage(hListBox,LB_DELETESTRING,index,0);
	NewPC = PC;
	while(NewPC < rom_length)
	{
		NewOp = ((memory[NewPC]<<8) + memory[NewPC+1]);
		if ( !IsValidOp(NewOp) )
		{
			buffer = new char[100];		
			wsprintf(buffer,"Game data? (0x%0.4X)",NewOp);
		}
		else
			buffer = TranslateOp(NewOp);
		index = (int)LIST_ADDSTRING(hListBox,buffer);
		LIST_SETTAG(hListBox,index,NewOp);
		delete [] buffer;
		NewPC += 2;
	}
	SendMessage( GetDlgItem(hDebugWnd,IDC_OPS), LB_SETTOPINDEX, 0, 0 );
}

bool IsValidOp(WORD OpCode)
{
	switch(OpCode & 0xF000)
	{
		case 0x0000:
			switch(OpCode & 0x00F0)
			{
				case 0xC0: break;
				case 0xE0:
					switch(OpCode & 0x000F)
					{
						case 0x0: 
						case 0xE:
							break;
						default: return false;
					}
					break;
				case 0xF0:
					switch(OpCode & 0x000F)
					{
						case 0xB:
						case 0xC:
						case 0xD:
						case 0xE:
						case 0xF:
							break;
						default: return false;
					}
					break;
				default: return false;
			}
			break;
		case 0x8000:
			switch(OpCode & 0x000F)
			{
				case 0x0:
				case 0x1:
				case 0x2:
				case 0x3:
				case 0x4:
				case 0x5:
				case 0x6:
				case 0x7:
				case 0xE:
					break;
				default: return false;
			}
			break;
		case 0xE000:
			switch(OpCode & 0x00FF)
			{
				case 0x9E:
				case 0xA1:
					break;
				default: return false;
			}
			break;
		case 0xF000:
			switch(OpCode & 0x00FF)
			{
				case 0x07:
				case 0x0A:
				case 0x15:
				case 0x18:
				case 0x1E:
				case 0x29:
				case 0x30:
				case 0x33:
				case 0x55:
				case 0x65:
				case 0x75:
				case 0x85:
					break;
				default: return false;
			}
			break;
		case 0x1000:
		case 0x2000:
		case 0x3000:
		case 0x4000:
		case 0x5000:
		case 0x6000:
		case 0x7000:
		case 0x9000:
		case 0xA000:
		case 0xB000:
		case 0xC000:
		case 0xD000:
			break;
		default: return false;
	}
	return true;
}

char* TranslateOp(WORD OpCode)
{
	char* buffer = new char[100];
	vector<uint> routines;
	uint cur_routine = 0;
	switch(OpCode & 0xF000)
	{
		case 0x0000:
			switch(OpCode & 0x00F0)
			{
				case 0x0:
					wsprintf(buffer,"<NULL DATA>");
					break;
				case 0xC0:
					wsprintf(buffer,"Scroll down %i lines",OpCode&0x000F);
					break;
				case 0xE0:
					switch(OpCode & 0x000F)
					{
						case 0x0:
							wsprintf(buffer,"Clear screen");
							break;
						case 0xE:
							wsprintf(buffer,"Return from subroutine");
							break;
					}
					break;
				case 0xF0:
					switch(OpCode & 0x000F)
					{
						case 0xB:
							wsprintf(buffer,"Scroll right %i lines",bExtendedScreen?4:2);
							break;
						case 0xC:
							wsprintf(buffer,"Scroll left %i lines",bExtendedScreen?4:2);
							break;
						case 0xD:
							wsprintf(buffer,"Terminate system");
							break;
						case 0xE:
							wsprintf(buffer,"Disable extended screen");
							break;
						case 0xF:
							wsprintf(buffer,"Enable extended screen");
							break;
					}
					break;
			}
			break;
		case 0x8000:
			switch(OpCode & 0x000F)
			{
				case 0x0:
					wsprintf(buffer,"Move register %X to register %X",
						(OpCode&0x00F0)>>4,(OpCode&0x0F00)>>8);
					break;
				case 0x1:
					wsprintf(buffer,"Binary OR register %X with register %X",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
					break;
				case 0x2:
					wsprintf(buffer,"Binary AND register %X with register %X",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
					break;
				case 0x3:
					wsprintf(buffer,"Binary XOR register %X with register %X",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
					break;
				case 0x4:
					wsprintf(buffer,"Add register %X with register %X (w/carry)",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
					break;
				case 0x5:
					wsprintf(buffer,"Subtract register %X with register %X (w/carry)",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
					break;
				case 0x6:
					wsprintf(buffer,"Shift register %X 1 bit right",
						(OpCode&0x0F00)>>8);
					break;
				case 0x7:
					wsprintf(buffer,"Subtract reg %X with reg %X, store in reg %X",
						(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4,(OpCode&0x0F00)>>8);
					break;
				case 0xE:
					wsprintf(buffer,"Shift register %X 1 bit left",
						(OpCode&0x0F00)>>8);
					break;
			}
			break;
		case 0xE000:
			switch(OpCode & 0x00FF)
			{
				case 0x9E:
					wsprintf(buffer,"Skip if key in register %X is pressed",
						(OpCode&0x0F00)>>8);
					break;
				case 0xA1:
					wsprintf(buffer,"Skip if key in register %X is not pressed",
						(OpCode&0x0F00)>>8);
					break;
			}
			break;
		case 0xF000:
			switch(OpCode & 0x00FF)
			{
				case 0x07:
					wsprintf(buffer,"Put delay timer in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x0A:
					wsprintf(buffer,"Wait for keypress. Put key in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x15:
					wsprintf(buffer,"Set delay timer to data in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x18:
					wsprintf(buffer,"Set sound timer to data in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x1E:
					wsprintf(buffer,"Add register %X to I",
						(OpCode&0x0F00)>>8);
					break;
				case 0x29:
					wsprintf(buffer,"Point I to chip8 font letter in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x30:
					wsprintf(buffer,"Point I to super chip8 font letter in register %X",
						(OpCode&0x0F00)>>8);
					break;
				case 0x33:
					wsprintf(buffer,"Store BCD of register %X at I",
						(OpCode&0x0F00)>>8);
					break;
				case 0x55:
					wsprintf(buffer,"Store %i registers at I",
						((OpCode&0x0F00)>>8)+1);
					break;
				case 0x65:
					wsprintf(buffer,"Load %i registers at I",
						((OpCode&0x0F00)>>8)+1);
					break;
				case 0x75:
					wsprintf(buffer,"Store %i registers in HP48 flags",
						(OpCode&0x0F00)>>8);
					break;
				case 0x85:
					wsprintf(buffer,"Load %i registers in HP48 flags",
						(OpCode&0x0F00)>>8);
					break;
			}
			break;
		case 0x1000:
			wsprintf(buffer,"Jump to 0x%X",OpCode&0x0FFF);
			break;
		case 0x2000:
			wsprintf(buffer,"Jump to subroutine at 0x%X",OpCode&0x0FFF);
			break;
		case 0x3000:
			wsprintf(buffer,"Skip if register %X == 0x%X",
				(OpCode&0x0F00)>>8,OpCode&0x00FF);
			break;
		case 0x4000:
			wsprintf(buffer,"Skip if register %X <> 0x%X",
				(OpCode&0x0F00)>>8,OpCode&0x00FF);
			break;
		case 0x5000:
			wsprintf(buffer,"Skip if register %X == register %X",
				(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
			break;
		case 0x6000:
			wsprintf(buffer,"Move 0x%X to register %X",
				OpCode&0x00FF,(OpCode&0x0F00)>>8);
			break;
		case 0x7000:
			wsprintf(buffer,"Add 0x%X to register %X",
				OpCode&0x00FF,(OpCode&0x0F00)>>8);
			break;
		case 0x9000:
			wsprintf(buffer,"Skip if register %X != register %X",
				(OpCode&0x0F00)>>8,(OpCode&0x00F0)>>4);
			break;
		case 0xA000:
			wsprintf(buffer,"Load I with 0x%X",OpCode&0x0FFF);
			break;
		case 0xB000:
			wsprintf(buffer,"Jump to 0x%X + register 0",OpCode&0x0FFF);
			break;
		case 0xC000:
			wsprintf(buffer,"Randomize number <= 0x%X, put in register %X",
				OpCode&0x00FF,(OpCode&0x0F00)>>8);
			break;
		case 0xD000:
			int height, width;
			int x, y;
			if ( (OpCode & 0x000F) == 0x0)
			{
				height = 16;
				width = 16;
			}
			else
			{
				height = OpCode & 0x000F;
				width = 8;
			}

			x = (OpCode & 0x0F00) >> 8;
			y = (OpCode & 0x00F0) >> 4;

			wsprintf(buffer,"Draw a %ix%i sprite at registers %X and %X",
				height,width,x,y);
			break;

		default: wsprintf(buffer,"Game data? (0x%0.4X)",OpCode); break;
	}
	return buffer;
}

void SaveState(char* strFileName)
{
	FILE* fState = fopen(strFileName,"wb");
	fwrite(&HP48Pointer,sizeof(uint),1,fState);
	fwrite(&iRoutinesJumped,sizeof(uint),1,fState);
	fwrite(&I,sizeof(uint),1,fState);
	fwrite(&V,16,1,fState);
	fwrite(&memory,0xFFF,1,fState);
	fwrite(&screen,128*64,1,fState);
	fwrite(&PC,sizeof(uint),1,fState);
	fwrite(&DT,sizeof(uint),1,fState);
	fwrite(&ST,sizeof(uint),1,fState);
	fwrite(&bExtendedScreen,1,1,fState);
	fwrite(&stack,sizeof(uint)*16,1,fState);
	fclose(fState);
}

void LoadState(char* strFileName)
{
	FILE* fState = fopen(strFileName,"rb");
	fread(&HP48Pointer,sizeof(uint),1,fState);
	fread(&iRoutinesJumped,sizeof(uint),1,fState);
	fread(&I,sizeof(uint),1,fState);
	fread(&V,16,1,fState);
	fread(&memory,0xFFF,1,fState);
	fread(&screen,128*64,1,fState);
	fread(&PC,sizeof(uint),1,fState);
	fread(&DT,sizeof(uint),1,fState);
	fread(&ST,sizeof(uint),1,fState);
	fread(&bExtendedScreen,1,1,fState);
	fread(&stack,sizeof(uint)*16,1,fState);
	fclose(fState);
	UpdateInfo();
	FillDebugData(hDebugWin);
	RenderScreen();
}

DWORD WINAPI RunToOpThread(LPVOID lParam)
{
	uint TargetPC = (uint)(__int64)lParam;
	while (PC != TargetPC) { EmulationThread(NULL); if (bFound) break; }
	if (PC == TargetPC) bFound = true; else bFound = false;
	return 0;
}

void PressKey(HWND hDlg)
{
	char buf[100];
	GET_TEXT( GetDlgItem(hDlg,IDC_DATA), buf, 100 );
	if (strlen(buf) > 1)
	{
		MessageBox(hDlg,"Enter a valid key to press! Ranges from 0 to F.",emu_title,MB_ICONERROR);
		return;
	}
	switch(buf[0])
	{
		case 'F': keys[0xF] = true; break;
		case 'E': keys[0xE] = true; break;
		case 'D': keys[0xD] = true; break;
		case 'C': keys[0xC] = true; break;
		case 'B': keys[0xB] = true; break;
		case 'A': keys[0xA] = true; break;
		default: keys[ atoi(buf) ] = true; break;
	}
}

void CreateBreakPoint(HWND hDlg, uint TargetPC)
{
	char buf[100];
	GET_TEXT( GetDlgItem(hDlg,IDC_DATA), buf, 100 );
	BreakTimes = atoi(buf);
	BreakPC = TargetPC;
}

DWORD WINAPI GotoBreakPoint(LPVOID lParam)
{
	for(;;)
	{
		EmulationThread(NULL);
		if (PC == BreakPC)
		{
			if (BreakHit == BreakTimes) break;
			else 
			{
				BreakHit++;
				char buf[100];
				_itoa(BreakTimes-BreakHit,buf,10);
				strcat(buf," times left...");
				SendMessage( GetDlgItem(hDebugWin,IDC_DATA), WM_SETTEXT, 0, (LPARAM)buf);
			}
		}
	}
	BreakHit = 0;
	FillDebugData(hDebugWin);
	return 0;
}

void StepOut()
{
	uint StackLevel = 1;
	while (StackLevel > 0)
	{
		EmulationThread(NULL);
		switch(opcode & 0xF000)
		{
			case 0x2000:
				StackLevel++;
				break;
			case 0x0000:
				if ( (opcode & 0x00FF) == 0x00EE ) StackLevel--; 
				break;
		}
	}
}

DWORD WINAPI InputThread(LPVOID lParam)
{
	__UserInput input;
	bool bShiftDown = false;
	bool bStepInDown = false;
	bool bStepOverDown = false;
	for(;;)
	{
		if (bTerminate) break;
		DI_GetBufferedData(&input,NULL,false);
		if (input.bStepOut & 0x80) 
			bShiftDown = true;
		if (input.bStepOut & 0x40) 
			bShiftDown = false;
		if (bShiftDown && input.bStepIn & 0x80) 
		{
			SetRegisters();
			StepOut();
			FillDebugData(hDebugWin);
			continue;
		}
		if (input.bStepIn & 0x80) 
		{
			SetRegisters();
			EmulationThread(NULL);
			FillDebugData(hDebugWin);
			continue;
		}
		if (input.bStepOver & 0x80)
		{
			SetRegisters();
			CreateBreakPoint(hDebugWin,PC+2);
			GotoBreakPoint(NULL);
			FillDebugData(hDebugWin);
			continue;
		}
	}
	return 0;
}

void SetRegisters()
{
	char buffer[100];
	GetDlgItemText(hDebugWin,IDC_V0,buffer,100);
	V[0x0] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V1,buffer,100);
	V[0x1] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V2,buffer,100);
	V[0x2] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V3,buffer,100);
	V[0x3] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V4,buffer,100);
	V[0x4] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V5,buffer,100);
	V[0x5] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V6,buffer,100);
	V[0x6] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V7,buffer,100);
	V[0x7] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V8,buffer,100);
	V[0x8] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V9,buffer,100);
	V[0x9] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V10,buffer,100);
	V[0xA] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V11,buffer,100);
	V[0xB] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V12,buffer,100);
	V[0xC] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V13,buffer,100);
	V[0xD] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V14,buffer,100);
	V[0xE] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_V15,buffer,100);
	V[0xF] = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_PC,buffer,100);
	PC = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_I,buffer,100);
	I = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_DELAYTIMER,buffer,100);
	DT = HexToDec(buffer);
	GetDlgItemText(hDebugWin,IDC_SOUNDTIMER,buffer,100);
	ST = HexToDec(buffer);
}

int HexToDec(char* hex)
{
	int length = (int)strlen(hex);
	int temp, decimal = 0, index = 0;
	char number, temp_num[2];
	for (int i=length-1; i>=0; i--)
	{
		number = hex[i];
		switch(number)
		{
			case 'F':
			case 'f':
				temp = 15;
				break;
			case 'E':
			case 'e':
				temp = 14;
				break;
			case 'D':
			case 'd':
				temp = 13;
				break;
			case 'C':
			case 'c':
				temp = 12;
				break;
			case 'B':
			case 'b':
				temp = 11;
				break;
			case 'A':
			case 'a':
				temp = 10;
				break;
			default:
				temp_num[0] = number;
				temp_num[1] = '\0';
				temp = atoi(temp_num);
		}
		decimal |= ( temp << (4*index) );
		index++;
	}
	return decimal;
}