#include <xtl.h>
#include "Options.h"
//#include "stdafx.h"
//#include <commctrl.h>

#define uint unsigned int
extern HWND hWnd;
extern uint nRegDelay;
extern DWORD dwPixelColor;

#if 0
void ShowOptionsDlg()
{
	int nRet = (int)DialogBox( GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_OPTIONS),
		hWnd, OptionsProc);
}

#define ToColorDlgRGB(rgb) \
( \
	(rgb & 0x00FF0000) >> 16 | \
	(rgb & 0x0000FF00) >> 8 | \
	(rgb & 0x000000FF) \
)

#define ToD3DRGB(rgb) \
( \
   GetRValue(rgb) << 16 | \
   GetGValue(rgb) << 8 |  \
   GetBValue(rgb) \
)

INT_PTR CALLBACK OptionsProc(
  HWND hwndDlg,  // handle to dialog box
  UINT uMsg,     // message
  WPARAM wParam, // first message parameter
  LPARAM lParam  // second message parameter
)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		int nParentWidth, nParentHeight, nWidth, nHeight;
		RECT rParent, rClient;
		HWND hRegDisplay;

		GetClientRect( GetParent(hwndDlg), &rParent );
		GetClientRect(hwndDlg, &rClient);
		nParentWidth = rParent.right;
		nParentHeight = rParent.bottom;
		nWidth = rClient.right;
		nHeight = rClient.bottom;
		SetWindowPos(hwndDlg,NULL, (nParentWidth / 2) - (nWidth / 2),
			(nParentHeight / 2) - (nHeight / 2), 0,0,SWP_NOSIZE);

		char temp[10];
		_itoa(nRegDelay,temp,10);
		hRegDisplay = GetDlgItem(hwndDlg,IDC_REGDELAY);
		SendMessage(hRegDisplay, TBM_SETRANGE, TRUE, MAKELONG(0, 40));
		SendMessage(hRegDisplay, TBM_SETPOS, TRUE, nRegDelay);
		SendMessage( GetDlgItem(hwndDlg,IDC_REGDELAY_NUM), WM_SETTEXT, 0, (LPARAM)temp );
		break;
	case WM_COMMAND:
		switch(wParam)
		{
		case IDC_OK:
			HWND hRegDisplay;
			int reg_delay;
			hRegDisplay = GetDlgItem(hwndDlg,IDC_REGDELAY);
			reg_delay = (int)SendMessage(hRegDisplay, TBM_GETPOS, 0, 0);
			
			HKEY hkey;
			LONG lRet;
			lRet = RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Doom's infested key\\Chuit",KEY_SET_VALUE,0,&hkey);
			if (lRet != ERROR_SUCCESS)
			{
				lRet = RegCreateKey(HKEY_CURRENT_USER,"Software\\Doom's infested key\\Chuit",&hkey);
				if (FAILED(lRet))
				{
					MessageBox(hwndDlg,"Failed to save the options! Make sure you have proper write permissions in the registry!",emu_title,MB_ICONERROR);
					hkey = NULL;
				}
			}
			if (hkey)
			{
				lRet = RegSetValueEx(hkey,"Register delay",0,REG_DWORD,(BYTE*)&reg_delay,sizeof(reg_delay));
				lRet = RegSetValueEx(hkey,"Pixel color",0,REG_DWORD,(BYTE*)&dwPixelColor,sizeof(dwPixelColor));
				if (lRet != ERROR_SUCCESS)
				{
					MessageBox(hwndDlg,"Failed to save the options! Make sure you have proper write permissions in the registry!",emu_title,MB_ICONERROR);
					hkey = NULL;
				}
			}
			RegCloseKey(hkey);
			
			nRegDelay = reg_delay;
			EndDialog(hwndDlg,IDC_OK);
			return TRUE;
		case IDC_CANCEL:
			EndDialog(hwndDlg,IDC_CANCEL);
			return TRUE;
		case IDC_CHANGEPIXCOLOR:
			CHOOSECOLOR cc;
			static COLORREF acrCustClr[16];
			ZeroMemory(&cc,sizeof(cc));
			cc.lStructSize = sizeof(CHOOSECOLOR);
			cc.hwndOwner = hwndDlg;
			cc.lpCustColors = (LPDWORD) acrCustClr;
			cc.rgbResult = ToColorDlgRGB(dwPixelColor);
			cc.Flags = CC_FULLOPEN | CC_RGBINIT;
			if ( ChooseColor(&cc) == TRUE )
			{
				dwPixelColor = 0xFF000000 | ToD3DRGB(cc.rgbResult);
				RECT rClient;
				GetClientRect(hwndDlg,&rClient);
				InvalidateRect(hwndDlg,&rClient,FALSE);
			}
			break;
		}
		break;
	case WM_CLOSE:
		EndDialog(hwndDlg,IDC_CANCEL);
		return TRUE;
	case WM_HSCROLL:
		int nCurPos;
		char msg[100];
		nCurPos = (int)SendMessage( GetDlgItem(hwndDlg,IDC_REGDELAY), TBM_GETPOS, 0, 0 );
		wsprintf(msg,"%i",nCurPos);
		SendMessage( GetDlgItem(hwndDlg,IDC_REGDELAY_NUM), WM_SETTEXT, 0, (LPARAM)msg );
		break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lParam == GetDlgItem(hwndDlg,IDC_CURCOLOR_NUM))
		{
			HBRUSH brush = (HBRUSH)DefWindowProc(hwndDlg,uMsg,wParam,lParam);
			SetTextColor( (HDC)wParam, ToColorDlgRGB(dwPixelColor) );
			return (LRESULT)brush;
		}
		return FALSE;
	}
	return FALSE;
}
#endif
