//#include "stdafx.h"
#include <xtl.h>
#include "Main.h"
#include "Chip8 Headers.h"
#include "Direct3D.h"
#include "Debug.h"
#include "DirectInput.h"
#include "options.h"
//#include <commdlg.h>
//#include <DInputExports.h>
//#include <diutil.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;						// current instance
HWND hWnd;								// window handle
TCHAR szemu_title[MAX_LOADSTRING];			// The emu_title bar text
TCHAR szWindowClass[MAX_LOADSTRING];	// the main window class name

#define LIST_ADDSTRING(hListbox,text) \
	SendMessage(hListbox,LB_ADDSTRING,0,(LPARAM)text);
#define LIST_GETSTRING(hListbox,index,buffer) \
	SendMessage(hListbox,LB_GETTEXT,index,(LPARAM)buffer);
#define LIST_GETCURRENTINDEX(hListbox) \
	SendMessage(hListbox,LB_GETCURSEL,0,0);
#define LIST_GETTEXTLENGTH(hListbox,index) \
	SendMessage(hListbox,LB_GETTEXTLEN,index,0);
#define LIST_FINDSTRING(hListbox,text) \
	SendMessage(hListbox,LB_FINDSTRING,-1,(LPARAM)text);
#define LIST_SETSELECTION(hListbox,index) \
	SendMessage(hListbox,LB_SETCURSEL,index,0);

//extern IDirect3DDevice9* pd3dDevice;
//extern CD3DFont m_pFont[2];
extern bool bRenderingText;
extern bool bExit;
extern bool bRealQuit;
extern bool bRomLoaded;
extern uint DT;
extern uint ST;

int curSelection = 0; 
bool bExitAndEmulate = false;

void LastError()
{
#if 0
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	// Process any inserts in lpMsgBuf.
	// ...
	// Display the string.
	MessageBox( NULL, (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
	// Free the buffer.
	LocalFree( lpMsgBuf );
#endif
}

void LastError(int error)
{
#if 0
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		error,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	// Process any inserts in lpMsgBuf.
	// ...
	// Display the string.
	MessageBox( NULL, (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
	// Free the buffer.
	LocalFree( lpMsgBuf );
#endif
}

extern "C" int xbox_check_events() ;
extern "C" unsigned int xbox_read_port( int which ) ;

char *g_filename ;
bool bEmulate = false;
extern unsigned int nRegDelay ;
int chip8main(char *filename, int fgcolor, int bgcolor, int delay ) 
{
	g_filename = filename ;

	// Perform application initialization:
	if (!InitInstance ()) 
	{
		//RenderText("Failed to create main window!",DT_CRITICAL_ERROR|QUIT_EMULATOR);
		//LastError();
		return FALSE;
	}

	//ShowWindow(hWnd, nCmdShow);
	//UpdateWindow(hWnd);


	if (!InitEmu(filename)) return 0 ;

	if ( ! LoadRom( filename ) )
		return 0 ;

	nRegDelay = delay ;

	if (!bExit)
	{
		//hMsgProc = CreateThread(NULL,NULL,MessageProc,NULL,CREATE_SUSPENDED,NULL);
		//SetThreadPriority(hMsgProc,THREAD_PRIORITY_IDLE);
		//ResumeThread(hMsgProc);
		//ShowWindow(hWnd, nCmdShow);
		//UpdateWindow(hWnd);
		//hAccelTable = LoadAccelerators(GetModuleHandle(NULL), (LPCTSTR)IDC_CHIP8_ACCELERATOR);
	}

	bEmulate = true;
	bExitAndEmulate = true;
	bRealQuit = false ;
	bExit = false ;


	unsigned int portval ;

	while (!bExit)
	{
		if (bEmulate)
		{
			EmulationThread(NULL);
			if (bExit) 
			{
				bEmulate = false;
				//bExit = false;
			}
			if (bRealQuit) bEmulate = false ;
			continue;
		}

		bExit = xbox_check_events()  ;
		portval = xbox_read_port( 0 ) ;

		if ( portval & 0x10000 )
		{
			if (!InitEmu(filename)) return 0 ;

			if ( ! LoadRom( filename ) )
				return 0 ;
			bEmulate = true;
			bExitAndEmulate = true;
			bRealQuit = false ;
		}

		RenderScreen() ;

		//pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		//RenderText("Load rom\nClose rom\nResume emulation\nConfigure keys\nOptions\nQuit",
			//DT_USE_ADVANCED_RENDERING,1);

		//int key = GetKeyboardPress();


#if 0
		switch(key)
		{
			case 0xFF: // Quit
				pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				RenderText("Thanks for using Chuit!\nNow hang on while it terminates...",0,1);
				bExit = true;
				Sleep(2000);
				ShowWindow(hWnd,SW_HIDE);
				break;
			case 18: // Up
				if (curSelection > 0) curSelection--;
				else if (curSelection == 0) curSelection = 5;
				break;
			case 19: // Down
				if (curSelection < 5) curSelection++; 
				else if (curSelection == 5) curSelection = 0;
				break;
			case 20: // Enter
				pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				switch(curSelection)
				{
					case 0: // Load rom
						if (bRomLoaded) CloseRom();
#ifndef _DEBUG
						ShowCursor(TRUE);
#endif
						if(GetOpenFileName(&ofn))
						{
							LoadRom(ofn.lpstrFile);
							szFileName[0] = '\0';
							bEmulate = true;
							bExitAndEmulate = true;
						}
#ifndef _DEBUG
						ShowCursor(FALSE);
#endif
						pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
#ifdef _DEBUG
						ShowDebugDlg();
#endif
						break;
					case 1: // Close rom
						if (!bRomLoaded) { RenderText("No rom loaded!",0,1); Sleep(2000); }
						else 
						{
							CloseRom();
							RenderText("Your wish is my law! Done!",0,1);
							Sleep(2000);
						}
						break;
					case 2: // Resume emulation
						if (!bRomLoaded) { RenderText("No rom loaded!",0,1); Sleep(2000); }
						else 
						{
							RenderText("Okidokie...",0,1);
							Sleep(1000);
							bEmulate = true;
							RenderScreen();
						}
						break;
					case 3: // Configure keys
#ifndef _DEBUG
						ShowCursor(TRUE);
#endif
						RenderText("Wait!",0,1);
						DI_ConfigDevices();
#ifndef _DEBUG
						ShowCursor(FALSE);
#endif
						break;
					case 4: // Options
#ifndef _DEBUG
						ShowCursor(TRUE);
#endif
						RECT rClient;
						GetClientRect(hWnd,&rClient);
						InvalidateRect(hWnd,&rClient,TRUE);
						ShowOptionsDlg();
#ifndef _DEBUG
						ShowCursor(FALSE);
#endif
						break;
					case 5: // Quit
						RenderText("Thanks for using Chuit!\nNow hang on while it terminates...",0,1);
						bExit = true;
						Sleep(2000);
						ShowWindow(hWnd,SW_HIDE);
						break;
				}
				break;
		}
		pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
#endif
	}

	//Sleep( 250 ) ;

	Shutdown();
	return 1;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
#if 0
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= 0;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_BTNFACE+1);
	wcex.lpszMenuName	= 0;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= 0;

	return RegisterClassEx(&wcex);
}
#endif
//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance()
{
#if 0
   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, emu_title, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, 800, 500, NULL, NULL, hInstance, NULL);

   if (!hWnd)
      return FALSE;
#endif
   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
#if 0
#pragma warning (disable: 4065)
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Parse the menu selections:
		switch (wmId)
		{
			default:
				return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		RenderScreen();
		//D3D_RenderScene();
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		bExit = true;
		bRealQuit = true;
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
#endif