//#include "D3DExports.h"
#include "Direct3D.h"
#include "DirectInput.h"

#define uint unsigned int

extern HWND hWnd;
extern bool bExtendedScreen;
extern bool bDebugOutput;
extern bool bExit;
extern byte screen[64*128];
extern uint StopDrawCalltimes;
extern uint PC;
extern uint StopPC;
extern int curSelection;
extern bool bRealQuit;
extern DWORD dwPixelColor;

bool bRenderingText = false;
int XMultiplier, YMultiplier;
float BORDER2_START;
float BORDER1_END;
float BORDER2_START_X;
float BORDER1_END_X;
const uint iNumOfVertices = 50000;
DWORD dwStartColor = 0x00FF00FF;
DWORD dwStartColorB = 0xFF00FF00;
D3DRECT rect;
//CD3DFont* m_pFont[2];
//DrawText_Info info;
//CUSTOMVERTEX vScreen[ 0x2000 * 6 ];

//D3DPRESENT_PARAMETERS DeviceInfo;
//IDirect3D9* pD3D = NULL;
//IDirect3DDevice9* pd3dDevice = NULL;
//IDirect3DVertexBuffer9* pVB = NULL;
//IDirect3DVertexBuffer9* pVB2 = NULL;
//IDirect3DVertexBuffer9* pVB3 = NULL;

#define safe_release(p) if (p) p->Release(); p = NULL;

extern "C" void xbox_put_image( unsigned char *pix, int spitch ) ;

void RenderScreen(int* _pixels,int number)
{
	xbox_put_image( screen, bExtendedScreen ) ;


#if 0
	if (bExit) return;
	//CUSTOMVERTEX vFiller[4];
	//CUSTOMVERTEX vFiller2[4];
	int index = 0;
	HRESULT hr;
	
	// Initialize the vertices that will fill out the borders of the screen
	index = InitScreenVertices(vScreen,_pixels,number);
	//InitFillerVertices(vFiller,vFiller2);

	if (index > 0)
	{
		pd3dDevice->BeginScene();
		pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		hr = pd3dDevice->SetStreamSource(0, pVB, 0, sizeof(CUSTOMVERTEX));
		hr = pd3dDevice->SetFVF(D3DFVF_CUSTOMVERTEX);
		hr = pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLELIST,index/3,vScreen,sizeof(CUSTOMVERTEX));
		pd3dDevice->EndScene();

		pd3dDevice->Present(0,0,0,0);
	}
#endif
}

bool InitD3D()
{
#if 0
	ZeroMemory(&DeviceInfo,sizeof(DeviceInfo));
#ifdef _WINDOWED
	DeviceInfo.Windowed = true;
#else
	DeviceInfo.Windowed = false;
#endif
	DeviceInfo.Flags = D3DCREATE_MULTITHREADED;
	DeviceInfo.BackBufferFormat = D3DFMT_X8R8G8B8;
	DeviceInfo.SwapEffect = D3DSWAPEFFECT_DISCARD;
	DeviceInfo.BackBufferWidth = 1024;
	DeviceInfo.BackBufferHeight = 768;

	HRESULT hr;
	pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if(pD3D == NULL)
	{
		MessageBox(hWnd,"Failed to initialize Direct3D!\nAre you sure you're using at least version 9.0?",emu_title,MB_ICONERROR);
		return false;
	}

	D3DCAPS9 card_info;
	hr = pD3D->GetDeviceCaps(0,D3DDEVTYPE_HAL,&card_info);
	if (hr == D3DERR_INVALIDDEVICE)
	{
		MessageBox(hWnd,"Fatal error: gfx card does not support hardware acceleration!\nPlease upgrade your card before trying to run this application again.",emu_title,MB_ICONERROR);
		return false;
	}

	int CreateFlag[4] = { D3DCREATE_HARDWARE_VERTEXPROCESSING|D3DCREATE_PUREDEVICE,
						  D3DCREATE_HARDWARE_VERTEXPROCESSING,
						  D3DCREATE_MIXED_VERTEXPROCESSING,
						  D3DCREATE_SOFTWARE_VERTEXPROCESSING };
	for (int i=0; i<4; i++)
	{
		hr = pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL,
								hWnd, 
								DeviceInfo.Flags|CreateFlag[i], 
								&DeviceInfo, &pd3dDevice);
		if (FAILED(hr) && i==3)
		{
			DXTRACE_ERR_MSGBOX("D3D Device creation failed!",hr);
			return false;
		} else if (hr == S_OK) break;
	}

	D3DFont_SetDevice(pd3dDevice);
	for (int i=0; i<2; i++)
	{
		m_pFont[i] = D3DFont_InitFont("Monotype Corsiva",(i == 0 ? 23 : 46), D3DFONT_BOLD);
		if (m_pFont[i] == NULL)
		{
			char msg[100];
			wsprintf(msg,"Error when creating d3d font!\nReturned error: %s.", DXGetErrorString9( GetLastError() ) );
			MessageBox(hWnd,msg,emu_title,MB_ICONERROR);
			return false;
		}
	}

	hr = pd3dDevice->SetFVF(D3DFVF_CUSTOMVERTEX);
	hr = pd3dDevice->SetDialogBoxMode(true);
#endif
	UpdateInfo();
	return true;
}
inline void InitFillerVertices(CUSTOMVERTEX* pFiller,CUSTOMVERTEX* pFiller2)
{
#if 0
	const float width = (float)DeviceInfo.BackBufferWidth;
	const float height = (float)DeviceInfo.BackBufferHeight;
	pFiller[0].x = 0;
	pFiller[0].y = 0;
	pFiller[1].x = width;
	pFiller[1].y = 0;
	pFiller[2].x = 0;
	pFiller[2].y = BORDER1_END;
	pFiller[3].x = width;
	pFiller[3].y = BORDER1_END;

	pFiller2[0].x = 0;
	pFiller2[0].y = BORDER2_START;
	pFiller2[1].x = width;
	pFiller2[1].y = BORDER2_START;
	pFiller2[2].x = 0;
	pFiller2[2].y = height;
	pFiller2[3].x = width;
	pFiller2[3].y = height;
	
	//filler2[0].color = 0xFF000000;
	//filler2[1].color = 0x00FF0000;
	//filler2[2].color = 0x0000FF00;
	//filler2[3].color = 0x000000FF;
	//filler[0].color = (dwStartColor & 0xFF) << 24;
	//filler[1].color = (dwStartColor & 0xFF00) << 16;
	//filler[2].color = (dwStartColor & 0xFF0000) << 8;
	//filler[3].color = (dwStartColor & 0xFF000000);
	//filler2[0].color = (dwStartColorB & 0xFF) << 24;
	//filler2[1].color = (dwStartColorB & 0xFF00) << 16;
	//filler2[2].color = (dwStartColorB & 0xFF0000) << 8;
	//filler2[3].color = (dwStartColorB & 0xFF000000);

	//DWORD bit;
	//int pos = 0;
	////DWORD temp;
	//static bool bInvert = true;
	/*bit = dwStartColor & 0x1;
	dwStartColor >>= 1;
	dwStartColor |= (bit << 31);*/
	
//#define Inc(_pos,number) pos = 0xFF * _pos + 0xFF; bit = number & pos; bit++; number = bit;
//#define Dec(_pos,number) pos = 0xFF * _pos + 0xFF; bit = number & pos; bit--; number = bit;
//	if (bInvert)
//	{
//		#define _pos 0
//		int number = 0x00FF00FF;
//		pos = 0xFF * _pos + 0xFF;
//		bit = number & pos;
//		bit--; 
//		pos = _pos * 4;
//		number |= (bit << pos);
//		Dec(0,dwStartColor);
//		/*dStartColor[1]++;
//		dStartColor[2]--;
//		dStartColor[3]++;
//		dStartColorB[0]++;
//		dStartColorB[1]--;
//		dStartColorB[2]++;
//		dStartColorB[3]--;
//		if (dStartColor[0] == 0) bInvert = false;*/
//	} else {
//		/*dStartColor[0]++;
//		dStartColor[1]--;
//		dStartColor[2]++;
//		dStartColor[3]--;
//		dStartColorB[0]--;
//		dStartColorB[1]++;
//		dStartColorB[2]--;
//		dStartColorB[3]++;
//		if (dStartColor[1] == 0) bInvert = true;*/
//	}
	//for (int i=0; i<4; i++)
	//{
	//	dStartColor[0] = ( ( (dStartColor[0] >> 20) + 1) << 20);
	//	dStartColor[i]++;
	//	dStartColorB[i]++;
	//}

	for (int i=0; i<4; i++)
	{
		pFiller[i].rhw = 1.0;
		pFiller[i].z = 0.5;
		pFiller[i].color = 0x00000000;
		pFiller2[i].rhw = 1.0;
		pFiller2[i].z = 0.5;
		pFiller2[i].color = 0x00000000;
	}
	/**pFiller = filler;
	*pFiller2 = filler2;*/
#endif
}

inline int InitScreenVertices(CUSTOMVERTEX* pVertices,int* pixels,int number)
{
	int offsetx = 0;
	int index = 0;
	int xvalue = bExtendedScreen ? 128 : 64;
	int yvalue = bExtendedScreen ? 64 : 32;
#if 0
	//CUSTOMVERTEX* vertices = new CUSTOMVERTEX[ xvalue * yvalue * 3 ];
	for (int y=0; y < yvalue; y++)
	{
		for (int x=0; x < xvalue; x++)
		{
			if (screen[x+y*xvalue] != 1) continue;
#if 0
			if (bMonitorDrawOpcode)
			{
				char msg[100];
				wsprintf(msg,"Pixel found at x: %i, y: %i.\n",x,y);
				DEBUGTRACE(msg);
			}
#endif

#pragma warning(disable: 4244)
			pVertices[index].x = x*XMultiplier;
			pVertices[index].y = BORDER1_END + (y*YMultiplier);
			pVertices[index+1].x = x*XMultiplier+XMultiplier;
			pVertices[index+1].y = BORDER1_END + (y*YMultiplier);
			pVertices[index+2].x = x*XMultiplier;
			pVertices[index+2].y = BORDER1_END + (y*YMultiplier+YMultiplier);

			pVertices[index+3].x = x*XMultiplier+XMultiplier;
			pVertices[index+3].y = BORDER1_END + (y*YMultiplier);
			pVertices[index+4].x = x*XMultiplier+XMultiplier;
			pVertices[index+4].y = BORDER1_END + (y*YMultiplier+YMultiplier);
			pVertices[index+5].x = x*XMultiplier;
			pVertices[index+5].y = BORDER1_END + (y*YMultiplier+YMultiplier);
#pragma warning(default: 4244)

			for (int i=0; i<6; i++)
			{
				pVertices[index+i].z = 1.0;
				pVertices[index+i].rhw = 1.0;
				pVertices[index+i].color = dwPixelColor;
			}		
			index += 6;
		}
	}
	//*pVertices = vertices;
	return index;
#endif
	return 0 ;
}

void UpdateInfo()
{
#if 0
	int xvalue = bExtendedScreen ? 128 : 64;
	XMultiplier = DeviceInfo.BackBufferWidth / xvalue;
	YMultiplier = XMultiplier;

	const float width = (float)DeviceInfo.BackBufferWidth;
	const float height = (float)DeviceInfo.BackBufferHeight;
	if (!bExtendedScreen)
	{
		BORDER1_END = (float)(height - (YMultiplier * 32)) / 2;
		BORDER2_START = (float)(BORDER1_END + YMultiplier * 32 );
	} else {
		BORDER1_END = (float)(height - (YMultiplier * 64)) / 2;
		BORDER2_START = (float)(BORDER1_END + YMultiplier * 64 );
	}

	rect.x1 = 0;
	rect.x2 = (long)width;
	rect.y1 = (long)BORDER1_END;
	rect.y2 = (long)BORDER2_START;
#endif
}

#pragma optimize("g",off)
void RenderText(char* text,byte flags,int fontindex,DWORD dwColor)
{
#if 0
	char msg[1000];
	strcpy(msg,text);
	if (flags & QUIT_EMULATOR)
	{
		strcat(msg,"\nPress any key to exit the emulator.");
		bRenderingText = true;
	}
	ZeroMemory(&info,sizeof(info));
	if (flags & USE_COLOR)
		info.dwColor = dwColor;
	else
		info.dwColor = 0xFFFF0000;
	info.flags = DT_CENTERTEXT|flags;
	info.font = m_pFont[fontindex];
	info.pCallback = DrawTextCallbackAdvanced;
	info.strText = msg;
	
	if (flags & QUIT_EMULATOR)
	{
		HANDLE hThread = CreateThread(NULL,NULL,DrawTextCallback,NULL,CREATE_SUSPENDED,NULL);
		SetThreadPriority(hThread,THREAD_PRIORITY_IDLE);
		ResumeThread(hThread);
		//WaitForSingleObject(hThread,INFINITE);
	} else {
		pd3dDevice->BeginScene();
		D3DFont_DrawText(&info);
		pd3dDevice->EndScene();
		if (pd3dDevice->Present(0,0,0,0) == D3DERR_DEVICELOST)
		{
			for (int i=0; i<2; i++) D3DFont_Invalidate(m_pFont[i]);
			safe_release(pVB);
			while ( pd3dDevice->Reset(&DeviceInfo) == D3DERR_DEVICELOST );
			for (int i=0; i<2; i++) D3DFont_Restore(m_pFont[i]);
		}
	}
#endif
}
//#pragma optimize("",on)

void DestroyD3D()
{
#if 0
	safe_release(pVB);
	safe_release(pd3dDevice);
	safe_release(pD3D);
	for (int i=0; i<2; i++) D3DFont_Delete(m_pFont[i]);
#endif
}

DWORD WINAPI DrawTextCallback(LPVOID lParam)
{
#if 0
	ClearKeys();
	try 
	{
		while (GetKeyboardPress() == -1) 
		{ 
			pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			pd3dDevice->BeginScene();
			D3DFont_DrawText(&info);
			pd3dDevice->EndScene();
			if (pd3dDevice->Present(0,0,0,0) == D3DERR_DEVICELOST)
			{
				for (int i=0; i<2; i++) D3DFont_Invalidate(m_pFont[i]);
				safe_release(pVB);
				pd3dDevice->Reset(&DeviceInfo);
				for (int i=0; i<2; i++) D3DFont_Restore(m_pFont[i]);
			}
			Sleep(0);
		}
	}
	catch(...) { }
	bExit = true;
	bRealQuit = true;
#endif
	return 0;
}

void DrawTextCallbackAdvanced(DWORD& dwColor, int index)
{
	if (index == 1 && curSelection == 0)
		dwColor = 0xFF00FF00;
	if (index == 2 && curSelection == 1) 
		dwColor = 0xFF00FF00;
	if (index == 3 && curSelection == 2) 
		dwColor = 0xFF00FF00;
	if (index == 4 && curSelection == 3)
		dwColor = 0xFF00FF00;
	if (index == 5 && curSelection == 4)
		dwColor = 0xFF00FF00;
	if (index == 6 && curSelection == 5)
		dwColor = 0xFF00FF00;
}

//bool CreateVertex()
//{
//	HRESULT hr;
//	hr = pd3dDevice->CreateVertexBuffer( (0x2000+1)*sizeof(CUSTOMVERTEX),
//		D3DUSAGE_DYNAMIC|D3DUSAGE_DONOTCLIP|D3DUSAGE_WRITEONLY, D3DFVF_CUSTOMVERTEX, 
//		D3DPOOL_DEFAULT, &pVB, NULL );
//	if (FAILED(hr))
//	{
//		DXTRACE_ERR_MSGBOX("Vertex buffer creation failed!",hr);
//		return false;
//	}
//	return true;
//}