/*****************************************************************************
** File:
**      ay8910.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of the AY8910 sound chip.
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef AY8910_H
#define AY8910_H

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct AY8910 AY8910;

/* Constructor and destructor */
AY8910* ay8910Create(Mixer* mixer, UInt32 cpuClock);
void ay8910Destroy(AY8910* ay8910);

/* Register read/write methods */
void ay8910WriteAddress(AY8910* ay8910, UInt16 ioPort, UInt8 address, UInt32 cpuClock);
UInt8 ay8910ReadData(AY8910* ay8910, UInt16 ioPort, UInt32 cpuClock);
void ay8910WriteData(AY8910* ay8910, UInt16 ioPort, UInt8 data, UInt32 cpuClock);

typedef UInt8 (*AY8910ReadCb)(void*, UInt16, UInt32);
typedef void (*AY8910WriteCb)(void*, UInt16, UInt8, UInt32);

void ay8910SetIoPort(AY8910* ay8910, AY8910ReadCb readCb, AY8910WriteCb writeCb, void* arg);

int ay8910GetState(AY8910* ay8910, UInt8* buffer, UInt32 systemTime);
int ay8910SetState(AY8910* ay8910, UInt8* buffer, UInt32 systemTime);

#endif

