/*****************************************************************************
** File:
**      RTC.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of the Real Time Clock
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef RTC_H
#define RTC_H

#include "msxTypes.h"

/* Type definitions */
typedef struct RTC RTC;

/* Constructor and destructor */
RTC* rtcCreate(char* cmosName);
void rtcDestroy(RTC* rtc);

/* Register read/write methods */
void rtcWriteAddress(RTC* rtc, UInt16 ioPort, UInt8 value, UInt32 systemTime);
UInt8 rtcReadData(RTC* rtc, UInt16 ioPort, UInt32 systemTime);
void rtcWriteData(RTC* rtc, UInt16 ioPort, UInt8 value, UInt32 systemTime);

int rtcGetState(RTC* rtc, UInt8* buffer, UInt32 systemTime);
int rtcSetState(RTC* rtc, UInt8* buffer, UInt32 systemTime);

#endif

