/*****************************************************************************
** File:
**      MSX.h
**
** Author:
**      Daniel Vik
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef MSX_H
#define MSX_H
 
#include "MSXTypes.h"
#include "RomMapper.h"
#include "Machine.h"
#include "VDP.h"
#include "audioMixer.h"
#include <stdio.h>

extern unsigned int g_Frequency ;
extern unsigned int g_Base ;

//#define GLOBAL_FREQ  3579545
//#define GLOBAL_BASE  0x28959becUL  
#define GLOBAL_FREQ   3579545
#define GLOBAL_BASE   0x28959becUL
//#define GLOBAL_FREQ  ((VPeriod == CPU_VPERIOD_PAL) ? 3568884 : 3570259 )
//#define GLOBAL_BASE  ((VPeriod == CPU_VPERIOD_PAL) ? 0x2876AA63UL  : 0x287AA811UL  )

//#define CPU_CLOCK    GLOBAL_FREQ //3570259 //3568884 //3579545       /* CPU clock frequency, Hz  */

typedef struct {
    struct {
        int     inserted;
        RomType type;
        char    name[512];
        char    inZipName[512];
    } cartridge[2];
    struct {
        int  inserted;
        char name[512];
        char inZipName[512];
    } diskette[2];
    struct {
        int  inserted;
        char name[512];
        char inZipName[512];
    } cassette;
    struct {
        int enableYM2413;
        int enableY8950;
        int enableMoonsound;
        int moonsoundSRAM;
    } audio;
} DeviceInfo;


int msxRun(Machine* machine, 
           DeviceInfo* deviceInfo,
           Mixer* mixer,
           char* stateFile,
           int syncPeriod,
           int frequency,
           int clearRam);

int msxSaveState(const char* stateFile);
int msxLoadState(const char* stateFile);

void msxSetFrequency(int syncPeriod, int frequency);

void msxSetFrontSwitch(int state);
void msxSetAudioSwitch(int state);

UInt8* msxGetRamPage(int page);

void msxChangeCartridge();
void msxChangeDiskette(int driveId, char* fileName, const char* fileInZipFile);
void msxChangeCassette(char* name, const char* fileInZipFile);


#endif /* MSX_H */

