/*****************************************************************************
** File:        Win32Help.c
**
** Author:      Daniel Vik
**
** Description: Methods to show help dialogs.
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "Win32Help.h"
#include "Language.h"
#include "build_number.h"
#include "Resource.h"
#include <stdio.h>
 
#define BLUE_MSX_VERSION "1.5.0"

extern void centerDialog(HWND hDlg);

static BOOL CALLBACK aboutDlgProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam) 
{
    switch (iMsg) {
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK) {
            EndDialog(hDlg, TRUE);
            return TRUE;
        }
        break;

    case WM_CLOSE:
        EndDialog(hDlg, TRUE);
        return TRUE;

    case WM_INITDIALOG:
        {
            _TCHAR aboutText[1024];
                _stprintf(aboutText, "%s\r\n\r\n"
                                     "%s%\t%s\r\n"
                                     "%s%\t%d\r\n"
                                     "%s%\t%s\r\n\r\n"
                                     "%s\r\n\r\n\r\n"
                                     "%s\r\n\r\n"
                              
                                     "Daniel Vik\r\n"
                                     "Benot Delvaux\r\n\r\n\r\n"
   
                                     "%s\r\n\r\n"

                                     "Shimanuki Koshi\r\n"
                                     "Roger Filipe\r\n"
                                     "Kobayashi Michiko\r\n"
                                     "SLotman\r\n"
                                     "Laurent Halter\r\n"
                                     "Fabio Albergaria Dias\r\n"
                                     "Glafouk\r\n"
                                     "Martijn van Tienen\r\n"
                                     "Vctor Fernndez Snchez\r\n"
                                     "William Ouwehand\r\n"
                                     "Miikka \"MP83\" Poikela\r\n"
                                     "Davide Platania a.k.a. Kruznak\r\n"
                                     "Wouter Vermaelen\r\n"
                                     "Manuel Bilderbeek\r\n"
                                     "Maarten ter Huurne\r\n"
                                     "Tobias Keizer\r\n"
                                     "Atarulum\r\n"
                                     "Sandy\r\n"
                                     "Alex Wulms\r\n"
                                     "Marat Fayzullin\r\n"
                                     "Jarek Burczynski\r\n"
                                     "R. Belmont\r\n"
                                     "O. Galibert\r\n"
                                     "Tatsuyuki Satoh\r\n"
                                     "Gilles Vollant\r\n\r\n\r\n"
            
                                     "%s",
                          langDlgAboutAbout(),
                          langDlgAboutVersion(),
                          BLUE_MSX_VERSION,
                          langDlgAboutBuildNumber(),
                          BUILD_NUMBER,
                          langDlgAboutBuildDate(),
                          BUILD_DATE,
                          langDlgAboutCreat(),
                          langDlgAboutDevel(),
                          langDlgAboutThanks(),
                          langDlgAboutLisence());

            centerDialog(hDlg);
            SetWindowText(hDlg, langDlgAboutTitle());
            SetWindowText(GetDlgItem(hDlg, IDOK), langDlgOK());

            SendMessage(GetDlgItem(hDlg, IDC_ABOUTTEXT), WM_SETTEXT, 0, (LPARAM)aboutText);
        }
        return FALSE;
    }

    return FALSE;
}

void helpShowAbout(HWND hwnd) {
    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ABOUT), hwnd, aboutDlgProc);
}

