/*****************************************************************************
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_FINNISH_H
#define LANGUAGE_FINNISH_H

#include "LanguageStrings.h"
 
void langInitFinnish(LanguageStrings* ls) 
{
    ls->statusBarStopped        = "  Pysytetty";
    ls->statusBarPaused         = "  Keskeytetty";
    ls->statusBarRunning        = "  Kynniss";
    
    ls->menuHardReset           = "Hardware resetointi";
    ls->menuSoftReset           = "Software resetointi";
    
    ls->menuCartInsert          = "Lis...";
    ls->menuCartRemove          = "Poista";
    ls->menuCartAutoReset       = "Resetoi lismisen/poistamisen jlkeen";
    ls->menuCartNoRecentFiles   = "- ei viimeaikaisia tiedostoja -";
    ls->menuCartFMPac           = "FM-PAC Cartridge";
    ls->menuCartPac             = "PAC Cartridge";
    ls->menuCartSpecial         = "Special";

    ls->menuDiskInsert          = "Lis...";
    ls->menuDiskEject           = "Poista";
    ls->menuDiskAutoStart       = "Resetoi lismisen jlkeen";
    ls->menuDiskNoRecentFiles   = "- ei viimeaikaisia tiedostoja -";
    
    ls->menuCasInsert           = "Lis...";
    ls->menuCasEject            = "Poista";
    ls->menuCasSetPosition      = "Aseta sijainti";
    ls->menuCasRewind           = "Kelaa taaksenpin";
    ls->menuCasNoRecentFiles    = "- ei viimeaikaisia tiedostoja -";

    ls->menuZoomNormal          = "Normaali koko";
    ls->menuZoomDouble          = "Tupla koko";
    ls->menuZoomFullscreen      = "Koko nytt";
    
    ls->menuPropsEmulation      = "Emulointi";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "ni";
    ls->menuPropsControls       = "Kontrollit";
    ls->menuPropsPerformance    = "Suorituskyky";
    ls->menuPropsLanguage       = "Kieli";
    
    ls->menuHelpHelp            = "Ohjeen aiheet";
    ls->menuHelpAbout           = "Tietoja blueMSX:st";

    ls->menuFileCart1           = "Cartridge Slot 1";
    ls->menuFileCart2           = "Cartridge Slot 2";
    ls->menuFileDiskA           = "Levykeasema A";
    ls->menuFileDiskB           = "Levykeasema B";
    ls->menuFileCas             = "Kasettiasema";
    ls->menuFileLoadState       = "Lataa CPU-tila";
    ls->menuFileSaveState       = "Tallenna CPU-tila";
    ls->menuFileQLoadState      = "Pikalataa CPU-tila";
    ls->menuFileQSaveState      = "Pikatallenna CPU-tila";
    ls->menuFileCaptureAudio    = "Kaappaa Audio";
    ls->menuFileScreenShot      = "Kaappaa ScreenShot";
    ls->menuFileExit            = "Lopeta";

    ls->menuRunRun              = "Suorita";
    ls->menuRunPause            = "Keskeyt";
    ls->menuRunStop             = "Pysyt";
    ls->menuRunSoftReset        = "Hardware resetointi";
    ls->menuRunHardReset        = "Software resetointi";
    ls->menuRunCleanReset       = "Puhdas resetointi";

    ls->menuFile                = "Tiedosto";
    ls->menuRun                 = "Ajo";
    ls->menuWindow              = "Ikkuna";
    ls->menuOptions             = "Asetukset";
    ls->menuHelp                = "Ohje";
    
    ls->errorTitle              = "blueMSX - Virhe";
    ls->errorEnterFullscreen    = "Eponnistuminen koko nyttn siirtymisess.           \n";
    ls->errorDirectXFailed      = "Eponnistuminen DirectX objektien luonnissa.           \nKytetn GDI:t oletuksena.\nTarkista Videon ominaisuudet.";
    ls->errorNoRomInZip         = "Zip arkistossa ei havaintoa .rom tiedostosta.";
    ls->errorNoDskInZip         = "Zip arkistossa ei havaintoa .dsk tiedostosta.";
    ls->errorNoCasInZip         = "Zip arkistossa ei havaintoa .cas tiedostosta.";
    ls->errorNoHelp             = "Ei pystytty paikantamaan blueMSX:n ohjeita.";
    ls->errorStartEmu           = "Eponnistuminen MSX-emulaattorin kynnistyksess.";

    ls->tooltipReset            = "Resetoi MSX";
    ls->tooltipCart1            = "Lis cartridge slottiin 1";
    ls->tooltipCart2            = "Lis cartridge slottiin 2";
    ls->tooltipDiskA            = "Lis levyke levykeasemaan A";
    ls->tooltipDiskB            = "Lis levyke levykeasemaan B";
    ls->tooltipCas              = "Lis kasettinauha kasettiasemaan";
    ls->tooltipStart            = "Kynnist emulointi";
    ls->tooltipResume           = "Palauta emulointi";
    ls->tooltipPause            = "Keskeyt emulointi";
    ls->tooltipWindowSize       = "Aseta ikkunan koko";
    ls->tooltipProperties       = "Avaa Ominaisuudet";
    ls->tooltipHelp             = "Avaa Ohjeikkuna";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - Lataa rom tiedosto";
    ls->dlgLoadDsk              = "blueMSX - Lataa dsk tiedosto";
    ls->dlgLoadCas              = "blueMSX - Lataa cas tiedosto";
    ls->dlgLoadRomDskCas        = "blueMSX - Valitse rom, dsk tai cas tiedosto ladattavaksi";
    ls->dlgLoadRomDesc          = "Valitse cartridge-kasetti ladattavaksi:";
    ls->dlgLoadDskDesc          = "Valitse levyke ladattavaksi:";
    ls->dlgLoadCasDesc          = "Valitse kasettinauha ladattavaksi:";
    ls->dlgLoadRomDskCasDesc    = "Valitse tiedosto ladattavaksi:";
    ls->dlgLoadState            = "Lataa CPU-tila";
    ls->dlgSaveState            = "Tallenna CPU-tila";
    ls->dlgInsertRom1           = "Lis cartridge slottiin 1";
    ls->dlgInsertRom2           = "Lis cartridge slottiin 2";
    ls->dlgInsertDiskA          = "Lis levyke levykeasemaan A";
    ls->dlgInsertDiskB          = "Lis levyke levykeasemaan B";
    ls->dlgInsertCas            = "Lis kasettinauha";

    ls->dlgOK                   = "OK";
    ls->dlgOpen                 = "Avaa";
    ls->dlgCancel               = "Peruuta";

    ls->dlgTapeTitle            = "blueMSX - Kasettinauhan sijainti";
    ls->dlgTapeFrameText        = "Kasettinauhan sijainti";
    ls->dlgTapeCurrentPos       = "Nykyinen sijainti";
    ls->dlgTapeTotalTime        = "Kokonaispituus";

    ls->dlgZipReset             = "Resetoi lismisen jlkeen";

    ls->dlgAboutTitle           = "blueMSX - Tiedot";

    ls->dlgJoyTitle1            = "blueMSX - Ohjaussauvan nppinsetti A";
    ls->dlgJoyTitle2            = "blueMSX - Ohjaussauvan nppinsetti B";
    ls->dlgJoyUpText            = "Yls";
    ls->dlgJoyDownText          = "Alas";
    ls->dlgJoyLeftText          = "Vasen";
    ls->dlgJoyRightText         = "Oikea";
    ls->dlgJoyButton1Text       = "Nappi 1";
    ls->dlgJoyButton2Text       = "Nappi 2";
    ls->dlgJoyGB                = "Nppinsetin asetukset ";

    ls->dlgLangLangText         = "Valitse blueMSX:n haluamasi kieli";
    ls->dlgLangLangTitle        = "blueMSX - Kieli";

    ls->propTitle               = "blueMSX - Ominaisuudet";
    ls->propEmulation           = "Emulointi";
    ls->propVideo               = "Video";
    ls->propSound               = "ni";
    ls->propControls            = "Kontrollit";
    ls->propPerformance         = "Suorituskyky";
    
    ls->propEmuGeneralGB        = "Yleiset ";
    ls->propEmuFamilyText       = "MSX laite:";
    ls->propEmuMemoryGB         = "Muisti ";
    ls->propEmuRamSizeText      = "RAM koko:";
    ls->propEmuVramSizeText     = "VRAM koko:";
    ls->propEmuSpeedGB          = "Emuloinnin nopeus ";
    ls->propEmuSpeedText        = "Emuloinnin nopeus:";

    ls->propMonMonGB            = "Nytt ";
    ls->propMonTypeText         = "Nytttyyppi:";
    ls->propMonEmuText          = "Nytn emulointi:";
    ls->propVideoYypeText       = "Nytn koko:";
    ls->propWindowSizeText      = "Ikkunan koko:";

    ls->propPerfVideoDrvGB      = "Video ";
    ls->propPerfVideoDispDrvText= "Nytnohjain:";
    ls->propPerfFrameSkipText   = "Frame skippaus:";
    ls->propPerfAudioDrvGB      = "Audio ";
    ls->propPerfAudioDrvText    = "nenohjain:";
    ls->propPerfAudioBufSzText  = "nipuskurin koko:";
    ls->propPerfEmuGB           = "Emulointi ";
    ls->propPerfSyncModeText    = "Synkronointi:";

    ls->propSndChipEmuGB        = "nipiirin emulointi ";
    ls->propSndMixerGB          = "Audiomikseri ";
    ls->propSndMonoText         = "mono";
    ls->propSndStereoText       = "stereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (YM-2413 nipiiri)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (Y8950 nipiiri)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "Portti #1 ";
    ls->propJoyPort2GB          = "Portti #2 ";
    ls->propJoyAutofireText     = "Autotulitus:";
    ls->propJoyKeysetGB         = "Ohjaussauvan nppinsetti ";
    ls->propJoyKeyest1          = "Mrit nppinsetti A";
    ls->propJoyKeyest2          = "Mrit nppinsetti B";

    ls->enumVideoMonColor       = "Vrillinen";
    ls->enumVideoMonGrey        = "Mustavalkoinen";
    ls->enumVideoMonGreen       = "Vihertv";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Ei kytss";
    ls->enumVideoEmuYc          = "Y/C kaapeli (terv)";



    ls->enumVideoEmuYcBlur      = "Kohiseva Y/C kaapeli";
    ls->enumVideoEmuComp        = "Komposiittikaapeli (sumea)";
    ls->enumVideoEmuCompBlur    = "Kohiseva komposiittikaapeli";
    ls->enumVideoEmuScale2x     = "2x skaalaus";

    ls->enumVideoSize1x         = "Normaali - 320x200";
    ls->enumVideoSize2x         = "Tupla - 640x400";
    ls->enumVideoSizeFullscreen = "Koko nytt";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "Ei yhtn";
    ls->enumVideoFrameskip1     = "1 kuva";
    ls->enumVideoFrameskip2     = "2 kuvaa";
    ls->enumVideoFrameskip3     = "3 kuvaa";
    ls->enumVideoFrameskip4     = "4 kuvaa";
    ls->enumVideoFrameskip5     = "5 kuvaa";

    ls->enumSoundDrvNone        = "Ei nt";
    ls->enumSoundDrvWMM         = "WMM ohjain";
    ls->enumSoundDrvDirectX     = "DirectX ohjain";

    ls->enumEmuSync1ms          = "1ms (paras)";
    ls->enumEmuSyncAuto         = "Auto (nopea)";

    ls->enumControlsJoyNone     = "Ei mitn";
    ls->enumControlsJoyNumpad   = "Numpdi";
    ls->enumControlsJoyKeysetA  = "Nppinsetti A";
    ls->enumControlsJoyKeysetB  = "Nppinsetti B";
    ls->enumControlsJoyPCjoy1   = "PC ohjaussauva #1";
    ls->enumControlsJoyPCjoy2   = "PC ohjaussauva #2";
    ls->enumControlsJoyMouse    = "Hiiri";

    ls->enumControlsAfOff       = "Poissa";
    ls->enumControlsAfSlow      = "Hidas";
    ls->enumControlsAfMedium    = "Keski-";
    ls->enumControlsAfFast      = "Nopea";

    ls->dlgAboutAbout           = "TIEDOT\r\n=====";
    ls->dlgAboutVersion         = "Versio:";
    ls->dlgAboutBuildNumber     = "Kooste:";
    ls->dlgAboutBuildDate       = "Pivys:";
    ls->dlgAboutCreat           = "Luonnut Daniel Vik";
    ls->dlgAboutDevel           = "KEHITTJT\r\n========";
    ls->dlgAboutThanks          = "ERIKOISKIITOKSET\r\n============";
    ls->dlgAboutLisence         = "LISENSSI\r\n"
                                  "======\r\n\r\n"
                                  "Tm ohjelmisto toimitetaan 'sellaisena kuin se on', ilman minknlaista "
                                  "takuuta. Tekij(t) eivt siten ota mitn vastuuta mahdollisista vahingoista "
                                  "joita sinulle voi ilmet tmn ohjelmiston kytn yhteydess.\r\n\r\n"
                                  "Kaikille on mynnetty oikeus kytt tt ohjelmistoa, kunhan se on ei-kaupallisiin "
                                  "tarkoituksiin.\r\n\r\n\r\n"
                                  "Listietoja lydt osoitteesta www.bluemsx.com.";

    // New entries
    ls->menuTools                = "Tykalut";
    ls->menuToolsMachine         = "Laitekokoonpano editori";
    ls->menuPropsSettings        = "Asetukset";
    ls->menuCasRewindAfterInsert = "Kelaa taaksenpin lismisen jlkeen";
    ls->menuCasUseReadOnly       = "Kyt Vain luku -kasettinauhoja";
    ls->lmenuCasSaveAs           = "Tallenna kasettinauha nimell...";

    ls->dlgSaveCassette          = "blueMSX - Tallenna kasettinauha";
    ls->dlgTapeCustom            = "Nyt muokatut tiedostot";
    ls->dlgTapeSetPosText        = "Kasettinauhan sijainti:";
    ls->dlgTabPosition           = "Sijainti";
    ls->dlgTabType               = "Tyyppi";
    ls->dlgTabFilename           = "Tiedoston nimi";

    ls->propSettings             = "Asetukset";
    
    ls->propSetFileHistoryGB     = "Tiedostohistoria ";
    ls->propSetFileHistorySize   = "Tiedostojen mr tiedostohistoriassa:";
    ls->propSetFileHistoryClear  = "Tyhjenn historia";
    ls->propSetScreenSaverGB     = "Nytnsstj ";
    ls->propSetScreenSaver       = " Poista nytnsstj kytst kun blueMSX on kynniss";

    ls->confTitle                = "blueMSX - Laitekokoonpano editori";
    ls->confSave                 = "Tallenna";
    ls->confSaveAs               = "Tallenna nimell...";
    ls->confRun                  = "Suorita";
    ls->confClose                = "Sulje";
    ls->confConfigText           = "Kokoonpano";
    ls->confSlotLayout           = "Slot sommite";
    ls->confMemory               = "Muisti";
    ls->confChipEmulation        = "Piirin emulointi";

    ls->confSlotLayoutGB         = "Slot sommite ";
    ls->confSlotExtSlotGB        = "Ulkoiset slotit ";
    ls->confSlotSlot0            = "Slot 0";
    ls->confSlotSlot1            = "Slot 1";
    ls->confSlotSlot2            = "Slot 2";
    ls->confSlotSlot3            = "Slot 3";
    ls->confSlotCart1            = "Cartridge 1:";
    ls->confSlotCart2            = "Cartridge 2:";
    ls->confSlotPrimary          = "Ensisijainen";
    ls->confSlotExpanded         = "Laajennettu (nelj lispaikkaa)";

    ls->confMemAdd               = "Lis...";
    ls->confMemEdit              = "Muokkaa...";
    ls->confMemRemove            = "Poista";
    ls->confMemSlot              = "Slot";
    ls->confMemAddresss          = "Osoite";
    ls->confMemType              = "Tyyppi";
    ls->confMemRomImage          = "Rom tiedosto";
    
    ls->confSaveTitle            = "blueMSX - Tallenna kokoonpano";
    ls->confSaveText             = "Haluatko korvata nykyisen laitekokoonpanon:";

    ls->confChipVideoGB          = "Video ";
    ls->confChipVideoChip        = "Videopiiri:";
    ls->confChipVideoRam         = "Video RAM:";
    ls->confChipSoundGB          = "ni ";

    ls->slotEditMemTitle         = "blueMSX - Editoi kartoittaja";
    ls->slotEditMemGB            = "Kartoittajan yksityiskohdat ";
    ls->slotEditMemType          = "Tyyppi:";
    ls->slotEditMemFile          = "Tiedosto:";
    ls->slotEditMemAddress       = "Osoite";
    ls->slotEditMemSize          = "Koko";
    ls->slotEditMemSlot          = "Slot";

    ls->confDiscardTitle         = "blueMSX - Kokoonpano";
    ls->confExitSaveTitle        = "blueMSX - Poistu kokoonpano editorista";
    ls->confExitSaveText         = "Haluatko hylt muutokset nykyiseen kokoonpanoon?";

    ls->confSaveAsTitle          = "blueMSX - Tallenna laitekokoonpano nimell...";
    ls->confSaveAsMachineName    = "Laitekokoonpano:";

    ls->confEditMemInternalRoms  = "blueMSX - Sisiset rommit";
    ls->propSndMoonsound         = " Moonsound";

    ls->propFileTypesGB          = "Tiedostotyypit ";
    ls->propFileTypes            = " Rekisteri tiedostotyypit blueMSX:lle (.rom, .dsk, .cas, .sta)";
    ls->propDisableWinKeys       = " Automaattinen MSX toiminto Windowsin menu-nppimille"; 
    ls->propWindowsEnvGB         = "Windowsin elinymprist "; 
    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW kiihdytys"; 
    ls->enumVideoDrvDirectDrawHWSys = "DirectDraw mix."; 
    ls->propMonHorizStretch      = " Vaakasuora venytys";
    ls->propMonVertStretch       = " Pystysuora venytys";
    ls->propClearHistory         = "Haluatko varmasti tyhjent tiedostohistorian ?";

    ls->propEmuFrontSwitchGB     = "Panasonic kytkimet ";
    ls->propEmuFrontSwitch       = " Etukytkin (MSX2+)";
    ls->propEmuAudioSwitch       = " MSX-AUDIO cartridge kytkin";


    ls->dlgCmosGB                = "CMOS ";
    ls->dlgCmosEnable            = " Mahdollista CMOS";
    ls->dlgCmosBattery           = " Kyt ladattuja pattereita";

    ls->menuCartSnatcher        = "The Snatcher Cartridge";
    ls->menuCartSdSnatcher      = "SD-Snatcher Cartridge";
    ls->menuCartSCCMirrored     = "SCC Mirrored Cartridge";
    ls->menuCartSCCExpanded     = "SCC Expanded Cartridge";
    
    ls->warningTitle             = "blueMSX - Warning";
    ls->tooltipStop              = "Pysyt emulointi";
};

#endif

