/*****************************************************************************
** File:        Win32file.c
**
** Author:      Daniel Vik
**
** Description: File open and save dialog boxes.
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include <windows.h> 
#include <tchar.h>
#include "Win32file.h"
#include <stdlib.h>
#include <stdio.h>
 
UINT_PTR CALLBACK hookProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    if (iMsg == WM_INITDIALOG) {
        centerDialog(hDlg);
    }
    return 0;
}

char* openFile(HWND hwndOwner, _TCHAR* pTitle, char* pFilter, char* pDir, int mustExist, char* defExt)
{ 
    OPENFILENAME ofn; 
    BOOL rv; 
    static char pFileName[MAX_PATH];
    FILE* file;

    pFileName[0] = 0; 

    ofn.lStructSize = sizeof(OPENFILENAME); 
    ofn.hwndOwner = hwndOwner; 
    ofn.hInstance = (HINSTANCE)GetModuleHandle(NULL); 
    ofn.lpstrFilter = pFilter ? pFilter : "*.*\0\0"; 
    ofn.lpstrCustomFilter = NULL; 
    ofn.nMaxCustFilter = 0; 
    ofn.nFilterIndex = 0; 
    ofn.lpstrFile = pFileName; 
    ofn.nMaxFile = 1024; 
    ofn.lpstrFileTitle = NULL; 
    ofn.nMaxFileTitle = 0; 
    ofn.lpstrInitialDir = pDir; 
    ofn.lpstrTitle = pTitle; 
    ofn.Flags = OFN_EXPLORER | OFN_ENABLEHOOK | (mustExist ? OFN_FILEMUSTEXIST : 0); 
    ofn.nFileOffset = 0; 
    ofn.nFileExtension = 0; 
    ofn.lpstrDefExt = NULL; 
    ofn.lCustData = 0; 
    ofn.lpfnHook = hookProc; 
    ofn.lpTemplateName = NULL; 

    rv = GetOpenFileName(&ofn); 

    if (!rv) {
        return NULL; 
    }

    if (pDir != NULL) {
        GetCurrentDirectory(MAX_PATH - 1, pDir);
    }

    file = fopen(pFileName, "r");
    if (file != NULL) {
        fclose(file);
    }
    else {
        if (defExt) {
            if (strlen(pFileName) <= strlen(defExt)) {
                strcat(pFileName, defExt);
            }
            else {
                char* pos = pFileName + strlen(pFileName) - strlen(defExt);
                int  len  = strlen(defExt);
                while (len--) {
                    if (toupper(pos[len]) != toupper(defExt[len])) {
                        break;
                    }
                }
                if (len >= 0) {
                    strcat(pFileName, defExt);
                }
            }
        }
        file = fopen(pFileName, "a+");
        if (file != NULL) {
            fclose(file);
        }
    }

    return pFileName; 
} 

char* saveFile(HWND hwndOwner, _TCHAR* pTitle, char* pFilter, int* pFilterIndex, char* pDir) { 
    OPENFILENAME ofn; 
    BOOL rv; 
    static char pFileName[MAX_PATH]; 
    pFileName[0] = 0; 

    ofn.lStructSize = sizeof(OPENFILENAME); 
    ofn.hwndOwner = hwndOwner; 
    ofn.hInstance = (HINSTANCE)GetModuleHandle(NULL); 
    ofn.lpstrFilter = pFilter ? pFilter : "*.*\0\0"; 
    ofn.lpstrCustomFilter = NULL; 
    ofn.nMaxCustFilter = 0; 
    ofn.nFilterIndex = pFilterIndex ? *pFilterIndex : 0; 
    ofn.lpstrFile = pFileName; 
    ofn.nMaxFile = 1024; 
    ofn.lpstrFileTitle = NULL; 
    ofn.nMaxFileTitle = 0; 
    ofn.lpstrInitialDir = pDir; 
    ofn.lpstrTitle = pTitle; 
    ofn.Flags = OFN_EXPLORER | OFN_ENABLEHOOK; 
    ofn.nFileOffset = 0; 
    ofn.nFileExtension = 0; 
    ofn.lpstrDefExt = NULL; 
    ofn.lCustData = 0; 
    ofn.lpfnHook = hookProc; 
    ofn.lpTemplateName = NULL; 

    rv = GetSaveFileName(&ofn); 

    if (!rv) { 
        return NULL; 
    } 

    if (pFilterIndex) {
        *pFilterIndex = ofn.nFilterIndex;
    }

    if (pDir != NULL) {
        GetCurrentDirectory(MAX_PATH - 1, pDir);
    }

    return pFileName; 
} 


