/*****************************************************************************
** File:        sramLoader.c
**
** Author:      Daniel Vik
**
** Description: sram helper methods
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "sramLoader.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

char* sramCreateFilename(char* romFilename) {
    static char SRAMfileName[512];
    char* dst = SRAMfileName + 512;
    char* src;
    
    src = romFilename + strlen(romFilename);

    *--dst = '\0';
    *--dst = 'm';
    *--dst = 'a';
    *--dst = 'r';
    *--dst = 's';

    while (*src != '.' && src >= romFilename) {
        src--;
    }

    while (*src != '/' && *src != '\\' && src >= romFilename) {
        *--dst = *src--;
    }

    *--dst = '/';
    *--dst = 'M';
    *--dst = 'A';
    *--dst = 'R';
    *--dst = 'S';

    return dst;
}

void sramLoad(char* filename, UInt8* sram, int length, void* header, int headerLength) {
    FILE* file;

    file = fopen(filename, "rb");
    if (file != NULL) {
        if (headerLength > 0) {
            char* readHeader[256];

            fread(readHeader, 1, headerLength, file);
            if (memcmp(readHeader, header, headerLength)) {
                fclose(file);
                return;
            }
        }
        fread(sram, 1, length, file);
        fclose(file);
    }
}

void sramSave(char* filename, UInt8* sram, int length, void* header, int headerLength) {
    FILE* file;

    file = fopen(filename, "wb");
    if (file != NULL) {
        if (headerLength > 0) {
            fwrite(header, 1, headerLength, file);
        }
        fwrite(sram, 1, length, file);
        fclose(file);
    }
}

