/*****************************************************************************
** File:
**      Win32joystick.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Joystick support
**
******************************************************************************
*/
#ifndef WIN32_JOYSTICK_H
#define WIN32_JOYSTICK_H

#include <windows.h>

typedef enum { JOY_NONE, JOY_NUMPAD, JOY_HW1, JOY_HW2, JOY_KEYSETA, JOY_KEYSETB, JOY_HW } JoyType;
typedef enum { JOY_UP, JOY_DOWN, JOY_LEFT, JOY_RIGHT, JOY_BT1, JOY_BT2 } JoyAction;
typedef enum { JOY_AF_OFF, JOY_AF_SLOW, JOY_AF_MEDIUM, JOY_AF_FAST } JoyAutofire;

void JoystickSetKeyStateKey(int keyset, JoyAction key, int value);
void JoystickSetType(int joyId, JoyType joyType);
BYTE JoystickGetState(int joyId);
void JoystickSetAutofire(int joyId, JoyAutofire joyAutofire);
char** JoystickGetDevList();

#endif
