/*****************************************************************************
** File:
**      Win32directx.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Direct X draw support
**
******************************************************************************
*/
#ifndef WIN32_DIRECTX_H
#define WIN32_DIRECTX_H

#include <windows.h>
#include "VideoRender.h"

typedef enum { 
    DXE_OK                    =  0,
    DXE_DIRECTDRAWCREATE      = -1,
    DXE_SETCOOPERATIVELEVEL   = -2,
    DXE_SETDISPLAYMODE        = -3,
    DXE_CREATESURFACE         = -4,
    DXE_CREATEATTACHEDSURFACE = -5,
    DXE_CREATECLIPPER         = -6, 
    DXE_SETHWND               = -7,
    DXE_SETCLIPPER            = -8,
    DXE_CREATEFROMWINDOW      = -9
} DirectXError;

void DirectXUpdateSurface(Video* pVideo, void* srcBits, int srcWidth, int srcHeight, int* srcDoubleWidth,
                          int dstPitchY, int dstOffset, int zoom, int evenOddPage, int interlace);
void DirectXExitFullscreenMode(HWND hwnd);
int DirectXEnterFullscreenMode(HWND hwnd, int width, int height, int depth);
int DirectXEnterWindowedMode(HWND hwnd, int width, int height);
int DirectXUpdateWindowedMode(HWND hwnd, int width, int height);

#endif
