#include <stdio.h>
#include "MSXTypes.h"
#include "MSX.h"

extern int ScrMode;
extern UInt8 VDP[64]; /* VDP control reg-ers */
extern UInt8 VDPStatus[16];            /* VDP status reg-ers  */
extern UInt8 VRAM[];


typedef enum { VDP_V9938, VDP_V9958 } VdpVersion;

void vdpInit(UInt32 systemTime, VdpVersion version);
void vdpDestroy();
void vdpSync(UInt32 systemTime);
UInt8 vdpRead(UInt32 systemTime);
UInt8 vdpReadStatus(UInt32 systemTime);
void vdpWrite(UInt32 systemTime, UInt8 Value);
void vdpWriteLatch(UInt32 systemTime, UInt8 Value);
void vdpWritePaletteLatch(UInt32 systemTime, UInt8 Value);
void vdpWriteRegister(UInt32 systemTime, UInt8 Value);
int vdpRefreshLine(Z80 *R);
int vdpSaveState(FILE* F);
int vdpLoadState(FILE* F);


/* The following methods needs target dependent implementation */
extern void SetColor(int palEntry, UInt32 rgbColor);
extern void RefreshScreen(int, int, int);

