#include "Language.h"
#include "LanguageStrings.h"
#include <stdlib.h>
//#include "Resource.h"

#include "LanguageEnglish.h"
#include "LanguageSwedish.h"
#include "LanguageSpannish.h"
#include "LanguageJapanese.h"
#include "LanguagePortuguese.h"
#include "LanguageFrench.h"
#include "LanguageDutch.h"
 
static LanguageStrings langEnglish;
static LanguageStrings langSwedish;
static LanguageStrings langSpanish;
static LanguageStrings langJapanese;
static LanguageStrings langPortuguese;
static LanguageStrings langFrench;
static LanguageStrings langDutch;

static LanguageStrings* ls;

typedef struct {
    EmuLanguageType type;
    _TCHAR          name[32];
} LanguageInfo;

static LanguageInfo languageInfo[] = {
    { EMU_LANG_DUTCH,       "Dutch" },
    { EMU_LANG_ENGLISH,     "English" },
    { EMU_LANG_FRENCH,      "French" },
    { EMU_LANG_JAPANESE,    "Japanese" },
    { EMU_LANG_PORTUGUESE,  "Portuguese" },
    { EMU_LANG_SPANISH,     "Spanish" },
    { EMU_LANG_SWEDISH,     "Swedish" },
    { EMU_LANG_UNKNOWN,     "" }
};

EmuLanguageType langFromName(_TCHAR* name) {
    int i;
    for (i = 0; languageInfo[i].type != EMU_LANG_UNKNOWN; i++) {
        if (0 == _tcscmp(name, languageInfo[i].name)) {
            break;
        }
    }
    return languageInfo[i].type;
}

static BOOL CALLBACK langDlgProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam) 
{
    static int* lang = NULL;

    switch (iMsg) {
    case WM_INITDIALOG:
        {
            int i;

            lang = (int*)lParam;

            SetWindowText(hDlg, langDlgLangTitle());
            SendMessage(GetDlgItem(hDlg, IDC_LANGTXT), WM_SETTEXT, 0, (LPARAM)langDlgLangLangText());
            SetWindowText(GetDlgItem(hDlg, IDOK), langDlgOK());
            SetWindowText(GetDlgItem(hDlg, IDCANCEL), langDlgCancel());

            for (i = 0; languageInfo[i].type != EMU_LANG_UNKNOWN; i++) {
                SendMessage(GetDlgItem(hDlg, IDC_LANGLIST), LB_ADDSTRING, 0, (LPARAM)languageInfo[i].name);
                if (languageInfo[i].type == *lang) {
                    SendMessage(GetDlgItem(hDlg, IDC_LANGLIST), LB_SETCURSEL, i, 0);
                }
            }

            return FALSE;
        }

    case WM_COMMAND:
        switch(LOWORD(wParam)) {
        case IDC_LANGLIST:
            if (HIWORD(wParam) != 2) {
                break;
            }
            // else, fall through
        case IDOK:
            {
                int index = SendMessage(GetDlgItem(hDlg, IDC_LANGLIST), LB_GETCURSEL, 0, 0);
                *lang = languageInfo[index].type;
                EndDialog(hDlg, TRUE);
            }
            return TRUE;
        case IDCANCEL:
            EndDialog(hDlg, FALSE);
            return TRUE;
        }
        break;
    case WM_CLOSE:
        EndDialog(hDlg, FALSE);
        return TRUE;
    }

    return FALSE;
}

void langInit() {
    langInitEnglish(&langEnglish);
    langInitSwedish(&langSwedish);
    langInitSpanish(&langSpanish);
    langInitJapanese(&langJapanese);
    langInitPortuguese(&langPortuguese);
    langInitFrench(&langFrench);
    langInitDutch(&langDutch);

    ls = &langEnglish;
}

int langSetLanguage(EmuLanguageType languageType) {
    switch (languageType) {
    case EMU_LANG_ENGLISH:
        ls = &langEnglish;
        break;
    case EMU_LANG_SWEDISH:
        ls = &langSwedish;
        break;
    case EMU_LANG_SPANISH:
        ls = &langSpanish;
        break;
    case EMU_LANG_JAPANESE:
        ls = &langJapanese;
        break;
    case EMU_LANG_PORTUGUESE:
        ls = &langPortuguese;
        break;
    case EMU_LANG_FRENCH:
        ls = &langFrench;
        break;
    case EMU_LANG_DUTCH:
        ls = &langDutch;
        break;
    default:
        return 0;
    }

    return 1;
}

int langShowDlg(HWND hwnd, int oldLanguage) {
    int lang = oldLanguage;
    DialogBoxParam(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_LANGUAGE), hwnd, langDlgProc, (LPARAM)&lang);
    return lang;
}

_TCHAR* langStatusBarStopped() { return ls->statusBarStopped; }
_TCHAR* langStatusBarPaused()  { return ls->statusBarPaused; }
_TCHAR* langStatusBarRunning() { return ls->statusBarRunning; }

_TCHAR* langMenuHardReset() { return ls->menuHardReset; }
_TCHAR* langMenuSoftReset() { return ls->menuSoftReset; }

_TCHAR* langMenuCartInsert() { return ls->menuCartInsert; }
_TCHAR* langMenuCartRemove() { return ls->menuCartRemove; }
_TCHAR* langMenuCartAutoReset() { return ls->menuCartAutoReset; }
_TCHAR* langMenuCartNoRecentFiles() { return ls->menuCartNoRecentFiles; }
_TCHAR* langMenuCartSCCPlus() { return ls->menuCartSCCPlus; }
_TCHAR* langMenuCartFMPac()  { return ls->menuCartFMPac; }
_TCHAR* langMenuCartSpecial() { return ls->menuCartSpecial; }

_TCHAR* langMenuDiskInsert() { return ls->menuDiskInsert; }
_TCHAR* langMenuDiskEject() { return ls->menuDiskEject; }
_TCHAR* langMenuDiskAutoStart() { return ls->menuDiskAutoStart; }
_TCHAR* langMenuDiskNoRecentFiles() { return ls->menuDiskNoRecentFiles; }

_TCHAR* langMenuCasInsert() { return ls->menuCasInsert; }
_TCHAR* langMenuCasEject() { return ls->menuCasEject; }
_TCHAR* langMenuCasSetPosition() { return ls->menuCasSetPosition; }
_TCHAR* langMenuCasRewind() { return ls->menuCasRewind; }
_TCHAR* langMenuCasNoRecentFiles() { return ls->menuCasNoRecentFiles; }

_TCHAR* langMenuZoomNormal() { return ls->menuZoomNormal; }
_TCHAR* langMenuZoomDouble() { return ls->menuZoomDouble; }
_TCHAR* langMenuZoomFullscreen() { return ls->menuZoomFullscreen; }

_TCHAR* langMenuPropsEmulation() { return ls->menuPropsEmulation; }
_TCHAR* langMenuPropsVideo() { return ls->menuPropsVideo; }
_TCHAR* langMenuPropsSound() { return ls->menuPropsSound; }
_TCHAR* langMenuPropsControls() { return ls->menuPropsControls; }
_TCHAR* langMenuPropsPerformance() { return ls->menuPropsPerformance; }
_TCHAR* langMenuPropsLanguage() { return ls->menuPropsLanguage; }

_TCHAR* langMenuHelpHelp() { return ls->menuHelpHelp; }
_TCHAR* langMenuHelpAbout() { return ls->menuHelpAbout; }

_TCHAR* langMenuFileCart1() { return ls->menuFileCart1; }
_TCHAR* langMenuFileCart2() { return ls->menuFileCart2; }
_TCHAR* langMenuFileDiskA() { return ls->menuFileDiskA; }
_TCHAR* langMenuFileDiskB() { return ls->menuFileDiskB; }
_TCHAR* langMenuFileCas() { return ls->menuFileCas; }
_TCHAR* langMenuFileLoadState() { return ls->menuFileLoadState; }
_TCHAR* langMenuFileSaveState() { return ls->menuFileSaveState; }
_TCHAR* langMenuFileQLoadState() { return ls->menuFileQLoadState; }
_TCHAR* langMenuFileQSaveState() { return ls->menuFileQSaveState; }
_TCHAR* langMenuFileCaptureAudio() { return ls->menuFileCaptureAudio; }
_TCHAR* langMenuFileScreenShot() { return ls->menuFileScreenShot; }
_TCHAR* langMenuFileExit() { return ls->menuFileExit; }

_TCHAR* langMenuRunRun() { return ls->menuRunRun; }
_TCHAR* langMenuRunPause() { return ls->menuRunPause; }
_TCHAR* langMenuRunStop() { return ls->menuRunStop; }
_TCHAR* langMenuRunSoftReset() { return ls->menuRunSoftReset; }
_TCHAR* langMenuRunHardReset() { return ls->menuRunHardReset; }
_TCHAR* langMenuRunCleanReset() { return ls->menuRunCleanReset; }

_TCHAR* langMenuFile() { return ls->menuFile; }
_TCHAR* langMenuRun() { return ls->menuRun; }
_TCHAR* langMenuWindow() { return ls->menuWindow; }
_TCHAR* langMenuOptions() { return ls->menuOptions; }
_TCHAR* langMenuHelp() { return ls->menuHelp; }

_TCHAR* langErrorTitle() { return ls->errorTitle; }
_TCHAR* langErrorEnterFullscreen() { return ls->errorEnterFullscreen; }
_TCHAR* langErrorDirectXFailed() { return ls->errorDirectXFailed; }
_TCHAR* langErrorNoRomInZip() { return ls->errorNoRomInZip; }
_TCHAR* langErrorNoDskInZip() { return ls->errorNoDskInZip; }
_TCHAR* langErrorNoCasInZip() { return ls->errorNoCasInZip; }
_TCHAR* langErrorNoHelp() { return ls->errorNoHelp; }
_TCHAR* langErrorStartEmu() { return ls->errorStartEmu; }

_TCHAR* langTooltipReset() { return ls->tooltipReset; }
_TCHAR* langTooltipCart1() { return ls->tooltipCart1; }
_TCHAR* langTooltipCart2() { return ls->tooltipCart2; }
_TCHAR* langTooltipDiskA() { return ls->tooltipDiskA; }
_TCHAR* langTooltipDiskB() { return ls->tooltipDiskB; }
_TCHAR* langTooltipCas() { return ls->tooltipCas; }
_TCHAR* langTooltipStart() { return ls->tooltipStart; }
_TCHAR* langTooltipResume() { return ls->tooltipResume; }
_TCHAR* langTooltipPause() { return ls->tooltipPause; }
_TCHAR* langTooltipWindowSize() { return ls->tooltipWindowSize; }
_TCHAR* langTooltipProperties() { return ls->tooltipProperties; }
_TCHAR* langTooltipHelp() { return ls->tooltipHelp; }

_TCHAR* langDlgMainWindow() { return ls->dlgMainWindow; }
_TCHAR* langDlgLoadRom() { return ls->dlgLoadRom; }
_TCHAR* langDlgLoadDsk() { return ls->dlgLoadDsk; }
_TCHAR* langDlgLoadCas() { return ls->dlgLoadCas; }
_TCHAR* langDlgLoadRomDskCas() { return ls->dlgLoadRomDskCas; }
_TCHAR* langDlgLoadRomDesc() { return ls->dlgLoadRomDesc; }
_TCHAR* langDlgLoadDskDesc() { return ls->dlgLoadDskDesc; }
_TCHAR* langDlgLoadCasDesc() { return ls->dlgLoadCasDesc; }
_TCHAR* langDlgLoadRomDskCasDesc() { return ls->dlgLoadRomDskCasDesc; }
_TCHAR* langDlgLoadState() { return ls->dlgLoadState; }
_TCHAR* langDlgSaveState() { return ls->dlgSaveState; }
_TCHAR* langDlgInsertRom1() { return ls->dlgInsertRom1; }
_TCHAR* langDlgInsertRom2() { return ls->dlgInsertRom2; }
_TCHAR* langDlgInsertDiskA() { return ls->dlgInsertDiskA; }
_TCHAR* langDlgInsertDiskB() { return ls->dlgInsertDiskB; }
_TCHAR* langDlgInsertCas() { return ls->dlgInsertCas; }

_TCHAR* langDlgOK() { return ls->dlgOK; }
_TCHAR* langDlgCancel() { return ls->dlgCancel; }

_TCHAR* langDlgTapeTitle() { return ls->dlgTapeTitle; }
_TCHAR* langDlgTapeFrameText() { return ls->dlgTapeFrameText; }
_TCHAR* langDlgTapeCurrentPos() { return ls->dlgTapeCurrentPos; }
_TCHAR* langDlgTapeTotalTime() { return ls->dlgTapeTotalTime; }

_TCHAR* langDlgZipReset() { return ls->dlgZipReset; }

_TCHAR* langDlgAboutTitle() { return ls->dlgAboutTitle; }

_TCHAR* langDlgJoyTitle1() { return ls->dlgJoyTitle1; }
_TCHAR* langDlgJoyTitle2() { return ls->dlgJoyTitle2; }
_TCHAR* langDlgJoyUpText() { return ls->dlgJoyUpText; }
_TCHAR* langDlgJoyDownText() { return ls->dlgJoyDownText; }
_TCHAR* langDlgJoyLeftText() { return ls->dlgJoyLeftText; }
_TCHAR* langDlgJoyRightText() { return ls->dlgJoyRightText; }
_TCHAR* langDlgJoyButton1Text() { return ls->dlgJoyButton1Text; }
_TCHAR* langDlgJoyButton2Text() { return ls->dlgJoyButton2Text; }
_TCHAR* langDlgJoyGB() { return ls->dlgJoyGB; }

_TCHAR* langDlgLangLangText() { return ls->dlgLangLangText; }
_TCHAR* langDlgLangTitle() { return ls->dlgLangLangTitle; }

_TCHAR* langPropTitle() { return ls->propTitle; }
_TCHAR* langPropEmulation() { return ls->propEmulation; }
_TCHAR* langPropVideo() { return ls->propVideo; }
_TCHAR* langPropSound() { return ls->propSound; }
_TCHAR* langPropControls() { return ls->propControls; }
_TCHAR* langPropPerformance() { return ls->propPerformance; }

_TCHAR* langPropEmuGeneralGB() { return ls->propEmuGeneralGB; }
_TCHAR* langPropEmuFamilyText() { return ls->propEmuFamilyText; }
_TCHAR* langPropEmuMemoryGB() { return ls->propEmuMemoryGB; }
_TCHAR* langPropEmuRamSizeText() { return ls->propEmuRamSizeText; }
_TCHAR* langPropEmuVramSizeText() { return ls->propEmuVramSizeText; }
_TCHAR* langPropEmuSpeedGB() { return ls->propEmuSpeedGB; }

_TCHAR* langPropMonMonGB() { return ls->propMonMonGB; }
_TCHAR* langPropMonTypeText() { return ls->propMonTypeText; }
_TCHAR* langPropMonEmuText() { return ls->propMonEmuText; }
_TCHAR* langPropVideoYypeText() { return ls->propVideoYypeText; }
_TCHAR* langPropWindowSizeText() { return ls->propWindowSizeText; }

_TCHAR* langPropPerfVideoDrvGB() { return ls->propPerfVideoDrvGB; }
_TCHAR* langPropPerfVideoDispDrvText() { return ls->propPerfVideoDispDrvText; }
_TCHAR* langPropPerfFrameSkipText() { return ls->propPerfFrameSkipText; }
_TCHAR* langPropPerfAudioDrvGB() { return ls->propPerfAudioDrvGB; }
_TCHAR* langPropPerfAudioDrvText() { return ls->propPerfAudioDrvText; }
_TCHAR* langPropPerfAudioBufSzText() { return ls->propPerfAudioBufSzText; }
_TCHAR* langPropPerfEmuGB() { return ls->propPerfEmuGB; }
_TCHAR* langPropPerfSyncModeText() { return ls->propPerfSyncModeText; }

_TCHAR* langPropSndChipEmuGB() { return ls->propSndChipEmuGB; }
_TCHAR* langPropSndMixerGB() { return ls->propSndMixerGB; }
_TCHAR* langPropSndMonoText() { return ls->propSndMonoText; }
_TCHAR* langPropSndStereoText() { return ls->propSndStereoText; }
_TCHAR* langPropSndMsxMusicText() { return ls->propSndMsxMusicText; }
_TCHAR* langPropSndMsxAudioText() { return ls->propSndMsxAudioText; }
_TCHAR* langPropSndMasterText() { return ls->propSndMsxMasterText; }

_TCHAR* langPropJoyPort1GB() { return ls->propJoyPort1GB; }
_TCHAR* langPropJoyPort2GB() { return ls->propJoyPort2GB; }
_TCHAR* langPropJoyAutofireText() { return ls->propJoyAutofireText; }
_TCHAR* langPropJoyKeysetGB() { return ls->propJoyKeysetGB; }
_TCHAR* langPropJoyKeyest1() { return ls->propJoyKeyest1; }
_TCHAR* langPropJoyKeyest2() { return ls->propJoyKeyest2; }

_TCHAR* langEnumVideoMonColor() { return ls->enumVideoMonColor; }
_TCHAR* langEnumVideoMonGrey() { return ls->enumVideoMonGrey; }
_TCHAR* langEnumVideoMonGreen() { return ls->enumVideoMonGreen; }

_TCHAR* langEnumVideoTypePAL() { return ls->enumVideoTypePAL; }
_TCHAR* langEnumVideoTypeNTSC() { return ls->enumVideoTypeNTSC; }

_TCHAR* langEnumVideoEmuNone() { return ls->enumVideoEmuNone; }
_TCHAR* langEnumVideoEmuYc() { return ls->enumVideoEmuYc; }
_TCHAR* langEnumVideoEmuYcBlur() { return ls->enumVideoEmuYcBlur; }
_TCHAR* langEnumVideoEmuComp() { return ls->enumVideoEmuComp; }
_TCHAR* langEnumVideoEmuCompBlur() { return ls->enumVideoEmuCompBlur; }
_TCHAR* langEnumVideoEmuScale2x() { return ls->enumVideoEmuScale2x; }

_TCHAR* langEnumVideoSize1x() { return ls->enumVideoSize1x; }
_TCHAR* langEnumVideoSize2x() { return ls->enumVideoSize2x; }
_TCHAR* langEnumVideoSizeFullscreen() { return ls->enumVideoSizeFullscreen; }

_TCHAR* langEnumVideoDrvDirectDraw() { return ls->enumVideoDrvDirectDraw; }
_TCHAR* langEnumVideoDrvGDI() { return ls->enumVideoDrvGDI; }

_TCHAR* langEnumVideoFrameskip0() { return ls->enumVideoFrameskip0; }
_TCHAR* langEnumVideoFrameskip1() { return ls->enumVideoFrameskip1; }
_TCHAR* langEnumVideoFrameskip2() { return ls->enumVideoFrameskip2; }
_TCHAR* langEnumVideoFrameskip3() { return ls->enumVideoFrameskip3; }
_TCHAR* langEnumVideoFrameskip4() { return ls->enumVideoFrameskip4; }
_TCHAR* langEnumVideoFrameskip5() { return ls->enumVideoFrameskip5; }

_TCHAR* langEnumSoundDrvNone() { return ls->enumSoundDrvNone; }
_TCHAR* langEnumSoundDrvWMM() { return ls->enumSoundDrvWMM; }
_TCHAR* langEnumSoundDrvDirectX() { return ls->enumSoundDrvDirectX; }

_TCHAR* langEnumEmuSync1ms() { return ls->enumEmuSync1ms; }
_TCHAR* langEnumEmuSyncAuto() { return ls->enumEmuSyncAuto; }

_TCHAR* langEnumControlsJoyNone() { return ls->enumControlsJoyNone; }
_TCHAR* langEnumControlsJoyNumpad() { return ls->enumControlsJoyNumpad; }
_TCHAR* langEnumControlsJoyKeysetA() { return ls->enumControlsJoyKeysetA; }
_TCHAR* langEnumControlsJoyKeysetB() { return ls->enumControlsJoyKeysetB; }
_TCHAR* langEnumControlsJoyPCjoy1() { return ls->enumControlsJoyPCjoy1; }
_TCHAR* langEnumControlsJoyPCjoy2() { return ls->enumControlsJoyPCjoy2; }
_TCHAR* langEnumControlsJoyMouse() { return ls->enumControlsJoyMouse; }

_TCHAR* langEnumControlsAfOff() { return ls->enumControlsAfOff; }
_TCHAR* langEnumControlsAfSlow() { return ls->enumControlsAfSlow; }
_TCHAR* langEnumControlsAfMedium() { return ls->enumControlsAfMedium; }
_TCHAR* langEnumControlsAfFast() { return ls->enumControlsAfFast; }

_TCHAR* langDlgAboutAbout() { return ls->dlgAboutAbout; }
_TCHAR* langDlgAboutVersion() { return ls->dlgAboutVersion; }
_TCHAR* langDlgAboutBuildNumber() { return ls->dlgAboutBuildNumber; }
_TCHAR* langDlgAboutBuildDate() { return ls->dlgAboutBuildDate; }
_TCHAR* langDlgAboutDevel() { return ls->dlgAboutDevel; }
_TCHAR* langDlgAboutInfo() { return ls->dlgAboutInfo; }