#ifndef VDP_H
#define VDP_H

#include "MSXTypes.h"
#include "Z80.h"

extern int ScrMode;
extern UInt8 VDP[64]; /* VDP control reg-ers */
extern UInt8 VDPStatus[16];            /* VDP status reg-ers  */
extern UInt8 VRAM[];


typedef enum { VDP_V9938, VDP_V9958, VDP_TMS9929A, VDP_TMS99x8A } VdpVersion;

void vdpInit(Z80* z80, int vramPages, UInt32 systemTime, VdpVersion version);
void vdpDestroy();

void vdpSync(UInt32 systemTime);

UInt8 vdpRead(void* dummy, UInt16 ioPort, UInt32 systemTime);
UInt8 vdpReadStatus(void* dummy, UInt16 ioPort, UInt32 systemTime);

void vdpWrite(void* dummy, UInt16 ioPort, UInt8 value, UInt32 systemTime);
void vdpWriteLatch(void* dummy, UInt16 ioPort, UInt8 value, UInt32 systemTime);
void vdpWritePaletteLatch(void* dummy, UInt16 ioPort, UInt8 value, UInt32 systemTime);
void vdpWriteRegister(void* dummy, UInt16 ioPort, UInt8 value, UInt32 systemTime);

int vdpRefreshLine(UInt32 systemTime);

int vdpGetState(void* ref, UInt8* buffer, UInt32 systemTime);
int vdpSetState(void* ref, UInt8* buffer, UInt32 systemTime);


/* The following methods needs target dependent implementation */
extern void SetColor(int palEntry, UInt32 rgbColor);
extern void RefreshScreen(int, int, int);

#endif

