/*****************************************************************************
** File:        RomLoader.c
**
** Author:      Daniel Vik
**
** Description: Rom loader helper methods
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "RomLoader.h"
#include "ziphelper.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifndef NO_BIOS_ROMS_INCLUDE

#include "romARABIC.h"
#include "romDISK.h"
#include "romFMPAC.h"
#include "romKANJI.h"
#include "romMSX2.h"
#include "romMSX2EXT.h"
#include "romMSX2BR.h"
#include "romMSX2BREXT.h"
#include "romMSX2G.h"
#include "romMSX2GEXT.h"
#include "romMSX2FR.h"
#include "romMSX2FREXT.h"
#include "romMSX2J.h"
#include "romMSX2JEXT.h"
#include "romMSX2KR.h"
#include "romMSX2KREXT.h"
#include "romMSX2R.h"
#include "romMSX2REXT.h"
#include "romMSX2HAN.h"
#include "romMSX2P.h"
#include "romMSX2PEXT.h"
#include "romMSX2PMUS.h"
#include "romMSX.h"
#include "romMSXBR.h"
#include "romMSXHAN.h"
#include "romMSXJ.h"
#include "romMSXKANJI.h"
#include "romMSXKR.h"
#include "romSWP.h"
#include "romPAINT.h"
#include "romXBASIC2.h"
#include "romMOONSOUND.h"

#endif

#define TRY_COPY_INTERNAL(buf, size, fileName, romName)         \
    if (0 == strcmp(fileName, "internal/" #romName ".rom")) {   \
        buf = malloc(sizeof(rom##romName));                     \
        size = sizeof(rom##romName);                            \
        memcpy(buf, rom##romName, size);                        \
    }

UInt8* romLoad(const char *fileName, const char *fileInZipFile, int* size)
{
    UInt8* buf = NULL;
    FILE *file;

    if (fileName == NULL || strlen(fileName) == 0) {
        return NULL;
    }

    if (fileInZipFile != NULL && strlen(fileInZipFile) == 0) {
        fileInZipFile = NULL;
    }

    if (fileInZipFile == NULL) {
#ifndef NO_BIOS_ROMS_INCLUDE
        TRY_COPY_INTERNAL(buf, *size, fileName, ARABIC);
        TRY_COPY_INTERNAL(buf, *size, fileName, DISK);
        TRY_COPY_INTERNAL(buf, *size, fileName, FMPAC);
        TRY_COPY_INTERNAL(buf, *size, fileName, KANJI);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2EXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2BR);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2BREXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2FR);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2FREXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2G);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2GEXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2J);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2JEXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2KR);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2KREXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2R);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2REXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2HAN);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2P);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2PEXT);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX2PMUS);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSX);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSXBR);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSXHAN);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSXJ);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSXKANJI);
        TRY_COPY_INTERNAL(buf, *size, fileName, MSXKR);
        TRY_COPY_INTERNAL(buf, *size, fileName, SWP);
        TRY_COPY_INTERNAL(buf, *size, fileName, PAINT);
        TRY_COPY_INTERNAL(buf, *size, fileName, XBASIC2);
        TRY_COPY_INTERNAL(buf, *size, fileName, MOONSOUND);
#endif
        if (buf != NULL) {
            return buf;
        }
    }

    if (fileInZipFile != NULL) {
        return zipLoadFile(fileName, fileInZipFile, size);
    }

    file = fopen(fileName, "rb");
    if (file == NULL) {
        return NULL;
    }

    fseek(file, 0, SEEK_END);
    *size = ftell(file);

    fseek(file, 0, SEEK_SET);

    buf = malloc(*size);
    
    *size = fread(buf, 1, *size, file);
    fclose(file);

    return buf;
}

