/*****************************************************************************
** File:        Win32WaveCapture.c
**
** Author:      Daniel Vik
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "Win32WaveCapture.h"
#include <stdio.h>
#include <direct.h>

static int fileIndex = 0;
static char baseDir[512];

char* wavCaptureCreateFileName()
{
    static char fname[512];

    fileIndex++; 
    if (fileIndex > 9999) fileIndex = 0;
    sprintf(fname, "%s\\msx%04i.wav", baseDir, fileIndex);

    return fname;
}

void wavCaptureInit(char* directory)
{
    WIN32_FIND_DATA fileData;
    FILETIME writeTime;
    HANDLE hFile;
    char lastfile[512];
    char filename[512];
    char filenum[12];

    // save directory
    strcpy(baseDir, directory);

    // screenshot ammount
    fileIndex = 0;

    mkdir(baseDir);

    sprintf(filename, "%s\\msx????.wav", baseDir);

    hFile = FindFirstFile(filename,&fileData);
    if (hFile == INVALID_HANDLE_VALUE) {
        fileIndex = 0;
    } 
    else {
        writeTime = fileData.ftLastWriteTime;
        strcpy(lastfile,fileData.cFileName);
        while (FindNextFile(hFile, &fileData ) != 0) {
            if (CompareFileTime(&fileData.ftLastWriteTime, &writeTime) < 0) {
                break;
            }
            writeTime = fileData.ftLastWriteTime;
            strcpy(lastfile,fileData.cFileName);
        }
        // now make some sense out of it
        filenum[0]=lastfile[4];
        filenum[1]=lastfile[5];
        filenum[2]=lastfile[6];
        filenum[3]=lastfile[7];
        filenum[4]='\0';
        fileIndex=atoi(filenum);
    }
}

