/*****************************************************************************
** File:        Win32Timer.c
**
** Author:      Daniel Vik
**
** Description: Timer service (does currently not support muliple timers)
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include <windows.h>

typedef struct {
    HWND hwnd;
    MMRESULT timerId;
} Win32Timer;

 
DWORD GetSystemUpTime(DWORD frequency)
{
    static LONGLONG hfFrequency = 0;
    LARGE_INTEGER li;

    if (!hfFrequency) {
        if (QueryPerformanceFrequency(&li)) {
            hfFrequency = li.QuadPart;
        }
        else {
            return 0;
        }
    }

    QueryPerformanceCounter(&li);

    return (DWORD)(li.QuadPart * frequency / hfFrequency);
}

static void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
    syncCallback();
}

static void CALLBACK timerCallback(unsigned int unused1,
                                   unsigned int unused2,
                                   unsigned long unused3,
                                   unsigned long unused4,
                                   unsigned long unused5)
{
    syncCallback();
}

void* StartTimer(HWND hwnd, DWORD period, int useHiResTimer) {
    Win32Timer* win32Timer = (Win32Timer*)malloc(sizeof(Win32Timer));

    win32Timer->hwnd        = hwnd;
    win32Timer->timerId     = 0;
    
    if (useHiResTimer) {
        win32Timer->timerId = timeSetEvent(period, period, timerCallback, 0, TIME_PERIODIC);
    }
    if (win32Timer->timerId == 0) {
        SetTimer(hwnd, 0, period, TimerProc);
    }

    return win32Timer;
}

void StopTimer(void* pTimer) {
    Win32Timer* win32Timer = (Win32Timer*)pTimer;

    if (win32Timer == NULL) {
        return;
    }

    if (win32Timer->timerId != 0) {
        timeKillEvent(win32Timer->timerId);
    }
    else {
        KillTimer(win32Timer->hwnd, 0);
    }

    free(win32Timer);
}


