/*****************************************************************************
** File:
**      Common.h
**
** Author:
**      Daniel Vik
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "SpriteLine.h"

#define WIDTH  320
#define HEIGHT 240

extern UInt32* emuFrameBuffer;
extern int*    emuLineWidth;
extern UInt32  emuFixedPalette[256];
extern UInt32  emuFixedSpritePalette[16];
extern UInt32  emuPalette0;
extern UInt32  emuPalette[300];

static int FirstLine = 18;
static UInt8 emptylineBuf[256];

static UInt32 YJKColor(int Y,int J,int K);

extern UInt32 YJKtoYCbCrTable[32][32][32];

#define YJKColor(Y, J, K) YJKtoYCbCrTable[(Y)][(J) >> 1][(K) >> 1]

static void SetNewDrawPage() {
    FirstLine = firstLine - firstLineOffset;
    evenOddPage = 1 - evenOddPage;
}

UInt32 *RefreshBorder(int* y, UInt32 C, int line512, int borderExtra)
{
    int lineSize = line512 ? 2 : 1;
    UInt32 *P;
    int Y = *y;
    int H;

    /* Set up the transparent color */
    emuPalette[0] = (!BGColor || vdpIsColor0Solid(VDP)) ? emuPalette0 : emuPalette[BGColor];

    /* Return 0 if we've run out of the screen buffer due to overscan */
    if (Y >= HEIGHT) {
        return NULL;
    }

    /* Start of the buffer */
    P = emuFrameBuffer + evenOddPage * 2 * WIDTH * HEIGHT;

    /* Start of the line */
    P += 2 * WIDTH * Y;
    emuLineWidth[Y] = line512;

    if (Y > 0) {
        for (H = lineSize * ((WIDTH - 256) / 2 + HAdjust + borderExtra); H > 0; H--) {
            P[H - 1 - 2 * WIDTH] = C;
        }

        for(H = lineSize * ((WIDTH - 256) / 2 - HAdjust + borderExtra); H > 0; H--) {
            P[lineSize * WIDTH - H - 2 * WIDTH] = C;
        }
    }

    if (!(vdpIsScreenOn(VDP) && Drawing)) {
        for(H = lineSize * WIDTH - 1; H >= 0; H--) {
            P[H] = C;
        }

        return NULL;
    }

    *y = *y - FirstLine;

    /* Return pointer to the scanline in emuFrameBuffer */
    return P + lineSize * ((WIDTH - 256) / 2 + HAdjust + borderExtra);
}


static void RefreshLine0(int Y, int X)
{
    UInt32 *P,FC,BC;
    UInt8 *T,*G;

    if (X != 0) {
        return;
    }

    BC = emuPalette[BGColor];
    P = RefreshBorder(&Y, BC, 0, 8);
    if (P == NULL) {
        return;
    }

    Y -= scr0splitLine;
    G = &VRAM[ChrGenO + (((Y & 0xFF) + VScroll) & 0x07)];
    T = &VRAM[ChrTabO + 40 * ((Y & 0xFF) >> 3)];
    FC=emuPalette[FGColor];

    for(X=0;X<40;X++,T++,P+=6)
    {
        Y=G[(int)*T<<3];
        P[0]=Y&0x80? FC:BC;
        P[1]=Y&0x40? FC:BC;
        P[2]=Y&0x20? FC:BC;
        P[3]=Y&0x10? FC:BC;
        P[4]=Y&0x08? FC:BC;
        P[5]=Y&0x04? FC:BC;
    }
}

static void RefreshLine1(int Y, int X)
{
    static UInt32 *P = NULL;
    static UInt8 *T,*G;
    static UInt8* sprLine;
    UInt32 FC,BC;
    int K;
    int col;

    if (X == 0) {
        P = RefreshBorder(&Y, emuPalette[BGColor], 0, 0);
        if (P == NULL) {
            return;
        }

        sprLine = spritesLine((Y & 0xFF));

        Y += VScroll;
        G = &VRAM[ChrGenO + (Y & 0x07)];
        T = &VRAM[ChrTabO + ((int)(Y & 0xF8) << 2)];
    }

    if (P == NULL) {
        return;
    }

    K = VRAM[ColTabO + (*T >> 3)];
    FC = emuPalette[K >> 4];
    BC = emuPalette[K & 0x0F];
    K = G[(int)*T << 3];

    col = sprLine[0]; P[0] = col ? emuPalette[col] : K & 0x80 ? FC : BC; 
    col = sprLine[1]; P[1] = col ? emuPalette[col] : K & 0x40 ? FC : BC;
    col = sprLine[2]; P[2] = col ? emuPalette[col] : K & 0x20 ? FC : BC; 
    col = sprLine[3]; P[3] = col ? emuPalette[col] : K & 0x10 ? FC : BC;
    col = sprLine[4]; P[4] = col ? emuPalette[col] : K & 0x08 ? FC : BC; 
    col = sprLine[5]; P[5] = col ? emuPalette[col] : K & 0x04 ? FC : BC;
    col = sprLine[6]; P[6] = col ? emuPalette[col] : K & 0x02 ? FC : BC; 
    col = sprLine[7]; P[7] = col ? emuPalette[col] : K & 0x01 ? FC : BC;

    T++; P += 8; sprLine += 8;
}

static void RefreshLine2(int Y, int X)
{
    static UInt32 *P = NULL;
    static UInt8 *T;
    static UInt8* sprLine;
    static int I;
    int J,K;
    UInt32 FC,BC;
    UInt8 col;

    if (X == 0) {
        P = RefreshBorder(&Y,  emuPalette[BGColor], 0, 0);
        if (P == NULL) {
            return;
        }

        sprLine = spritesLine((Y & 0xFF));

        Y += VScroll;
        T = &VRAM[ChrTabO + ((int)(Y & 0xF8) << 2)];
        I =((int)(Y&0xC0)<<5)+(Y&0x07);
    }

    if (P == NULL) {
        return;
    }

    J=(int)*T<<3;
    K =  VRAM[ColTabO + ((I + J) & ColTabM)];
    FC = emuPalette[K>>4];
    BC = emuPalette[K&0x0F];
    K =  VRAM[ChrGenO + ((I + J) & ChrGenM)];

    col = sprLine[0]; P[0] = col ? emuPalette[col] : K & 0x80 ? FC : BC; 
    col = sprLine[1]; P[1] = col ? emuPalette[col] : K & 0x40 ? FC : BC;
    col = sprLine[2]; P[2] = col ? emuPalette[col] : K & 0x20 ? FC : BC; 
    col = sprLine[3]; P[3] = col ? emuPalette[col] : K & 0x10 ? FC : BC;
    col = sprLine[4]; P[4] = col ? emuPalette[col] : K & 0x08 ? FC : BC; 
    col = sprLine[5]; P[5] = col ? emuPalette[col] : K & 0x04 ? FC : BC;
    col = sprLine[6]; P[6] = col ? emuPalette[col] : K & 0x02 ? FC : BC; 
    col = sprLine[7]; P[7] = col ? emuPalette[col] : K & 0x01 ? FC : BC;

    T++; P += 8; sprLine += 8;
}

static void RefreshLine3(int Y, int X)
{
    static UInt32 *P = NULL;
    static UInt8 *T,*G;
    static UInt8* sprLine;
    UInt32 FC,BC;
    UInt8 col;
    UInt8 K;

    if (X == 0) {
        P = RefreshBorder(&Y, emuPalette[BGColor], 0, 0);
        if (P == NULL) {
            return;
        }

        sprLine = spritesLine((Y & 0xFF));

        Y += VScroll;
        T = &VRAM[ChrTabO + ((int)(Y & 0xF8) << 2)];
        G = &VRAM[ChrGenO + ((Y & 0x1C) >> 2)];
    }

    if (P == NULL) {
        return;
    }

    K = G[(int)*T << 3];
    FC = emuPalette[K >> 4];
    BC = emuPalette[K & 0x0F];

    col = sprLine[0]; P[0] = col ? emuPalette[col] : FC; 
    col = sprLine[1]; P[1] = col ? emuPalette[col] : FC;
    col = sprLine[2]; P[2] = col ? emuPalette[col] : FC; 
    col = sprLine[3]; P[3] = col ? emuPalette[col] : FC;
    col = sprLine[4]; P[4] = col ? emuPalette[col] : BC; 
    col = sprLine[5]; P[5] = col ? emuPalette[col] : BC;
    col = sprLine[6]; P[6] = col ? emuPalette[col] : BC; 
    col = sprLine[7]; P[7] = col ? emuPalette[col] : BC;

    T++; P += 8; sprLine += 8;
}

static void RefreshLine4(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    static int hScroll;
    static int hScroll512;
    static int* jump;
    static int page;
    static int scroll;
    static int I;
    UInt32 FC,BC;
    int C, J, K;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y, emuPalette[BGColor], 0, 0);
        if (P == NULL) {
            return;
        }

        hScroll    =  ((((int)(VDP[26] & 0x3F & ~(~HScroll512 << 5))) << 3) - (int)(VDP[27] & 0x07) & 0xffffffff);
        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        page       = (ChrTabO / 0x8000) & 1;
        scroll     = hScroll >> 3;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        Y += VScroll;
        T = &VRAM[ChrTabO + ((int)(Y & 0xf8) << 2) + scroll];
        I = ((int)(Y & 0xC0) << 5) + (Y & 0x07);

        if (vdpIsEdgeMasked(VDP)) {
            C = R[0]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[1]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[2]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[3]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[4]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[5]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[6]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            C = R[7]; *P++ = C ? emuPalette[C >> 1] : emuPalette[BGColor];
            T++; 
            X++;
            R += 8;
        }

        if (hScroll512) {
            if (scroll & 0x20) T -= 32;
        }

        J  = (int)*T << 3;
        K  = VRAM[ColTabO + ((I + J) & ColTabM)];
        FC = emuPalette[K >> 4];
        BC = emuPalette[K & 0x0F];
        K  = VRAM[ChrGenO + ((I + J) & ChrGenM)];

        switch (hScroll & 7) {
            case 1: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x40)? FC : BC;
            case 2: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x20)? FC : BC;
            case 3: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x10)? FC : BC;
            case 4: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x08)? FC : BC;
            case 5: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x04)? FC : BC;
            case 6: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x02)? FC : BC;
            case 7: C = *R++; *P++ = C ? emuPalette[C >> 1] : (K & 0x01)? FC : BC; T++;
        }

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

    J  = (int)*T << 3;
    K  = VRAM[ColTabO + ((I + J) & ColTabM)];
    FC = emuPalette[K >> 4];
    BC = emuPalette[K & 0x0F];
    K  = VRAM[ChrGenO + ((I + J) & ChrGenM)];

    C = R[0]; P[0] = C ? emuPalette[C >> 1] : (K & 0x80)? FC : BC;
    C = R[1]; P[1] = C ? emuPalette[C >> 1] : (K & 0x40)? FC : BC;
    C = R[2]; P[2] = C ? emuPalette[C >> 1] : (K & 0x20)? FC : BC;
    C = R[3]; P[3] = C ? emuPalette[C >> 1] : (K & 0x10)? FC : BC;
    C = R[4]; P[4] = C ? emuPalette[C >> 1] : (K & 0x08)? FC : BC;
    C = R[5]; P[5] = C ? emuPalette[C >> 1] : (K & 0x04)? FC : BC;
    C = R[6]; P[6] = C ? emuPalette[C >> 1] : (K & 0x02)? FC : BC;
    C = R[7]; P[7] = C ? emuPalette[C >> 1] : (K & 0x01)? FC : BC;

    R += 8; P += 8; T++;
}

static void RefreshLine5(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt32 *P = NULL;
    static UInt8 *T, *R;
    static int addrSwitch;
    static int hScroll512;
    static int* jump;
    static int page;
    static int scroll;
    static int hScroll;
    int I;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y,  emuPalette[BGColor], 0, 0);
        if (P == NULL) {
            return;
        }

        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        page       = (ChrTabO / 0x8000) & 1;
        hScroll    = HScroll;
        scroll     = hScroll / 2;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll];

        if (vdpIsEdgeMasked(VDP)) {
            I=R[0]; P[0]=emuPalette[I? I >> 1:BGColor];
            I=R[1]; P[1]=emuPalette[I? I >> 1:BGColor];
            I=R[2]; P[2]=emuPalette[I? I >> 1:BGColor];
            I=R[3]; P[3]=emuPalette[I? I >> 1:BGColor];
            I=R[4]; P[4]=emuPalette[I? I >> 1:BGColor];
            I=R[5]; P[5]=emuPalette[I? I >> 1:BGColor];
            I=R[6]; P[6]=emuPalette[I? I >> 1:BGColor];
            I=R[7]; P[7]=emuPalette[I? I >> 1:BGColor];
            X++;R+=8;P+=8;T+=4;scroll+=4;
        }

        if (hScroll512) {
            if (scroll & 0x80) T += jump[page ^= 1];
            if (VDP[2] & 0x60) T += jump[page ^= 1] + 128;
        }
        else {
            if (scroll < 0) T += 128;
        }

#define addrSwitch 0
//        addrSwitch = (VDP[9] >> 2) & 1;

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

#define UPDATE_T() if ((++scroll & 0x7f) == 0) T += jump[page ^= 1];

    if (hScroll & 1) {
        I=R[0]; P[0]=emuPalette[I? I >> 1:T[0 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[1]; P[1]=emuPalette[I? I >> 1:T[1 ^ addrSwitch]>>4];  ;
        I=R[2]; P[2]=emuPalette[I? I >> 1:T[1 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[3]; P[3]=emuPalette[I? I >> 1:T[2 ^ addrSwitch]>>4];  ;
        I=R[4]; P[4]=emuPalette[I? I >> 1:T[2 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[5]; P[5]=emuPalette[I? I >> 1:T[3 ^ addrSwitch]>>4];  ;
        I=R[6]; P[6]=emuPalette[I? I >> 1:T[3 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[7]; P[7]=emuPalette[I? I >> 1:T[4 ^ addrSwitch]>>4];  ;
    }
    else {     
        I=R[0]; P[0]=emuPalette[I? I >> 1:T[0 ^ addrSwitch]>>4];  ;
        I=R[1]; P[1]=emuPalette[I? I >> 1:T[0 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[2]; P[2]=emuPalette[I? I >> 1:T[1 ^ addrSwitch]>>4];  ;
        I=R[3]; P[3]=emuPalette[I? I >> 1:T[1 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[4]; P[4]=emuPalette[I? I >> 1:T[2 ^ addrSwitch]>>4];  ;
        I=R[5]; P[5]=emuPalette[I? I >> 1:T[2 ^ addrSwitch]&0x0F];UPDATE_T();
        I=R[6]; P[6]=emuPalette[I? I >> 1:T[3 ^ addrSwitch]>>4];  ;
        I=R[7]; P[7]=emuPalette[I? I >> 1:T[3 ^ addrSwitch]&0x0F];UPDATE_T();
    }

#undef UPDATE_T

    R += 8; P += 8; T += 4;
}

static void RefreshLine6(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static int* jump;
    static int hScroll512;
    static int scroll;
    static int scrPage;
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    int I;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y, emuPalette[BGColor & 0x03], 1, 0);
        if (P == NULL) {
            return;
        }
        
        hScroll512 = HScroll512;
        scroll     = HScroll & 0x1ff;
        jump       = jumpTable + hScroll512 * 2;
        scrPage    = (ChrTabO / 0x8000) & 1;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];
        
        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
            if (VDP[2] & 0x60) T += jump[scrPage ^= 1] + 128;
        }

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

#define UPDATE_T() if ((++scroll & 0xff) == 0) T += jump[scrPage ^= 1];

    if (scroll & 1) {
        (I = R[0]) ? P[0]  = P[1]  = emuPalette[(I >> 1) & 3] : (I = T[0], P[0]  = emuPalette[(I >> 2) & 3], P[1]  = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[1]) ? P[2]  = P[3]  = emuPalette[(I >> 1) & 3] : (I = T[1], P[2]  = emuPalette[(I >> 6) & 3], P[3]  = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[2]) ? P[4]  = P[5]  = emuPalette[(I >> 1) & 3] : (I = T[1], P[4]  = emuPalette[(I >> 2) & 3], P[5]  = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[3]) ? P[6]  = P[7]  = emuPalette[(I >> 1) & 3] : (I = T[2], P[6]  = emuPalette[(I >> 6) & 3], P[7]  = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[4]) ? P[8]  = P[9]  = emuPalette[(I >> 1) & 3] : (I = T[2], P[8]  = emuPalette[(I >> 2) & 3], P[9]  = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[5]) ? P[10] = P[11] = emuPalette[(I >> 1) & 3] : (I = T[3], P[10] = emuPalette[(I >> 6) & 3], P[11] = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[6]) ? P[12] = P[13] = emuPalette[(I >> 1) & 3] : (I = T[3], P[12] = emuPalette[(I >> 2) & 3], P[13] = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[7]) ? P[14] = P[15] = emuPalette[(I >> 1) & 3] : (I = T[4], P[14] = emuPalette[(I >> 6) & 3], P[15] = emuPalette[(I >> 4) & 3]); UPDATE_T();
    }
    else {
        (I = R[0]) ? P[0]  = P[1]  = emuPalette[(I >> 1) & 3] : (I = T[0], P[0]  = emuPalette[(I >> 6) & 3], P[1]  = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[1]) ? P[2]  = P[3]  = emuPalette[(I >> 1) & 3] : (I = T[0], P[2]  = emuPalette[(I >> 2) & 3], P[3]  = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[2]) ? P[4]  = P[5]  = emuPalette[(I >> 1) & 3] : (I = T[1], P[4]  = emuPalette[(I >> 6) & 3], P[5]  = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[3]) ? P[6]  = P[7]  = emuPalette[(I >> 1) & 3] : (I = T[1], P[6]  = emuPalette[(I >> 2) & 3], P[7]  = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[4]) ? P[8]  = P[9]  = emuPalette[(I >> 1) & 3] : (I = T[2], P[8]  = emuPalette[(I >> 6) & 3], P[9]  = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[5]) ? P[10] = P[11] = emuPalette[(I >> 1) & 3] : (I = T[2], P[10] = emuPalette[(I >> 2) & 3], P[11] = emuPalette[(I >> 0) & 3]); UPDATE_T();
        (I = R[6]) ? P[12] = P[13] = emuPalette[(I >> 1) & 3] : (I = T[3], P[12] = emuPalette[(I >> 6) & 3], P[13] = emuPalette[(I >> 4) & 3]); UPDATE_T();
        (I = R[7]) ? P[14] = P[15] = emuPalette[(I >> 1) & 3] : (I = T[3], P[14] = emuPalette[(I >> 2) & 3], P[15] = emuPalette[(I >> 0) & 3]); UPDATE_T();
    }

#undef UPDATE_T

    R += 8; P += 16; T += 4;
}

static void RefreshLine7(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    static int hScroll512;
    static int scrPage;
    static int* jump;
    static int scroll;
//    static int vscroll;
    int I;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y, emuPalette[BGColor], 1, 0);
        if (P == NULL) {
            return;
        }
        
        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        scrPage    = (ChrTabO / 0x8000) & 1;
        scroll     = HScroll;

//        vscroll = VScroll;
        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];

        if (vdpIsEdgeMasked(VDP)) {
            UInt32 bgColor = emuPalette[BGColor];
            P[0]  = P[1]  = (I = R[0]) ? emuPalette[I >> 1] : bgColor;
            P[2]  = P[3]  = (I = R[1]) ? emuPalette[I >> 1] : bgColor;
            P[4]  = P[5]  = (I = R[2]) ? emuPalette[I >> 1] : bgColor;
            P[6]  = P[7]  = (I = R[3]) ? emuPalette[I >> 1] : bgColor;
            P[8]  = P[9]  = (I = R[4]) ? emuPalette[I >> 1] : bgColor;
            P[10] = P[11] = (I = R[5]) ? emuPalette[I >> 1] : bgColor;
            P[12] = P[13] = (I = R[6]) ? emuPalette[I >> 1] : bgColor;
            P[14] = P[15] = (I = R[7]) ? emuPalette[I >> 1] : bgColor;
            X++, R += 8, P += 16, T += 4; scroll += 8;
        }

        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
            if (VDP[2] & 0x60) T += jump[scrPage ^= 1] + 128;
        }
        else {
            if (scroll < 0) T += 128;
        }

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }
#if 0
    if (vscroll != VScroll) {
        int scroll = HScroll;
        vscroll = VScroll;
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];

        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
            if (VDP[2] & 0x60) T += jump[scrPage ^= 1] + 128;
        }
        else {
            if (scroll < 0) T += 128;
        }

        T += 4 * X;
    }
#endif
#define UPDATE_T() if ((++scroll & 0xff) == 0) T += jump[scrPage ^= 1];

    if (scroll & 1) {
        (I = R[0]) ? P[0]  = P[1]  = emuPalette[I >> 1] : (I = T[0x10000], P[0]  = emuPalette[I >> 4], P[1]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[1]) ? P[2]  = P[3]  = emuPalette[I >> 1] : (I = T[1],       P[2]  = emuPalette[I >> 4], P[3]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[2]) ? P[4]  = P[5]  = emuPalette[I >> 1] : (I = T[0x10000], P[4]  = emuPalette[I >> 4], P[5]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[3]) ? P[6]  = P[7]  = emuPalette[I >> 1] : (I = T[2],       P[6]  = emuPalette[I >> 4], P[7]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[4]) ? P[8]  = P[9]  = emuPalette[I >> 1] : (I = T[0x10000], P[8]  = emuPalette[I >> 4], P[9]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[5]) ? P[10] = P[11] = emuPalette[I >> 1] : (I = T[3],       P[10] = emuPalette[I >> 4], P[11] = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[6]) ? P[12] = P[13] = emuPalette[I >> 1] : (I = T[0x10000], P[12] = emuPalette[I >> 4], P[13] = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[7]) ? P[14] = P[15] = emuPalette[I >> 1] : (I = T[4],       P[14] = emuPalette[I >> 4], P[15] = emuPalette[I & 0xf]); UPDATE_T();
    }
    else {
        (I = R[0]) ? P[0]  = P[1]  = emuPalette[I >> 1] : (I = T[0],       P[0]  = emuPalette[I >> 4], P[1]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[1]) ? P[2]  = P[3]  = emuPalette[I >> 1] : (I = T[0x10000], P[2]  = emuPalette[I >> 4], P[3]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[2]) ? P[4]  = P[5]  = emuPalette[I >> 1] : (I = T[1],       P[4]  = emuPalette[I >> 4], P[5]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[3]) ? P[6]  = P[7]  = emuPalette[I >> 1] : (I = T[0x10001], P[6]  = emuPalette[I >> 4], P[7]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[4]) ? P[8]  = P[9]  = emuPalette[I >> 1] : (I = T[2],       P[8]  = emuPalette[I >> 4], P[9]  = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[5]) ? P[10] = P[11] = emuPalette[I >> 1] : (I = T[0x10002], P[10] = emuPalette[I >> 4], P[11] = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[6]) ? P[12] = P[13] = emuPalette[I >> 1] : (I = T[3],       P[12] = emuPalette[I >> 4], P[13] = emuPalette[I & 0xf]); UPDATE_T();
        (I = R[7]) ? P[14] = P[15] = emuPalette[I >> 1] : (I = T[0x10003], P[14] = emuPalette[I >> 4], P[15] = emuPalette[I & 0xf]); UPDATE_T();
    }

#undef UPDATE_T

    R += 8; P += 16; T += 4;
}

static void RefreshLine8(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt8 SprToScr[16] = { 0x00,0x02,0x10,0x12,0x80,0x82,0x90,0x92, 0x49,0x4B,0x59,0x5B,0xC9,0xCB,0xD9,0xDB };
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    static int hScroll;
    static int hScroll512;
    static int* jump;
    static int scrPage;
    static int scroll;
    int C;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y, emuFixedPalette[VDP[7]], 0, 0);
        if (P == NULL) {
            return;
        }
        
        hScroll    = HScroll;
        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        scrPage    = (ChrTabO / 0x8000) & 1;
        scroll     = hScroll;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];

        if (vdpIsEdgeMasked(VDP)) {
            C=R[0];P[0]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[1];P[1]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[2];P[2]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[3];P[3]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[4];P[4]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[5];P[5]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[6];P[6]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            C=R[7];P[7]=C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[BGColor];
            X++, T += 4, R += 8, P += 8; scroll += 8;
        }

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
        }
        else {
            if (scroll < 0) T += 128;
        }

        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

#define UPDATE_T() if ((++scroll & 0xff) == 0) T += jump[scrPage ^= 1];

    if (scroll & 1) {
        C = R[0]; P[0] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10000]]; UPDATE_T();
        C = R[1]; P[1] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[1]]; UPDATE_T();
        C = R[2]; P[2] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10001]]; UPDATE_T();
        C = R[3]; P[3] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[2]]; UPDATE_T();
        C = R[4]; P[4] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10002]]; UPDATE_T();
        C = R[5]; P[5] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[3]]; UPDATE_T();
        C = R[6]; P[6] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10003]]; UPDATE_T();
        C = R[7]; P[7] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[4]]; UPDATE_T();
    }
    else {
        C = R[0]; P[0] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0]]; UPDATE_T();
        C = R[1]; P[1] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10000]]; UPDATE_T();
        C = R[2]; P[2] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[1]]; UPDATE_T();
        C = R[3]; P[3] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10001]]; UPDATE_T();
        C = R[4]; P[4] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[2]]; UPDATE_T();
        C = R[5]; P[5] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10002]]; UPDATE_T();
        C = R[6]; P[6] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[3]]; UPDATE_T();
        C = R[7]; P[7] = C? emuFixedSpritePalette[C >> 1]:emuFixedPalette[T[0x10003]]; UPDATE_T();
    }
#undef UPDATE_T

    T += 4; R += 8; P += 8;
}

static void RefreshLine10(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    static int hScroll512;
    static int* jump;
    static int scrPage;
    static int scroll;
    UInt8 t0, t1, t2, t3;
    int J,K;
    int C;

    if (scrLine == 0) {      
        R = emptylineBuf;
    }

    if (X == 0) {
        P = RefreshBorder(&Y,  emuFixedPalette[VDP[7]], 0, 0);
        if (P == NULL) {
            return;
        }
        
        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        scrPage    = (ChrTabO / 0x8000) & 1;
        scroll     = HScroll & ~3;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];

        if (vdpIsEdgeMasked(VDP)) {
            C=R[0];P[0]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[1];P[1]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[2];P[2]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[3];P[3]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[0];P[0]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[1];P[1]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[2];P[2]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            C=R[3];P[3]=C? emuPalette[C >> 1]:emuFixedPalette[VDP[7]];
            X++, T += 4, R += 8, P += 8; scroll += 8;
        }

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
            if (VDP[2] & 0x60) T += jump[scrPage ^= 1] + 128;
        }

        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

#define UPDATE_T() if ((++scroll & 0xff) == 0) T += jump[scrPage ^= 1];

        t0 = T[0];        UPDATE_T();
        t1 = T[0x10000];  UPDATE_T();
        t2 = T[1];        UPDATE_T();
        t3 = T[0x10001];  UPDATE_T();

        K = (t0 & 0x07) | ((t1 & 0x07) << 3);
        J = (t2 & 0x07) | ((t3 & 0x07) << 3);

        switch (HScroll & 3) {
        case 0:
            C = R[0]; Y = t0 >> 3; *P++ = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        case 1:
            C = R[1]; Y = t1 >> 3; *P++ = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        case 2:
            C = R[2]; Y = t2 >> 3; *P++ = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        case 3:
            C = R[3]; Y = t3 >> 3; *P++ = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        }

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

    t0 = T[0];        UPDATE_T();
    t1 = T[0x10000];  UPDATE_T();
    t2 = T[1];        UPDATE_T();
    t3 = T[0x10001];  UPDATE_T();

    K = (t0 & 0x07) | ((t1 & 0x07) << 3);
    J = (t2 & 0x07) | ((t3 & 0x07) << 3);

    C = R[0]; Y = t0 >> 3; P[0] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
    C = R[1]; Y = t1 >> 3; P[1] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
    C = R[2]; Y = t2 >> 3; P[2] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
    C = R[3]; Y = t3 >> 3; P[3] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);

    t0 = T[2];        UPDATE_T();
    t1 = T[0x10002];  UPDATE_T();
    t2 = T[3];        UPDATE_T();
    t3 = T[0x10003];  UPDATE_T();

    K = (t0 & 0x07) | ((t1 & 0x07) << 3);
    J = (t2 & 0x07) | ((t3 & 0x07) << 3);

    if (X == 31) {
        switch (HScroll & 3) {
        case 1:
            C = R[6]; Y = t2 >> 3; P[6] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        case 2:
            C = R[5]; Y = t1 >> 3; P[5] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        case 3:
            C = R[4]; Y = t0 >> 3; P[4] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        }
    }
    else {
        C = R[4]; Y = t0 >> 3; P[4] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        C = R[5]; Y = t1 >> 3; P[5] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        C = R[6]; Y = t2 >> 3; P[6] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
        C = R[7]; Y = t3 >> 3; P[7] = C ? emuPalette[C >> 1] : Y & 1 ? emuPalette[Y >> 1] : YJKColor(Y, J, K);
    }
#undef UPDATE_T

    T += 4; R += 8; P += 8;
}

static void RefreshLine12(int Y, int X)
{
    static int jumpTable[] = { -128, -128, -0x8080, 0x7f80 };
    static UInt32 *P = NULL;
    static UInt8 *T,*R;
    static int hScroll512;
    static int* jump;
    static int scrPage;
    static int scroll;
    int C;
    UInt8 t0, t1, t2, t3;
    int J,K;

    if (X == 0) {
        P = RefreshBorder(&Y, emuFixedPalette[VDP[7]], 0, 0);
        if (P == NULL) {
            return;
        }
        
        hScroll512 = HScroll512;
        jump       = jumpTable + hScroll512 * 2;
        scrPage    = (ChrTabO / 0x8000) & 1;
        scroll     = HScroll & ~3;

        R = colorSpritesLine(Y, vdpIsColor0Solid(VDP));
        T = &VRAM[ChrTabO + (((Y + VScroll) << 7) & ChrTabM) + scroll / 2];

    #if 0
        if (vdpIsEdgeMasked(VDP)) {
            P[0] = emuFixedPalette[VDP[7]];
            P[1] = emuFixedPalette[VDP[7]];
            P[2] = emuFixedPalette[VDP[7]];
            P[3] = emuFixedPalette[VDP[7]];
            P[4] = emuFixedPalette[VDP[7]];
            P[5] = emuFixedPalette[VDP[7]];
            P[6] = emuFixedPalette[VDP[7]];
            P[7] = emuFixedPalette[VDP[7]];
            X++, T += 4, R += 8, P += 8; scroll += 8;
        }
    #endif

        if (hScroll512) {
            if (scroll & 0x100) T += jump[scrPage ^= 1];
            if (VDP[2] & 0x60) T += jump[scrPage ^= 1] + 128;
        }

        if (vdpIsInterlaceOn(VDP) && !evenOddPage && vdpIsOddPage(VDP)) T += jump[2 | (scrPage ^= 1)] + 128;

#define UPDATE_T() if ((++scroll & 0xff) == 0) T += jump[scrPage ^= 1];

        t0 = T[0];        UPDATE_T();
        t1 = T[0x10000];  UPDATE_T();
        t2 = T[1];        UPDATE_T();
        t3 = T[0x10001];  UPDATE_T();

        K=(t0 & 0x07) | ((t1 & 0x07) << 3);
        J=(t2 & 0x07) | ((t3 & 0x07) << 3);

        switch (HScroll & 3) {
        case 0:
            C = R[0]; *P++ = C ? emuPalette[C >> 1] : YJKColor(t0 >> 3, J, K);
        case 1:
            C = R[1]; *P++ = C ? emuPalette[C >> 1] : YJKColor(t1 >> 3, J, K);
        case 2:
            C = R[2]; *P++ = C ? emuPalette[C >> 1] : YJKColor(t2 >> 3, J, K);
        case 3:
            C = R[3]; *P++ = C ? emuPalette[C >> 1] : YJKColor(t3 >> 3, J, K);
        }

        T += 2; R += 4;

        if (X > 0) {
            return;
        }
    }

    if (P == NULL) {
        return;
    }

    t0 = T[0];        UPDATE_T();
    t1 = T[0x10000];  UPDATE_T();
    t2 = T[1];        UPDATE_T();
    t3 = T[0x10001];  UPDATE_T();

    K=(t0 & 0x07) | ((t1 & 0x07) << 3);
    J=(t2 & 0x07) | ((t3 & 0x07) << 3);

    C = R[0]; P[0] = C ? emuPalette[C >> 1] : YJKColor(t0 >> 3, J, K);
    C = R[1]; P[1] = C ? emuPalette[C >> 1] : YJKColor(t1 >> 3, J, K);
    C = R[2]; P[2] = C ? emuPalette[C >> 1] : YJKColor(t2 >> 3, J, K);
    C = R[3]; P[3] = C ? emuPalette[C >> 1] : YJKColor(t3 >> 3, J, K);

    t0 = T[2];        UPDATE_T();
    t1 = T[0x10002];  UPDATE_T();
    t2 = T[3];        UPDATE_T();
    t3 = T[0x10003];  UPDATE_T();

    K=(t0 & 0x07) | ((t1 & 0x07) << 3);
    J=(t2 & 0x07) | ((t3 & 0x07) << 3);

    if (X == 31) {
        switch (HScroll & 3) {
        case 1:
            C = R[6]; P[6] = C ? emuPalette[C >> 1] : YJKColor(t2 >> 3, J, K);
        case 2:
            C = R[5]; P[5] = C ? emuPalette[C >> 1] : YJKColor(t1 >> 3, J, K);
        case 3:
            C = R[4]; P[4] = C ? emuPalette[C >> 1] : YJKColor(t0 >> 3, J, K);
        }
    }
    else {
        C = R[4]; P[4] = C ? emuPalette[C >> 1] : YJKColor(t0 >> 3, J, K);
        C = R[5]; P[5] = C ? emuPalette[C >> 1] : YJKColor(t1 >> 3, J, K);
        C = R[6]; P[6] = C ? emuPalette[C >> 1] : YJKColor(t2 >> 3, J, K);
        C = R[7]; P[7] = C ? emuPalette[C >> 1] : YJKColor(t3 >> 3, J, K);
    }
#undef UPDATE_T

    T += 4; R += 8; P += 8;
}

static void RefreshLineTx80(int Y, int X)
{
    UInt32 *P,FC,BC;
    UInt8 M,*T,*C,*G;

    if (X != 0) {
        return;
    }

    BC = emuPalette[BGColor];
    P = RefreshBorder(&Y, BC, 1, 8);
    if (P == NULL) {
        return;
    }

    Y -= scr0splitLine;
    G = &VRAM[ChrGenO + ((Y + VScroll) & 0x07)];
    T = &VRAM[ChrTabO + ((80 * (Y >> 3)) & ChrTabM)];
    C = &VRAM[ColTabO + ((10 * (Y >> 3)) & ColTabM)];

    for(X = 0, M = 0; X < 80; X++, T++, P += 6) {
        if(!(X&0x07)) M=*C++;
        if(M&0x80) { FC=emuPalette[XFGColor];BC=emuPalette[XBGColor]; }
        else       { FC=emuPalette[FGColor];BC=emuPalette[BGColor]; }
        M<<=1;
        Y=G[(int)*T<<3];
        P[0]=Y&0x80? FC:BC;
        P[1]=Y&0x40? FC:BC;
        P[2]=Y&0x20? FC:BC;
        P[3]=Y&0x10? FC:BC;
        P[4]=Y&0x08? FC:BC;
        P[5]=Y&0x04? FC:BC;
    }
}

