/*****************************************************************************
** File:        Win32FileHistory.c
**
** Author:      Daniel Vik
**
** Description: Methods manage the file history.
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include <stdio.h>
#include <windows.h>
#include "Win32FileHistory.h"
#include "Win32Properties.h"
 
char* stripPathExt(char* filename) {
    static char buffer[128];
    
    strcpy(buffer, stripPath(filename));

    if (buffer[strlen(buffer) - 4] == '.') {
        buffer[strlen(buffer) - 4] = 0;
    }

    return buffer;
}

char* stripPath(char* filename) {
    char* ptr = filename + strlen(filename) - 1;

    while (--ptr >= filename) {
        if (*ptr == '/' || *ptr == '\\') {
            return ptr + 1;
        }
    }

    return filename;
}

void updateFileHistory(char* history, char* filename) {
    char fname[MAX_PATH];
    int i = 0;

    strcpy(fname, filename);

    for (i = 0; i < MAX_HISTORY - 1; i++) {
        if (*(history + MAX_PATH * i) == 0 || 0 == strcmp(history + MAX_PATH * i, fname)) {
            break;
        }
    }
    while (i > 0) {
        strcpy(history + MAX_PATH * i, history + MAX_PATH * (i - 1));
        i--;
    }
    strcpy(history, fname);
}

void verifyFileHistory(char* history) {
    int i, j;

    for (i = 0; i < MAX_HISTORY; i++) {
        char *fname = history + MAX_PATH * i;
        if (fname[0] != '\0' && 
            strcmp(fname, CARTNAME_SCCPLUS) && 
            strcmp(fname, CARTNAME_FMPAC) && 
            strcmp(fname, CARTNAME_PAC) && 
            strcmp(fname, CARTNAME_MEGARAM128) && 
            strcmp(fname, CARTNAME_MEGARAM256) && 
            strcmp(fname, CARTNAME_MEGARAM512) && 
            strcmp(fname, CARTNAME_MEGARAM768) && 
            strcmp(fname, CARTNAME_MEGARAM2M)) {
            FILE* file = fopen(fname, "r");
            if (file != NULL) {
                fclose(file);
            }

            else {
                for (j = i + 1; j < MAX_HISTORY; j++) {
                    strcpy(history + MAX_PATH * (j - 1), history + MAX_PATH * j);
                    *(history + MAX_PATH * j) = 0;
                }
                i--;
            }
        }
    }
}
